/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.DefaultElement;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class DatatypeElement
extends DefaultElement
implements SerializationContext,
ValidationContext {
    private XSDatatype datatype;
    private Object data;

    public DatatypeElement(QName qName, XSDatatype xSDatatype) {
        super(qName);
        this.datatype = xSDatatype;
    }

    public DatatypeElement(QName qName, int n2, XSDatatype xSDatatype) {
        super(qName, n2);
        this.datatype = xSDatatype;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + this.hashCode() + " [Element: <" + this.getQualifiedName() + " attributes: " + this.attributeList() + " data: " + ((AbstractElement)this).getData() + " />]";
    }

    public XSDatatype getXSDatatype() {
        return this.datatype;
    }

    @Override
    public String getNamespacePrefix(String object) {
        if ((object = ((AbstractElement)this).getNamespaceForURI((String)object)) != null) {
            return ((Namespace)object).getPrefix();
        }
        return null;
    }

    @Override
    public String getBaseUri() {
        return null;
    }

    @Override
    public boolean isNotation(String string) {
        return false;
    }

    @Override
    public boolean isUnparsedEntity(String string) {
        return true;
    }

    @Override
    public String resolveNamespacePrefix(String object) {
        if ((object = ((AbstractElement)this).getNamespaceForPrefix((String)object)) != null) {
            return ((Namespace)object).getURI();
        }
        return null;
    }

    @Override
    public Object getData() {
        String string;
        if (this.data == null && (string = this.getTextTrim()) != null && string.length() > 0) {
            if (this.datatype instanceof DatabindableDatatype) {
                XSDatatype xSDatatype = this.datatype;
                this.data = xSDatatype.createJavaObject(string, this);
            } else {
                this.data = this.datatype.createValue(string, this);
            }
        }
        return this.data;
    }

    @Override
    public void setData(Object object) {
        String string = this.datatype.convertToLexicalValue(object, this);
        this.validate(string);
        this.data = object;
        ((AbstractNode)this).setText(string);
    }

    @Override
    public Element addText(String string) {
        this.validate(string);
        return super.addText(string);
    }

    @Override
    public void setText(String string) {
        this.validate(string);
        super.setText(string);
    }

    @Override
    public void childAdded(Node node) {
        this.data = null;
        super.childAdded(node);
    }

    @Override
    public void childRemoved(Node node) {
        this.data = null;
        super.childRemoved(node);
    }

    protected void validate(String string) {
        try {
            this.datatype.checkValid(string, this);
            return;
        }
        catch (DatatypeException datatypeException) {
            throw new IllegalArgumentException(datatypeException.getMessage());
        }
    }
}

