/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.xsd.XSDatatype;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.datatype.DatatypeElementFactory;

class NamedTypeResolver {
    protected Map<QName, DocumentFactory> complexTypeMap = new HashMap<QName, DocumentFactory>();
    protected Map<QName, XSDatatype> simpleTypeMap = new HashMap<QName, XSDatatype>();
    protected Map<Element, QName> typedElementMap = new HashMap<Element, QName>();
    protected Map<Element, DocumentFactory> elementFactoryMap = new HashMap<Element, DocumentFactory>();
    protected DocumentFactory documentFactory;

    NamedTypeResolver(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    void registerComplexType(QName qName, DocumentFactory documentFactory) {
        this.complexTypeMap.put(qName, documentFactory);
    }

    void registerSimpleType(QName qName, XSDatatype xSDatatype) {
        this.simpleTypeMap.put(qName, xSDatatype);
    }

    void registerTypedElement(Element element, QName qName, DocumentFactory documentFactory) {
        this.typedElementMap.put(element, qName);
        this.elementFactoryMap.put(element, documentFactory);
    }

    void resolveElementTypes() {
        for (Element element : this.typedElementMap.keySet()) {
            QName qName = this.getQNameOfSchemaElement(element);
            Serializable serializable = this.typedElementMap.get(element);
            if (this.complexTypeMap.containsKey(serializable)) {
                serializable = this.complexTypeMap.get(serializable);
                qName.setDocumentFactory((DocumentFactory)serializable);
                continue;
            }
            if (!this.simpleTypeMap.containsKey(serializable)) continue;
            serializable = this.simpleTypeMap.get(serializable);
            DocumentFactory documentFactory = this.elementFactoryMap.get(element);
            if (!(documentFactory instanceof DatatypeElementFactory)) continue;
            ((DatatypeElementFactory)documentFactory).setChildElementXSDatatype(qName, (XSDatatype)serializable);
        }
    }

    void resolveNamedTypes() {
        this.resolveElementTypes();
    }

    private QName getQNameOfSchemaElement(Element object) {
        object = object.attributeValue("name");
        return this.getQName((String)object);
    }

    private QName getQName(String string) {
        return this.documentFactory.createQName(string);
    }
}

