/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.TypeIncubator;
import com.sun.msv.datatype.xsd.XSDatatype;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.datatype.DatatypeDocumentFactory;
import org.dom4j.datatype.DatatypeElementFactory;
import org.dom4j.datatype.InvalidSchemaException;
import org.dom4j.datatype.NamedTypeResolver;
import org.dom4j.io.SAXReader;
import org.dom4j.util.AttributeHelper;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.InputSource;

public class SchemaParser {
    private static final Namespace XSD_NAMESPACE = Namespace.get("xsd", "http://www.w3.org/2001/XMLSchema");
    private static final QName XSD_ELEMENT = QName.get("element", XSD_NAMESPACE);
    private static final QName XSD_ATTRIBUTE = QName.get("attribute", XSD_NAMESPACE);
    private static final QName XSD_SIMPLETYPE = QName.get("simpleType", XSD_NAMESPACE);
    private static final QName XSD_COMPLEXTYPE = QName.get("complexType", XSD_NAMESPACE);
    private static final QName XSD_RESTRICTION = QName.get("restriction", XSD_NAMESPACE);
    private static final QName XSD_SEQUENCE = QName.get("sequence", XSD_NAMESPACE);
    private static final QName XSD_CHOICE = QName.get("choice", XSD_NAMESPACE);
    private static final QName XSD_ALL = QName.get("all", XSD_NAMESPACE);
    private static final QName XSD_INCLUDE = QName.get("include", XSD_NAMESPACE);
    private DatatypeDocumentFactory documentFactory;
    private Map<String, XSDatatype> dataTypeCache = new HashMap<String, XSDatatype>();
    private NamedTypeResolver namedTypeResolver;
    private Namespace targetNamespace;

    public SchemaParser() {
        this(DatatypeDocumentFactory.singleton);
    }

    public SchemaParser(DatatypeDocumentFactory datatypeDocumentFactory) {
        this.documentFactory = datatypeDocumentFactory;
        this.namedTypeResolver = new NamedTypeResolver(datatypeDocumentFactory);
    }

    public void build(Document document) {
        this.targetNamespace = null;
        this.internalBuild(document);
    }

    public void build(Document document, Namespace namespace) {
        this.targetNamespace = namespace;
        this.internalBuild(document);
    }

    private synchronized void internalBuild(Document document) {
        Element element = document.getRootElement();
        if (element != null) {
            for (Element element2 : element.elements(XSD_INCLUDE)) {
                String object = element2.attributeValue("schemaLocation");
                Object object2 = document.getEntityResolver();
                try {
                    Object object3;
                    if (object2 == null) {
                        object2 = "No EntityResolver available";
                        throw new InvalidSchemaException((String)object2);
                    }
                    if ((object2 = object2.resolveEntity(null, object)) == null) {
                        object3 = "Could not resolve the schema URI: " + object;
                        throw new InvalidSchemaException((String)object3);
                    }
                    object3 = new SAXReader();
                    object2 = ((SAXReader)object3).read((InputSource)object2);
                    this.build((Document)object2);
                }
                catch (Exception exception) {
                    System.out.println("Failed to load schema: " + object);
                    System.out.println("Caught: " + exception);
                    exception.printStackTrace();
                    throw new InvalidSchemaException("Failed to load schema: " + object);
                }
            }
            for (Element element3 : element.elements(XSD_ELEMENT)) {
                this.onDatatypeElement(element3, this.documentFactory);
            }
            for (Element element4 : element.elements(XSD_SIMPLETYPE)) {
                this.onNamedSchemaSimpleType(element4);
            }
            for (Element element5 : element.elements(XSD_COMPLEXTYPE)) {
                this.onNamedSchemaComplexType(element5);
            }
            this.namedTypeResolver.resolveNamedTypes();
        }
    }

    private void onDatatypeElement(Element element, DocumentFactory object) {
        Object object2 = element.attributeValue("name");
        String string = element.attributeValue("type");
        QName qName = null;
        DatatypeElementFactory datatypeElementFactory = null;
        if (object2 != null) {
            qName = this.getQName((String)object2);
            datatypeElementFactory = this.getDatatypeElementFactory(qName);
        }
        if (string != null) {
            object2 = this.getTypeByName(string);
            if (object2 != null && datatypeElementFactory != null) {
                datatypeElementFactory.setChildElementXSDatatype(qName, (XSDatatype)object2);
                return;
            }
            object2 = this.getQName(string);
            this.namedTypeResolver.registerTypedElement(element, (QName)object2, (DocumentFactory)object);
            return;
        }
        object2 = element.element(XSD_SIMPLETYPE);
        if (object2 != null && (object2 = this.loadXSDatatypeFromSimpleType((Element)object2)) != null && datatypeElementFactory != null) {
            datatypeElementFactory.setChildElementXSDatatype(qName, (XSDatatype)object2);
        }
        if ((object2 = element.element(XSD_COMPLEXTYPE)) != null && datatypeElementFactory != null) {
            this.onSchemaComplexType((Element)object2, datatypeElementFactory);
        }
        if (datatypeElementFactory != null && (object = element.elementIterator(XSD_ATTRIBUTE)).hasNext()) {
            do {
                this.onDatatypeAttribute(element, datatypeElementFactory, (Element)object.next());
            } while (object.hasNext());
        }
    }

    private void onNamedSchemaComplexType(Element element) {
        Object object = element.attribute("name");
        if (object == null) {
            return;
        }
        object = object.getText();
        object = this.getQName((String)object);
        DatatypeElementFactory datatypeElementFactory = this.getDatatypeElementFactory((QName)object);
        this.onSchemaComplexType(element, datatypeElementFactory);
        this.namedTypeResolver.registerComplexType((QName)object, datatypeElementFactory);
    }

    private void onSchemaComplexType(Element element, DatatypeElementFactory datatypeElementFactory) {
        Object object;
        Object object2;
        Iterator<Element> iterator = element.elementIterator(XSD_ATTRIBUTE);
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = object2.attributeValue("name");
            object = this.getQName((String)object);
            if ((object2 = this.dataTypeForXsdAttribute((Element)object2)) == null) continue;
            datatypeElementFactory.setAttributeXSDatatype((QName)object, (XSDatatype)object2);
        }
        object2 = element.element(XSD_SEQUENCE);
        if (object2 != null) {
            this.onChildElements((Element)object2, datatypeElementFactory);
        }
        if ((object = element.element(XSD_CHOICE)) != null) {
            this.onChildElements((Element)object, datatypeElementFactory);
        }
        if ((object = element.element(XSD_ALL)) != null) {
            this.onChildElements((Element)object, datatypeElementFactory);
        }
    }

    private void onChildElements(Element object, DatatypeElementFactory datatypeElementFactory) {
        object = object.elementIterator(XSD_ELEMENT);
        while (object.hasNext()) {
            Element element = (Element)object.next();
            this.onDatatypeElement(element, datatypeElementFactory);
        }
    }

    private void onDatatypeAttribute(Element object, DatatypeElementFactory object2, Element element) {
        object = element.attributeValue("name");
        QName qName = this.getQName((String)object);
        XSDatatype xSDatatype = this.dataTypeForXsdAttribute(element);
        if (xSDatatype != null) {
            ((DatatypeElementFactory)object2).setAttributeXSDatatype(qName, xSDatatype);
            return;
        }
        object2 = element.attributeValue("type");
        System.out.println("Warning: Couldn't find XSDatatype for type: " + (String)object2 + " attribute: " + (String)object);
    }

    private XSDatatype dataTypeForXsdAttribute(Element object) {
        Object object2 = object.attributeValue("type");
        if (object2 != null) {
            object = this.getTypeByName((String)object2);
        } else {
            object2 = object.element(XSD_SIMPLETYPE);
            if (object2 == null) {
                object = object.attributeValue("name");
                object = "The attribute: " + (String)object + " has no type attribute and does not contain a <simpleType/> element";
                throw new InvalidSchemaException((String)object);
            }
            object = this.loadXSDatatypeFromSimpleType((Element)object2);
        }
        return object;
    }

    private void onNamedSchemaSimpleType(Element object) {
        Object object2 = object.attribute("name");
        if (object2 == null) {
            return;
        }
        object2 = object2.getText();
        object2 = this.getQName((String)object2);
        object = this.loadXSDatatypeFromSimpleType((Element)object);
        this.namedTypeResolver.registerSimpleType((QName)object2, (XSDatatype)object);
    }

    private XSDatatype loadXSDatatypeFromSimpleType(Element object) {
        block4: {
            Element element;
            while ((element = object.element(XSD_RESTRICTION)) != null) {
                Object object2;
                String string = element.attributeValue("base");
                if (string != null) {
                    object2 = this.getTypeByName(string);
                    if (object2 == null) {
                        this.onSchemaError("Invalid base type: " + string + " when trying to build restriction: " + element);
                        break block4;
                    }
                    return this.deriveSimpleType((XSDatatype)object2, element);
                }
                object2 = object.element(XSD_SIMPLETYPE);
                if (object2 == null) {
                    object = "The simpleType element: " + object + " must contain a base attribute or simpleType element";
                    this.onSchemaError((String)object);
                    break block4;
                }
                object = object2;
            }
            this.onSchemaError("No <restriction>. Could not create XSDatatype for simpleType: " + object);
        }
        return null;
    }

    private XSDatatype deriveSimpleType(XSDatatype object, Element element) {
        object = new TypeIncubator((XSDatatype)object);
        try {
            Iterator<Element> iterator = element.elementIterator();
            while (iterator.hasNext()) {
                Element element2 = iterator.next();
                String string = element2.getName();
                String string2 = element2.attributeValue("value");
                boolean bl = AttributeHelper.booleanValue(element2, "fixed");
                ((TypeIncubator)object).addFacet(string, string2, bl, null);
            }
            return ((TypeIncubator)object).derive("", null);
        }
        catch (DatatypeException datatypeException) {
            this.onSchemaError("Invalid restriction: " + datatypeException.getMessage() + " when trying to build restriction: " + element);
            return null;
        }
    }

    private DatatypeElementFactory getDatatypeElementFactory(QName qName) {
        DatatypeElementFactory datatypeElementFactory = this.documentFactory.getElementFactory(qName);
        if (datatypeElementFactory == null) {
            datatypeElementFactory = new DatatypeElementFactory(qName);
            qName.setDocumentFactory(datatypeElementFactory);
        }
        return datatypeElementFactory;
    }

    private XSDatatype getTypeByName(String string) {
        XSDatatype xSDatatype = this.dataTypeCache.get(string);
        if (xSDatatype == null) {
            int n2 = string.indexOf(58);
            if (n2 >= 0) {
                String string2 = string.substring(n2 + 1);
                try {
                    xSDatatype = DatatypeFactory.getTypeByName(string2);
                }
                catch (DatatypeException datatypeException) {}
            }
            if (xSDatatype == null) {
                try {
                    xSDatatype = DatatypeFactory.getTypeByName(string);
                }
                catch (DatatypeException datatypeException) {}
            }
            if (xSDatatype == null) {
                QName qName = this.getQName(string);
                xSDatatype = this.namedTypeResolver.simpleTypeMap.get(qName);
            }
            if (xSDatatype != null) {
                this.dataTypeCache.put(string, xSDatatype);
            }
        }
        return xSDatatype;
    }

    private QName getQName(String string) {
        if (this.targetNamespace == null) {
            return this.documentFactory.createQName(string);
        }
        return this.documentFactory.createQName(string, this.targetNamespace);
    }

    private void onSchemaError(String string) {
        throw new InvalidSchemaException(string);
    }
}

