/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dom;

import java.util.ArrayList;
import org.dom4j.DocumentFactory;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.dom4j.dom.DOMNodeHelper;
import org.dom4j.tree.DefaultDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class DOMDocument
extends DefaultDocument
implements Document {
    private static final DOMDocumentFactory DOCUMENT_FACTORY = (DOMDocumentFactory)DOMDocumentFactory.getInstance();

    public DOMDocument() {
        this.init();
    }

    public DOMDocument(String string) {
        super(string);
        this.init();
    }

    public DOMDocument(DOMElement dOMElement) {
        super(dOMElement);
        this.init();
    }

    public DOMDocument(DOMDocumentType dOMDocumentType) {
        super(dOMDocumentType);
        this.init();
    }

    public DOMDocument(DOMElement dOMElement, DOMDocumentType dOMDocumentType) {
        super(dOMElement, dOMDocumentType);
        this.init();
    }

    public DOMDocument(String string, DOMElement dOMElement, DOMDocumentType dOMDocumentType) {
        super(string, dOMElement, dOMDocumentType);
        this.init();
    }

    private void init() {
        this.setDocumentFactory(DOCUMENT_FACTORY);
    }

    public boolean supports(String string, String string2) {
        return DOMNodeHelper.supports(this, string, string2);
    }

    @Override
    public String getNamespaceURI() {
        return DOMNodeHelper.getNamespaceURI(this);
    }

    @Override
    public String getPrefix() {
        return DOMNodeHelper.getPrefix(this);
    }

    @Override
    public void setPrefix(String string) {
        DOMNodeHelper.setPrefix(this, string);
    }

    @Override
    public String getLocalName() {
        return DOMNodeHelper.getLocalName(this);
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public void setNodeValue(String string) {
    }

    @Override
    public org.w3c.dom.Node getParentNode() {
        return DOMNodeHelper.getParentNode(this);
    }

    @Override
    public NodeList getChildNodes() {
        return DOMNodeHelper.createNodeList(this.content());
    }

    @Override
    public org.w3c.dom.Node getFirstChild() {
        return DOMNodeHelper.asDOMNode(this.node(0));
    }

    @Override
    public org.w3c.dom.Node getLastChild() {
        DOMDocument dOMDocument = this;
        return DOMNodeHelper.asDOMNode(dOMDocument.node(dOMDocument.nodeCount() - 1));
    }

    @Override
    public org.w3c.dom.Node getPreviousSibling() {
        return DOMNodeHelper.getPreviousSibling(this);
    }

    @Override
    public org.w3c.dom.Node getNextSibling() {
        return DOMNodeHelper.getNextSibling(this);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        this.checkNewChildNode(node);
        return DOMNodeHelper.insertBefore(this, node, node2);
    }

    @Override
    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        this.checkNewChildNode(node);
        return DOMNodeHelper.replaceChild(this, node, node2);
    }

    @Override
    public org.w3c.dom.Node removeChild(org.w3c.dom.Node node) {
        return DOMNodeHelper.removeChild(this, node);
    }

    @Override
    public org.w3c.dom.Node appendChild(org.w3c.dom.Node node) {
        this.checkNewChildNode(node);
        return DOMNodeHelper.appendChild(this, node);
    }

    private void checkNewChildNode(org.w3c.dom.Node node) {
        short s2 = node.getNodeType();
        if (s2 != 1 && s2 != 8 && s2 != 7 && s2 != 10) {
            throw new DOMException(3, "Given node cannot be a child of document");
        }
    }

    @Override
    public boolean hasChildNodes() {
        return this.nodeCount() > 0;
    }

    @Override
    public org.w3c.dom.Node cloneNode(boolean bl) {
        return DOMNodeHelper.cloneNode(this, bl);
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return DOMNodeHelper.isSupported(this, string, string2);
    }

    @Override
    public boolean hasAttributes() {
        return DOMNodeHelper.hasAttributes(this);
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        DOMNodeHelper.appendElementsByTagName(arrayList, this, string);
        return DOMNodeHelper.createNodeList(arrayList);
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        DOMNodeHelper.appendElementsByTagNameNS(arrayList, this, string, string2);
        return DOMNodeHelper.createNodeList(arrayList);
    }

    @Override
    public DocumentType getDoctype() {
        return DOMNodeHelper.asDOMDocumentType(this.getDocType());
    }

    @Override
    public DOMImplementation getImplementation() {
        if (((DefaultDocument)this).getDocumentFactory() instanceof DOMImplementation) {
            return (DOMImplementation)((Object)((DefaultDocument)this).getDocumentFactory());
        }
        return DOCUMENT_FACTORY;
    }

    @Override
    public Element getDocumentElement() {
        return DOMNodeHelper.asDOMElement(this.getRootElement());
    }

    @Override
    public Element createElement(String string) {
        return (Element)((Object)((DefaultDocument)this).getDocumentFactory().createElement(string));
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public Text createTextNode(String string) {
        return (Text)((Object)((DefaultDocument)this).getDocumentFactory().createText(string));
    }

    @Override
    public Comment createComment(String string) {
        return (Comment)((Object)((DefaultDocument)this).getDocumentFactory().createComment(string));
    }

    @Override
    public CDATASection createCDATASection(String string) {
        return (CDATASection)((Object)((DefaultDocument)this).getDocumentFactory().createCDATA(string));
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        return (ProcessingInstruction)((Object)((DefaultDocument)this).getDocumentFactory().createProcessingInstruction(string, string2));
    }

    @Override
    public Attr createAttribute(String object) {
        object = ((DefaultDocument)this).getDocumentFactory().createQName((String)object);
        return (Attr)((Object)((DefaultDocument)this).getDocumentFactory().createAttribute(null, (QName)object, ""));
    }

    @Override
    public EntityReference createEntityReference(String string) {
        return (EntityReference)((Object)((DefaultDocument)this).getDocumentFactory().createEntity(string, null));
    }

    @Override
    public org.w3c.dom.Node importNode(org.w3c.dom.Node node, boolean bl) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public Element createElementNS(String object, String string) {
        object = ((DefaultDocument)this).getDocumentFactory().createQName(string, (String)object);
        return (Element)((Object)((DefaultDocument)this).getDocumentFactory().createElement((QName)object));
    }

    @Override
    public Attr createAttributeNS(String object, String string) {
        object = ((DefaultDocument)this).getDocumentFactory().createQName(string, (String)object);
        return (Attr)((Object)((DefaultDocument)this).getDocumentFactory().createAttribute(null, (QName)object, null));
    }

    @Override
    public Element getElementById(String string) {
        return DOMNodeHelper.asDOMElement(this.elementByID(string));
    }

    @Override
    public DocumentFactory getDocumentFactory() {
        if (super.getDocumentFactory() == null) {
            return DOCUMENT_FACTORY;
        }
        return super.getDocumentFactory();
    }

    @Override
    public String getInputEncoding() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public String getXmlEncoding() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        DOMNodeHelper.notSupported();
        return false;
    }

    @Override
    public void setXmlStandalone(boolean bl) {
        DOMNodeHelper.notSupported();
    }

    @Override
    public String getXmlVersion() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public void setXmlVersion(String string) {
        DOMNodeHelper.notSupported();
    }

    @Override
    public boolean getStrictErrorChecking() {
        DOMNodeHelper.notSupported();
        return false;
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        DOMNodeHelper.notSupported();
    }

    @Override
    public String getDocumentURI() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public void setDocumentURI(String string) {
        DOMNodeHelper.notSupported();
    }

    @Override
    public org.w3c.dom.Node adoptNode(org.w3c.dom.Node node) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public void normalizeDocument() {
        DOMNodeHelper.notSupported();
    }

    @Override
    public org.w3c.dom.Node renameNode(org.w3c.dom.Node node, String string, String string2) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public String getBaseURI() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public short compareDocumentPosition(org.w3c.dom.Node node) {
        DOMNodeHelper.notSupported();
        return 0;
    }

    @Override
    public String getTextContent() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public void setTextContent(String string) {
        DOMNodeHelper.notSupported();
    }

    @Override
    public boolean isSameNode(org.w3c.dom.Node node) {
        DOMNodeHelper.notSupported();
        return false;
    }

    @Override
    public String lookupPrefix(String string) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        DOMNodeHelper.notSupported();
        return false;
    }

    @Override
    public String lookupNamespaceURI(String string) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node node) {
        DOMNodeHelper.notSupported();
        return false;
    }

    @Override
    public Object getFeature(String string, String string2) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public Object getUserData(String string) {
        DOMNodeHelper.notSupported();
        return null;
    }
}

