/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dom;

import java.util.ArrayList;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMAttributeNodeMap;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMNodeHelper;
import org.dom4j.tree.AbstractBranch;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.DefaultElement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class DOMElement
extends DefaultElement
implements Element {
    private static final DocumentFactory DOCUMENT_FACTORY = DOMDocumentFactory.getInstance();

    public DOMElement(String string) {
        super(string);
    }

    public DOMElement(QName qName) {
        super(qName);
    }

    public DOMElement(QName qName, int n2) {
        super(qName, n2);
    }

    public DOMElement(String string, Namespace namespace) {
        super(string, namespace);
    }

    public boolean supports(String string, String string2) {
        return DOMNodeHelper.supports(this, string, string2);
    }

    @Override
    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.getQName().getNamespacePrefix();
    }

    @Override
    public void setPrefix(String string) {
        DOMNodeHelper.setPrefix(this, string);
    }

    @Override
    public String getLocalName() {
        return this.getQName().getName();
    }

    @Override
    public String getNodeName() {
        return ((AbstractNode)this).getName();
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public void setNodeValue(String string) {
    }

    @Override
    public org.w3c.dom.Node getParentNode() {
        return DOMNodeHelper.getParentNode(this);
    }

    @Override
    public NodeList getChildNodes() {
        return DOMNodeHelper.createNodeList(this.content());
    }

    @Override
    public org.w3c.dom.Node getFirstChild() {
        return DOMNodeHelper.asDOMNode(((AbstractBranch)this).node(0));
    }

    @Override
    public org.w3c.dom.Node getLastChild() {
        DOMElement dOMElement = this;
        return DOMNodeHelper.asDOMNode(((AbstractBranch)dOMElement).node(((AbstractBranch)dOMElement).nodeCount() - 1));
    }

    @Override
    public org.w3c.dom.Node getPreviousSibling() {
        return DOMNodeHelper.getPreviousSibling(this);
    }

    @Override
    public org.w3c.dom.Node getNextSibling() {
        return DOMNodeHelper.getNextSibling(this);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new DOMAttributeNodeMap(this);
    }

    @Override
    public Document getOwnerDocument() {
        return DOMNodeHelper.getOwnerDocument(this);
    }

    @Override
    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        this.checkNewChildNode(node);
        return DOMNodeHelper.insertBefore(this, node, node2);
    }

    @Override
    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        this.checkNewChildNode(node);
        return DOMNodeHelper.replaceChild(this, node, node2);
    }

    @Override
    public org.w3c.dom.Node removeChild(org.w3c.dom.Node node) {
        return DOMNodeHelper.removeChild(this, node);
    }

    @Override
    public org.w3c.dom.Node appendChild(org.w3c.dom.Node node) {
        this.checkNewChildNode(node);
        return DOMNodeHelper.appendChild(this, node);
    }

    private void checkNewChildNode(org.w3c.dom.Node node) {
        short s2 = node.getNodeType();
        if (s2 != 1 && s2 != 3 && s2 != 8 && s2 != 7 && s2 != 4 && s2 != 5) {
            throw new DOMException(3, "Given node cannot be a child of element");
        }
    }

    @Override
    public boolean hasChildNodes() {
        return ((AbstractBranch)this).nodeCount() > 0;
    }

    @Override
    public org.w3c.dom.Node cloneNode(boolean bl) {
        return DOMNodeHelper.cloneNode(this, bl);
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return DOMNodeHelper.isSupported(this, string, string2);
    }

    @Override
    public boolean hasAttributes() {
        return DOMNodeHelper.hasAttributes(this);
    }

    @Override
    public String getTagName() {
        return ((AbstractNode)this).getName();
    }

    @Override
    public String getAttribute(String string) {
        if ((string = this.attributeValue(string)) != null) {
            return string;
        }
        return "";
    }

    @Override
    public void setAttribute(String string, String string2) {
        this.addAttribute(string, string2);
    }

    @Override
    public void removeAttribute(String object) {
        if ((object = ((AbstractElement)this).attribute((String)object)) != null) {
            ((AbstractElement)this).remove((Attribute)object);
        }
    }

    @Override
    public Attr getAttributeNode(String string) {
        return DOMNodeHelper.asDOMAttr(((AbstractElement)this).attribute(string));
    }

    @Override
    public Attr setAttributeNode(Attr object) {
        if (((AbstractNode)this).isReadOnly()) {
            throw new DOMException(7, "No modification allowed");
        }
        Attribute attribute = this.attribute((Attr)object);
        if (attribute != object) {
            if (object.getOwnerElement() != null) {
                throw new DOMException(10, "Attribute is already in use");
            }
            object = this.createAttribute((Attr)object);
            if (attribute != null) {
                attribute.detach();
            }
            ((AbstractElement)this).add((Attribute)object);
        }
        return DOMNodeHelper.asDOMAttr(attribute);
    }

    @Override
    public Attr removeAttributeNode(Attr object) {
        if ((object = this.attribute((Attr)object)) != null) {
            object.detach();
            return DOMNodeHelper.asDOMAttr((Node)object);
        }
        throw new DOMException(8, "No such attribute");
    }

    @Override
    public String getAttributeNS(String object, String string) {
        if ((object = this.attribute((String)object, string)) != null && (object = object.getValue()) != null) {
            return object;
        }
        return "";
    }

    @Override
    public void setAttributeNS(String object, String string, String string2) {
        Attribute attribute = this.attribute((String)object, string);
        if (attribute != null) {
            attribute.setValue(string2);
            return;
        }
        object = this.getQName((String)object, string);
        this.addAttribute((QName)object, string2);
    }

    @Override
    public void removeAttributeNS(String object, String string) {
        if ((object = this.attribute((String)object, string)) != null) {
            ((AbstractElement)this).remove((Attribute)object);
        }
    }

    @Override
    public Attr getAttributeNodeNS(String object, String string) {
        if ((object = this.attribute((String)object, string)) != null) {
            DOMNodeHelper.asDOMAttr((Node)object);
        }
        return null;
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr) {
        Attribute attribute = this.attribute(attr.getNamespaceURI(), attr.getLocalName());
        if (attribute != null) {
            attribute.setValue(attr.getValue());
        } else {
            attribute = this.createAttribute(attr);
            ((AbstractElement)this).add(attribute);
        }
        return DOMNodeHelper.asDOMAttr(attribute);
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        DOMNodeHelper.appendElementsByTagName(arrayList, this, string);
        return DOMNodeHelper.createNodeList(arrayList);
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        DOMNodeHelper.appendElementsByTagNameNS(arrayList, this, string, string2);
        return DOMNodeHelper.createNodeList(arrayList);
    }

    @Override
    public boolean hasAttribute(String string) {
        return ((AbstractElement)this).attribute(string) != null;
    }

    @Override
    public boolean hasAttributeNS(String string, String string2) {
        return this.attribute(string, string2) != null;
    }

    @Override
    public DocumentFactory getDocumentFactory() {
        DocumentFactory documentFactory = this.getQName().getDocumentFactory();
        if (documentFactory != null) {
            return documentFactory;
        }
        return DOCUMENT_FACTORY;
    }

    protected Attribute attribute(Attr attr) {
        return ((AbstractElement)this).attribute(DOCUMENT_FACTORY.createQName(attr.getLocalName(), attr.getPrefix(), attr.getNamespaceURI()));
    }

    protected Attribute attribute(String string, String string2) {
        Object object = this.attributeList();
        object.size();
        object = object.iterator();
        while (object.hasNext()) {
            Attribute attribute = (Attribute)object.next();
            if (!string2.equals(attribute.getName()) || (string != null && string.length() != 0 || attribute.getNamespaceURI() != null && attribute.getNamespaceURI().length() != 0) && (string == null || !string.equals(attribute.getNamespaceURI()))) continue;
            return attribute;
        }
        return null;
    }

    protected Attribute createAttribute(Attr attr) {
        Object object = attr.getLocalName();
        if (object != null) {
            String string = attr.getPrefix();
            String string2 = attr.getNamespaceURI();
            object = this.getDocumentFactory().createQName((String)object, string, string2);
        } else {
            object = attr.getName();
            object = this.getDocumentFactory().createQName((String)object);
        }
        return new DOMAttribute((QName)object, attr.getValue());
    }

    protected QName getQName(String string, String string2) {
        int n2 = string2.indexOf(58);
        String string3 = "";
        String string4 = string2;
        if (n2 >= 0) {
            string3 = string2.substring(0, n2);
            string4 = string2.substring(n2 + 1);
        }
        return this.getDocumentFactory().createQName(string4, string3, string);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public void setIdAttribute(String string, boolean bl) {
        DOMNodeHelper.notSupported();
    }

    @Override
    public void setIdAttributeNS(String string, String string2, boolean bl) {
        DOMNodeHelper.notSupported();
    }

    @Override
    public void setIdAttributeNode(Attr attr, boolean bl) {
        DOMNodeHelper.notSupported();
    }

    @Override
    public String getBaseURI() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public short compareDocumentPosition(org.w3c.dom.Node node) {
        DOMNodeHelper.notSupported();
        return 0;
    }

    @Override
    public String getTextContent() {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public void setTextContent(String string) {
        DOMNodeHelper.notSupported();
    }

    @Override
    public boolean isSameNode(org.w3c.dom.Node node) {
        return DOMNodeHelper.isNodeSame(this, node);
    }

    @Override
    public String lookupPrefix(String string) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        DOMNodeHelper.notSupported();
        return false;
    }

    @Override
    public String lookupNamespaceURI(String string) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node node) {
        return DOMNodeHelper.isNodeEquals(this, node);
    }

    @Override
    public Object getFeature(String string, String string2) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        DOMNodeHelper.notSupported();
        return null;
    }

    @Override
    public Object getUserData(String string) {
        DOMNodeHelper.notSupported();
        return null;
    }
}

