/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dom;

import java.util.List;
import org.dom4j.Branch;
import org.dom4j.CharacterData;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.dom.DOMNodeHelper$1;
import org.dom4j.dom.DOMNodeHelper$EmptyNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMNodeHelper {
    public static final NodeList EMPTY_NODE_LIST = new DOMNodeHelper$EmptyNodeList();

    protected DOMNodeHelper() {
    }

    public static boolean supports(Node node, String string, String string2) {
        return false;
    }

    public static String getNamespaceURI(Node node) {
        return null;
    }

    public static String getPrefix(Node node) {
        return null;
    }

    public static String getLocalName(Node node) {
        return null;
    }

    public static void setPrefix(Node node, String string) {
        DOMNodeHelper.notSupported();
    }

    public static String getNodeValue(Node node) {
        return node.getText();
    }

    public static void setNodeValue(Node node, String string) {
        node.setText(string);
    }

    public static org.w3c.dom.Node getParentNode(Node node) {
        return DOMNodeHelper.asDOMNode(node.getParent());
    }

    public static NodeList getChildNodes(Node node) {
        return EMPTY_NODE_LIST;
    }

    public static org.w3c.dom.Node getFirstChild(Node node) {
        return null;
    }

    public static org.w3c.dom.Node getLastChild(Node node) {
        return null;
    }

    public static org.w3c.dom.Node getPreviousSibling(Node node) {
        int n2;
        Element element = node.getParent();
        if (element != null && (n2 = element.indexOf(node)) > 0) {
            Node node2 = element.node(n2 - 1);
            return DOMNodeHelper.asDOMNode(node2);
        }
        return null;
    }

    public static org.w3c.dom.Node getNextSibling(Node node) {
        int n2;
        Element element = node.getParent();
        if (element != null && (n2 = element.indexOf(node)) >= 0 && ++n2 < element.nodeCount()) {
            Node node2 = element.node(n2);
            return DOMNodeHelper.asDOMNode(node2);
        }
        return null;
    }

    public static NamedNodeMap getAttributes(Node node) {
        return null;
    }

    public static org.w3c.dom.Document getOwnerDocument(Node node) {
        return DOMNodeHelper.asDOMDocument(node.getDocument());
    }

    public static org.w3c.dom.Node insertBefore(Node node, org.w3c.dom.Node node2, org.w3c.dom.Node node3) {
        if (node instanceof Branch) {
            assert (node2 instanceof Node);
            List<Node> list = (node = (Branch)node).content();
            int n2 = list.indexOf(node3);
            if (n2 < 0) {
                node.add((Node)((Object)node2));
            } else {
                list.add(n2, (Node)((Object)node2));
            }
            return node2;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node);
    }

    public static org.w3c.dom.Node replaceChild(Node node, org.w3c.dom.Node node2, org.w3c.dom.Node node3) {
        if (node instanceof Branch) {
            Object object = (Branch)node;
            object = object.content();
            assert (node2 instanceof Node);
            int n2 = object.indexOf(node3);
            if (n2 < 0) {
                throw new DOMException(8, "Tried to replace a non existing child for node: " + node);
            }
            object.set(n2, (Node)((Object)node2));
            return node3;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node);
    }

    public static org.w3c.dom.Node removeChild(Node node, org.w3c.dom.Node node2) {
        if (node instanceof Branch) {
            node = (Branch)node;
            node.remove((Node)((Object)node2));
            return node2;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node);
    }

    public static org.w3c.dom.Node appendChild(Node node, org.w3c.dom.Node node2) {
        if (node instanceof Branch) {
            node = (Branch)node;
            org.w3c.dom.Node node3 = node2.getParentNode();
            if (node3 != null) {
                node3.removeChild(node2);
            }
            node.add((Node)((Object)node2));
            return node2;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node);
    }

    public static boolean hasChildNodes(Node node) {
        return false;
    }

    public static org.w3c.dom.Node cloneNode(Node node, boolean bl) {
        return DOMNodeHelper.asDOMNode((Node)node.clone());
    }

    public static void normalize(Node node) {
        DOMNodeHelper.notSupported();
    }

    public static boolean isSupported(Node node, String string, String string2) {
        return false;
    }

    public static boolean hasAttributes(Node node) {
        if (node != null && node instanceof Element) {
            return ((Element)node).attributeCount() > 0;
        }
        return false;
    }

    public static String getData(CharacterData characterData) {
        return characterData.getText();
    }

    public static void setData(CharacterData characterData, String string) {
        characterData.setText(string);
    }

    public static int getLength(CharacterData object) {
        if ((object = object.getText()) != null) {
            return ((String)object).length();
        }
        return 0;
    }

    public static String substringData(CharacterData object, int n2, int n3) {
        int n4;
        if (n3 < 0) {
            throw new DOMException(1, "Illegal value for count: " + n3);
        }
        int n5 = n4 = (object = object.getText()) != null ? ((String)object).length() : 0;
        if (n2 < 0 || n2 >= n4) {
            throw new DOMException(1, "No text at offset: " + n2);
        }
        if (n2 + n3 > n4) {
            return ((String)object).substring(n2);
        }
        int n6 = n2;
        return ((String)object).substring(n6, n6 + n3);
    }

    public static void appendData(CharacterData characterData, String string) {
        if (characterData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + characterData);
        }
        String string2 = characterData.getText();
        if (string2 == null) {
            characterData.setText(string);
            return;
        }
        characterData.setText(string2 + string);
    }

    public static void insertData(CharacterData characterData, int n2, String string) {
        if (characterData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + characterData);
        }
        CharSequence charSequence = characterData.getText();
        if (charSequence == null) {
            characterData.setText(string);
            return;
        }
        int n3 = ((String)charSequence).length();
        if (n2 < 0 || n2 > n3) {
            throw new DOMException(1, "No text at offset: " + n2);
        }
        charSequence = new StringBuilder((String)charSequence);
        ((StringBuilder)charSequence).insert(n2, string);
        characterData.setText(((StringBuilder)charSequence).toString());
    }

    public static void deleteData(CharacterData characterData, int n2, int n3) {
        if (characterData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + characterData);
        }
        if (n3 < 0) {
            throw new DOMException(1, "Illegal value for count: " + n3);
        }
        CharSequence charSequence = characterData.getText();
        if (charSequence != null) {
            int n4 = ((String)charSequence).length();
            if (n2 < 0 || n2 >= n4) {
                throw new DOMException(1, "No text at offset: " + n2);
            }
            charSequence = new StringBuilder((String)charSequence);
            int n5 = n2;
            ((StringBuilder)charSequence).delete(n5, n5 + n3);
            characterData.setText(((StringBuilder)charSequence).toString());
        }
    }

    public static void replaceData(CharacterData characterData, int n2, int n3, String string) {
        if (characterData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + characterData);
        }
        if (n3 < 0) {
            throw new DOMException(1, "Illegal value for count: " + n3);
        }
        CharSequence charSequence = characterData.getText();
        if (charSequence != null) {
            int n4 = ((String)charSequence).length();
            if (n2 < 0 || n2 >= n4) {
                throw new DOMException(1, "No text at offset: " + n2);
            }
            charSequence = new StringBuilder((String)charSequence);
            int n5 = n2;
            ((StringBuilder)charSequence).replace(n5, n5 + n3, string);
            characterData.setText(((StringBuilder)charSequence).toString());
        }
    }

    public static void appendElementsByTagName(List<? super Element> list, Branch branch, String string) {
        boolean bl = "*".equals(string);
        int n2 = branch.nodeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = branch.node(i2);
            if (!(node instanceof Element)) continue;
            node = (Element)node;
            if (bl || string.equals(node.getName())) {
                list.add((Element)node);
            }
            DOMNodeHelper.appendElementsByTagName(list, (Branch)node, string);
        }
    }

    public static void appendElementsByTagNameNS(List<? super Element> list, Branch branch, String string, String string2) {
        boolean bl = "*".equals(string);
        boolean bl2 = "*".equals(string2);
        int n2 = branch.nodeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = branch.node(i2);
            if (!(node instanceof Element)) continue;
            node = (Element)node;
            if ((bl || (string == null || string.length() == 0) && (node.getNamespaceURI() == null || node.getNamespaceURI().length() == 0) || string != null && string.equals(node.getNamespaceURI())) && (bl2 || string2.equals(node.getName()))) {
                list.add((Element)node);
            }
            DOMNodeHelper.appendElementsByTagNameNS(list, (Branch)node, string, string2);
        }
    }

    public static NodeList createNodeList(List<Node> list) {
        return new DOMNodeHelper$1(list);
    }

    public static org.w3c.dom.Node asDOMNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof org.w3c.dom.Node) {
            return (org.w3c.dom.Node)((Object)node);
        }
        System.out.println("Cannot convert: " + node + " into a W3C DOM Node");
        DOMNodeHelper.notSupported();
        return null;
    }

    public static org.w3c.dom.Document asDOMDocument(Document document) {
        if (document == null) {
            return null;
        }
        if (document instanceof org.w3c.dom.Document) {
            return (org.w3c.dom.Document)((Object)document);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static org.w3c.dom.DocumentType asDOMDocumentType(DocumentType documentType) {
        if (documentType == null) {
            return null;
        }
        if (documentType instanceof org.w3c.dom.DocumentType) {
            return (org.w3c.dom.DocumentType)((Object)documentType);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static Text asDOMText(CharacterData characterData) {
        if (characterData == null) {
            return null;
        }
        if (characterData instanceof Text) {
            return (Text)((Object)characterData);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static org.w3c.dom.Element asDOMElement(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof org.w3c.dom.Element) {
            return (org.w3c.dom.Element)((Object)node);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static Attr asDOMAttr(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Attr) {
            return (Attr)((Object)node);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static void notSupported() {
        throw new DOMException(9, "Not supported yet");
    }

    public static boolean isStringEquals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static boolean isNodeEquals(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        if (node == null && node2 == null) {
            return true;
        }
        if (node == null || node2 == null) {
            return false;
        }
        if (node.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (!DOMNodeHelper.isStringEquals(node.getNodeName(), node2.getNodeName())) {
            return false;
        }
        if (!DOMNodeHelper.isStringEquals(node.getLocalName(), node2.getLocalName())) {
            return false;
        }
        if (!DOMNodeHelper.isStringEquals(node.getNamespaceURI(), node2.getNamespaceURI())) {
            return false;
        }
        if (!DOMNodeHelper.isStringEquals(node.getPrefix(), node2.getPrefix())) {
            return false;
        }
        return DOMNodeHelper.isStringEquals(node.getNodeValue(), node2.getNodeValue());
    }

    public static boolean isNodeSame(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        return node == node2;
    }
}

