/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.ArrayList;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.NamespaceStack;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMReader {
    private DocumentFactory factory;
    private NamespaceStack namespaceStack;

    public DOMReader() {
        this.factory = DocumentFactory.getInstance();
        this.namespaceStack = new NamespaceStack(this.factory);
    }

    public DOMReader(DocumentFactory documentFactory) {
        this.factory = documentFactory;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    public DocumentFactory getDocumentFactory() {
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory;
        this.namespaceStack.setDocumentFactory(this.factory);
    }

    public Document read(org.w3c.dom.Document object) {
        if (object instanceof Document) {
            return (Document)object;
        }
        Document document = this.createDocument();
        this.clearNamespaceStack();
        object = object.getChildNodes();
        int n2 = object.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.readTree(object.item(i2), document);
        }
        return document;
    }

    protected void readTree(Node node, Branch object) {
        Element element = null;
        Document document = null;
        if (object instanceof Element) {
            element = (Element)object;
        } else {
            document = (Document)object;
        }
        switch (node.getNodeType()) {
            case 1: {
                this.readElement(node, (Branch)object);
                return;
            }
            case 7: {
                if (object instanceof Element) {
                    object = (Element)object;
                    object.addProcessingInstruction(node.getNodeName(), node.getNodeValue());
                    return;
                }
                object = (Document)object;
                object.addProcessingInstruction(node.getNodeName(), node.getNodeValue());
                return;
            }
            case 8: {
                if (object instanceof Element) {
                    ((Element)object).addComment(node.getNodeValue());
                    return;
                }
                ((Document)object).addComment(node.getNodeValue());
                return;
            }
            case 10: {
                object = (DocumentType)node;
                document.addDocType(object.getName(), object.getPublicId(), object.getSystemId());
                return;
            }
            case 3: {
                element.addText(node.getNodeValue());
                return;
            }
            case 4: {
                element.addCDATA(node.getNodeValue());
                return;
            }
            case 5: {
                object = node.getFirstChild();
                if (object != null) {
                    element.addEntity(node.getNodeName(), object.getNodeValue());
                    return;
                }
                element.addEntity(node.getNodeName(), "");
                return;
            }
            case 6: {
                element.addEntity(node.getNodeName(), node.getNodeValue());
                return;
            }
        }
        System.out.println("WARNING: Unknown DOM node type: " + node.getNodeType());
    }

    protected void readElement(Node node, Branch branch) {
        Object object;
        int n2;
        ArrayList<Node> arrayList;
        int n3 = this.namespaceStack.size();
        String string = node.getNamespaceURI();
        node.getPrefix();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && string == null && (arrayList = namedNodeMap.getNamedItem("xmlns")) != null) {
            string = arrayList.getNodeValue();
        }
        arrayList = this.namespaceStack.getQName(string, node.getLocalName(), node.getNodeName());
        branch = branch.addElement((QName)((Object)arrayList));
        if (namedNodeMap != null) {
            Object object2;
            int n4 = namedNodeMap.getLength();
            arrayList = new ArrayList<Node>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                object = namedNodeMap.item(n2);
                object2 = object.getNodeName();
                if (((String)object2).startsWith("xmlns")) {
                    object2 = this.getPrefix((String)object2);
                    object = object.getNodeValue();
                    object = this.namespaceStack.addNamespace((String)object2, (String)object);
                    branch.add((Namespace)object);
                    continue;
                }
                arrayList.add((Node)object);
            }
            n4 = arrayList.size();
            for (n2 = 0; n2 < n4; ++n2) {
                object = (Node)arrayList.get(n2);
                object2 = this.namespaceStack.getQName(object.getNamespaceURI(), object.getLocalName(), object.getNodeName());
                branch.addAttribute((QName)object2, object.getNodeValue());
            }
        }
        NodeList nodeList = node.getChildNodes();
        n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = nodeList.item(i2);
            this.readTree((Node)object, branch);
        }
        while (this.namespaceStack.size() > n3) {
            this.namespaceStack.pop();
        }
    }

    protected Namespace getNamespace(String string, String string2) {
        return this.getDocumentFactory().createNamespace(string, string2);
    }

    protected Document createDocument() {
        return this.getDocumentFactory().createDocument();
    }

    protected void clearNamespaceStack() {
        this.namespaceStack.clear();
        if (!this.namespaceStack.contains(Namespace.XML_NAMESPACE)) {
            this.namespaceStack.push(Namespace.XML_NAMESPACE);
        }
    }

    private String getPrefix(String string) {
        int n2 = string.indexOf(58, 5);
        if (n2 != -1) {
            return string.substring(n2 + 1);
        }
        return "";
    }
}

