/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.dom.DOMComment;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMElement;
import org.dom4j.dom.DOMText;
import org.dom4j.io.ElementStack;
import org.dom4j.tree.AbstractBranch;
import org.dom4j.tree.NamespaceStack;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

public class DOMSAXContentHandler
extends DefaultHandler
implements LexicalHandler {
    private DOMDocumentFactory documentFactory;
    private Document document;
    private ElementStack elementStack;
    private NamespaceStack namespaceStack;
    private Locator locator;
    private boolean insideCDATASection;
    private StringBuffer cdataText;
    private int declaredNamespaceIndex;
    private InputSource inputSource;
    private Element currentElement;
    private EntityResolver entityResolver;
    private boolean mergeAdjacentText = false;
    private boolean textInTextBuffer = false;
    private boolean ignoreComments = false;
    private StringBuffer textBuffer;
    private boolean stripWhitespaceText = false;

    public DOMSAXContentHandler() {
        this((DOMDocumentFactory)DOMDocumentFactory.getInstance());
    }

    public DOMSAXContentHandler(DOMDocumentFactory dOMDocumentFactory) {
        this.documentFactory = dOMDocumentFactory;
        this.elementStack = this.createElementStack();
        this.namespaceStack = new NamespaceStack(dOMDocumentFactory);
    }

    public org.w3c.dom.Document getDocument() {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        return (org.w3c.dom.Document)((Object)this.document);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void processingInstruction(String object, String string) {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        object = (ProcessingInstruction)((Object)((DocumentFactory)this.documentFactory).createProcessingInstruction((String)object, string));
        if (this.currentElement != null) {
            ((org.w3c.dom.Element)((Object)this.currentElement)).appendChild((Node)object);
            return;
        }
        this.getDocument().appendChild((Node)object);
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        this.namespaceStack.push(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) {
        this.namespaceStack.pop(string);
        this.declaredNamespaceIndex = this.namespaceStack.size();
    }

    @Override
    public void startDocument() {
        this.document = null;
        this.currentElement = null;
        this.elementStack.clear();
        this.namespaceStack.clear();
        this.declaredNamespaceIndex = 0;
        if (this.mergeAdjacentText && this.textBuffer == null) {
            this.textBuffer = new StringBuffer();
        }
        this.textInTextBuffer = false;
    }

    @Override
    public void endDocument() {
        this.namespaceStack.clear();
        this.elementStack.clear();
        this.currentElement = null;
        this.textBuffer = null;
    }

    @Override
    public void startElement(String object, String object2, String string, Attributes attributes) {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        object = this.namespaceStack.getQName((String)object, (String)object2, string);
        object2 = this.currentElement;
        if (object2 == null) {
            object2 = (Document)((Object)this.getDocument());
        }
        object = new DOMElement((QName)object);
        object2.add((Element)object);
        this.addDeclaredNamespaces((Element)object);
        this.addAttributes((Element)object, attributes);
        this.elementStack.pushElement((Element)object);
        this.currentElement = object;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        this.elementStack.popElement();
        this.currentElement = this.elementStack.peekElement();
    }

    @Override
    public void characters(char[] object, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (this.currentElement != null) {
            if (this.insideCDATASection) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.cdataText.append(new String((char[])object, n2, n3));
                return;
            }
            if (this.mergeAdjacentText) {
                this.textBuffer.append((char[])object, n2, n3);
                this.textInTextBuffer = true;
                return;
            }
            object = new DOMText(new String((char[])object, n2, n3));
            ((DOMElement)this.currentElement).add((Text)object);
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        throw sAXParseException;
    }

    @Override
    public void startDTD(String string, String string2, String string3) {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String string) {
    }

    @Override
    public void endEntity(String string) {
    }

    @Override
    public void startCDATA() {
        this.insideCDATASection = true;
        this.cdataText = new StringBuffer();
    }

    @Override
    public void endCDATA() {
        this.insideCDATASection = false;
        DOMCDATA dOMCDATA = new DOMCDATA(this.cdataText.toString());
        ((DOMElement)this.currentElement).add(dOMCDATA);
    }

    @Override
    public void comment(char[] object, int n2, int n3) {
        if (!this.ignoreComments) {
            if (this.mergeAdjacentText && this.textInTextBuffer) {
                this.completeCurrentTextNode();
            }
            String string = new String((char[])object, n2, n3);
            object = string;
            if (string.length() > 0) {
                object = new DOMComment((String)object);
                if (this.currentElement != null) {
                    ((AbstractBranch)((DOMElement)this.currentElement)).add((Comment)object);
                    return;
                }
                this.getDocument().appendChild((Node)object);
            }
        }
    }

    public ElementStack getElementStack() {
        return this.elementStack;
    }

    public void setElementStack(ElementStack elementStack) {
        this.elementStack = elementStack;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public void setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public boolean isMergeAdjacentText() {
        return this.mergeAdjacentText;
    }

    public void setMergeAdjacentText(boolean bl) {
        this.mergeAdjacentText = bl;
    }

    public boolean isStripWhitespaceText() {
        return this.stripWhitespaceText;
    }

    public void setStripWhitespaceText(boolean bl) {
        this.stripWhitespaceText = bl;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean bl) {
        this.ignoreComments = bl;
    }

    protected void completeCurrentTextNode() {
        if (this.stripWhitespaceText) {
            boolean bl = true;
            int n2 = this.textBuffer.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Character.isWhitespace(this.textBuffer.charAt(i2))) continue;
                bl = false;
                break;
            }
            if (!bl) {
                DOMText dOMText = new DOMText(this.textBuffer.toString());
                ((DOMElement)this.currentElement).add(dOMText);
            }
        } else {
            DOMText dOMText = new DOMText(this.textBuffer.toString());
            ((DOMElement)this.currentElement).add(dOMText);
        }
        this.textBuffer.setLength(0);
        this.textInTextBuffer = false;
    }

    protected Document createDocument() {
        Object object = this.getEncoding();
        object = this.documentFactory.createDocument((String)object);
        object.setEntityResolver(this.entityResolver);
        if (this.inputSource != null) {
            object.setName(this.inputSource.getSystemId());
        }
        return object;
    }

    private String getEncoding() {
        if (this.locator == null) {
            return null;
        }
        if (this.locator instanceof Locator2) {
            return ((Locator2)this.locator).getEncoding();
        }
        return null;
    }

    protected void addDeclaredNamespaces(Element element) {
        int n2 = this.namespaceStack.size();
        while (this.declaredNamespaceIndex < n2) {
            Namespace namespace = this.namespaceStack.getNamespace(this.declaredNamespaceIndex);
            String string = this.attributeNameForNamespace(namespace);
            ((DOMElement)element).setAttribute(string, namespace.getURI());
            ++this.declaredNamespaceIndex;
        }
    }

    protected void addAttributes(Element element, Attributes attributes) {
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = attributes.getQName(i2);
            if (((String)object).startsWith("xmlns")) continue;
            String string = attributes.getURI(i2);
            String string2 = attributes.getLocalName(i2);
            String string3 = attributes.getValue(i2);
            object = this.namespaceStack.getAttributeQName(string, string2, (String)object);
            object = new DOMAttribute((QName)object, string3);
            ((DOMElement)element).setAttributeNode((Attr)object);
        }
    }

    protected ElementStack createElementStack() {
        return new ElementStack();
    }

    protected String attributeNameForNamespace(Namespace object) {
        String string = "xmlns";
        if (((String)(object = ((Namespace)object).getPrefix())).length() > 0) {
            return string + ":" + (String)object;
        }
        return string;
    }
}

