/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.JAXPHelper;
import org.dom4j.io.SAXHelper;
import org.dom4j.tree.NamespaceStack;
import org.w3c.dom.DOMImplementation;

public class DOMWriter {
    private static boolean loggedWarning = false;
    private static final String[] DEFAULT_DOM_DOCUMENT_CLASSES = new String[]{"org.apache.xerces.dom.DocumentImpl", "gnu.xml.dom.DomDocument", "org.apache.crimson.tree.XmlDocument", "com.sun.xml.tree.XmlDocument", "oracle.xml.parser.v2.XMLDocument", "oracle.xml.parser.XMLDocument", "org.dom4j.dom.DOMDocument"};
    private Class<?> domDocumentClass;
    private NamespaceStack namespaceStack = new NamespaceStack();

    public DOMWriter() {
    }

    public DOMWriter(Class<?> clazz) {
        this.domDocumentClass = clazz;
    }

    public Class<?> getDomDocumentClass() {
        Class<?> clazz = this.domDocumentClass;
        if (clazz == null) {
            int cfr_ignored_0 = DEFAULT_DOM_DOCUMENT_CLASSES.length;
            String[] stringArray = DEFAULT_DOM_DOCUMENT_CLASSES;
            int n2 = DEFAULT_DOM_DOCUMENT_CLASSES.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray[i2];
                try {
                    clazz = Class.forName(string, true, DOMWriter.class.getClassLoader());
                    if (clazz == null) continue;
                    break;
                }
                catch (Exception exception) {}
            }
        }
        return clazz;
    }

    public void setDomDocumentClass(Class<?> clazz) {
        this.domDocumentClass = clazz;
    }

    public void setDomDocumentClassName(String string) {
        try {
            this.domDocumentClass = Class.forName(string, true, DOMWriter.class.getClassLoader());
            return;
        }
        catch (Exception exception) {
            throw new DocumentException("Could not load the DOM Document class: " + string, exception);
        }
    }

    public org.w3c.dom.Document write(Document document) {
        org.w3c.dom.Document document2;
        if (document instanceof org.w3c.dom.Document) {
            return (org.w3c.dom.Document)((Object)document);
        }
        this.resetNamespaceStack();
        org.w3c.dom.Document document3 = document2 = this.createDomDocument(document);
        this.appendDOMTree(document3, (org.w3c.dom.Node)document3, document.content());
        this.namespaceStack.clear();
        return document2;
    }

    public org.w3c.dom.Document write(Document document, DOMImplementation object) {
        if (document instanceof org.w3c.dom.Document) {
            return (org.w3c.dom.Document)((Object)document);
        }
        this.resetNamespaceStack();
        Object object2 = object = this.createDomDocument(document, (DOMImplementation)object);
        this.appendDOMTree((org.w3c.dom.Document)object2, (org.w3c.dom.Node)object2, document.content());
        this.namespaceStack.clear();
        return object;
    }

    protected void appendDOMTree(org.w3c.dom.Document document, org.w3c.dom.Node node, List<Node> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Node node2 = (Node)object.next();
            if (node2 instanceof Element) {
                this.appendDOMTree(document, node, (Element)node2);
                continue;
            }
            if (node2 instanceof Text) {
                node2 = (Text)node2;
                this.appendDOMTree(document, node, node2.getText());
                continue;
            }
            if (node2 instanceof CDATA) {
                this.appendDOMTree(document, node, (CDATA)node2);
                continue;
            }
            if (node2 instanceof Comment) {
                this.appendDOMTree(document, node, (Comment)node2);
                continue;
            }
            if (node2 instanceof Entity) {
                this.appendDOMTree(document, node, (Entity)node2);
                continue;
            }
            if (!(node2 instanceof ProcessingInstruction)) continue;
            this.appendDOMTree(document, node, (ProcessingInstruction)node2);
        }
    }

    protected void appendDOMTree(org.w3c.dom.Document document, org.w3c.dom.Node node, Element element) {
        Object object;
        Object object2 = element.getNamespaceURI();
        String string = element.getQualifiedName();
        object2 = document.createElementNS((String)object2, string);
        int n2 = this.namespaceStack.size();
        Object object3 = element.getNamespace();
        if (this.isNamespaceDeclaration((Namespace)object3)) {
            this.namespaceStack.push((Namespace)object3);
            this.writeNamespace((org.w3c.dom.Element)object2, (Namespace)object3);
        }
        object3 = element.declaredNamespaces();
        int n3 = object3.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            object = (Namespace)object3.get(i2);
            if (!this.isNamespaceDeclaration((Namespace)object)) continue;
            this.namespaceStack.push((Namespace)object);
            this.writeNamespace((org.w3c.dom.Element)object2, (Namespace)object);
        }
        for (Attribute object4 : element.attributes()) {
            object = object4.getNamespaceURI();
            object3 = object4.getQualifiedName();
            String string2 = object4.getValue();
            object2.setAttributeNS((String)object, (String)object3, string2);
        }
        this.appendDOMTree(document, (org.w3c.dom.Node)object2, element.content());
        node.appendChild((org.w3c.dom.Node)object2);
        while (this.namespaceStack.size() > n2) {
            this.namespaceStack.pop();
        }
    }

    protected void appendDOMTree(org.w3c.dom.Document node, org.w3c.dom.Node node2, CDATA cDATA) {
        node = node.createCDATASection(cDATA.getText());
        node2.appendChild(node);
    }

    protected void appendDOMTree(org.w3c.dom.Document node, org.w3c.dom.Node node2, Comment comment) {
        node = node.createComment(comment.getText());
        node2.appendChild(node);
    }

    protected void appendDOMTree(org.w3c.dom.Document node, org.w3c.dom.Node node2, String string) {
        node = node.createTextNode(string);
        node2.appendChild(node);
    }

    protected void appendDOMTree(org.w3c.dom.Document node, org.w3c.dom.Node node2, Entity entity) {
        node = node.createEntityReference(entity.getName());
        node2.appendChild(node);
    }

    protected void appendDOMTree(org.w3c.dom.Document node, org.w3c.dom.Node node2, ProcessingInstruction processingInstruction) {
        node = node.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getText());
        node2.appendChild(node);
    }

    protected void writeNamespace(org.w3c.dom.Element element, Namespace namespace) {
        String string = this.attributeNameForNamespace(namespace);
        element.setAttribute(string, namespace.getURI());
    }

    protected String attributeNameForNamespace(Namespace object) {
        String string = "xmlns";
        if (((String)(object = ((Namespace)object).getPrefix())).length() > 0) {
            return string + ":" + (String)object;
        }
        return string;
    }

    protected org.w3c.dom.Document createDomDocument(Document object) {
        if (this.domDocumentClass != null) {
            try {
                object = (org.w3c.dom.Document)this.domDocumentClass.newInstance();
            }
            catch (Exception exception) {
                throw new DocumentException("Could not instantiate an instance of DOM Document with class: " + this.domDocumentClass.getName(), exception);
            }
        }
        object = this.createDomDocumentViaJAXP();
        if (object == null) {
            Class<?> clazz = this.getDomDocumentClass();
            try {
                object = (org.w3c.dom.Document)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new DocumentException("Could not instantiate an instance of DOM Document with class: " + clazz.getName(), exception);
            }
        }
        return object;
    }

    protected org.w3c.dom.Document createDomDocumentViaJAXP() {
        try {
            return JAXPHelper.createDocument(false, true);
        }
        catch (Throwable throwable) {
            if (!loggedWarning) {
                loggedWarning = true;
                if (SAXHelper.isVerboseErrorReporting()) {
                    System.out.println("Warning: Caught exception attempting to use JAXP to create a W3C DOM document");
                    System.out.println("Warning: Exception was: " + throwable);
                    throwable.printStackTrace();
                } else {
                    System.out.println("Warning: Error occurred using JAXP to create a DOM document.");
                }
            }
            return null;
        }
    }

    protected org.w3c.dom.Document createDomDocument(Document document, DOMImplementation dOMImplementation) {
        return dOMImplementation.createDocument(null, null, null);
    }

    protected boolean isNamespaceDeclaration(Namespace namespace) {
        String string;
        return namespace != null && namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE && (string = namespace.getURI()) != null && string.length() > 0 && !this.namespaceStack.contains(namespace);
    }

    protected void resetNamespaceStack() {
        this.namespaceStack.clear();
        this.namespaceStack.push(Namespace.XML_NAMESPACE);
    }
}

