/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.ArrayList;
import java.util.HashMap;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;

class DispatchHandler
implements ElementHandler {
    private boolean atRoot = true;
    private String path = "/";
    private ArrayList<String> pathStack = new ArrayList();
    private ArrayList<ElementHandler> handlerStack = new ArrayList();
    private HashMap<String, ElementHandler> handlers = new HashMap();
    private ElementHandler defaultHandler;

    public void addHandler(String string, ElementHandler elementHandler) {
        this.handlers.put(string, elementHandler);
    }

    public ElementHandler removeHandler(String string) {
        return this.handlers.remove(string);
    }

    public boolean containsHandler(String string) {
        return this.handlers.containsKey(string);
    }

    public ElementHandler getHandler(String string) {
        return this.handlers.get(string);
    }

    public int getActiveHandlerCount() {
        return this.handlerStack.size();
    }

    public void setDefaultHandler(ElementHandler elementHandler) {
        this.defaultHandler = elementHandler;
    }

    public void resetHandlers() {
        this.atRoot = true;
        this.path = "/";
        this.pathStack.clear();
        this.handlerStack.clear();
        this.handlers.clear();
        this.defaultHandler = null;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public void onStart(ElementPath elementPath) {
        Object object = elementPath.getCurrent();
        this.pathStack.add(this.path);
        if (this.atRoot) {
            this.path = this.path + object.getName();
            this.atRoot = false;
        } else {
            this.path = this.path + "/" + object.getName();
        }
        if (this.handlers != null && this.handlers.containsKey(this.path)) {
            object = this.handlers.get(this.path);
            this.handlerStack.add((ElementHandler)object);
            object.onStart(elementPath);
            return;
        }
        if (this.handlerStack.isEmpty() && this.defaultHandler != null) {
            this.defaultHandler.onStart(elementPath);
        }
    }

    @Override
    public void onEnd(ElementPath elementPath) {
        if (this.handlers != null && this.handlers.containsKey(this.path)) {
            ElementHandler elementHandler = this.handlers.get(this.path);
            this.handlerStack.remove(this.handlerStack.size() - 1);
            elementHandler.onEnd(elementPath);
        } else if (this.handlerStack.isEmpty() && this.defaultHandler != null) {
            this.defaultHandler.onEnd(elementPath);
        }
        this.path = this.pathStack.remove(this.pathStack.size() - 1);
        if (this.pathStack.size() == 0) {
            this.atRoot = true;
        }
    }
}

