/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.DispatchHandler;

class ElementStack
implements ElementPath {
    protected Element[] stack;
    protected int lastElementIndex = -1;
    private DispatchHandler handler = null;

    public ElementStack() {
        this(50);
    }

    public ElementStack(int n2) {
        this.stack = new Element[n2];
    }

    public void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.handler = dispatchHandler;
    }

    public DispatchHandler getDispatchHandler() {
        return this.handler;
    }

    public void clear() {
        this.lastElementIndex = -1;
    }

    public Element peekElement() {
        if (this.lastElementIndex < 0) {
            return null;
        }
        return this.stack[this.lastElementIndex];
    }

    public Element popElement() {
        if (this.lastElementIndex < 0) {
            return null;
        }
        return this.stack[this.lastElementIndex--];
    }

    public void pushElement(Element element) {
        int n2 = this.stack.length;
        if (++this.lastElementIndex >= n2) {
            this.reallocate(n2 << 1);
        }
        this.stack[this.lastElementIndex] = element;
    }

    protected void reallocate(int n2) {
        Element[] elementArray = this.stack;
        this.stack = new Element[n2];
        System.arraycopy(elementArray, 0, this.stack, 0, elementArray.length);
    }

    @Override
    public int size() {
        return this.lastElementIndex + 1;
    }

    @Override
    public Element getElement(int n2) {
        Element element;
        try {
            element = this.stack[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            element = null;
        }
        return element;
    }

    @Override
    public String getPath() {
        if (this.handler == null) {
            this.setDispatchHandler(new DispatchHandler());
        }
        return this.handler.getPath();
    }

    @Override
    public Element getCurrent() {
        return this.peekElement();
    }

    @Override
    public void addHandler(String string, ElementHandler elementHandler) {
        this.handler.addHandler(this.getHandlerPath(string), elementHandler);
    }

    @Override
    public void removeHandler(String string) {
        this.handler.removeHandler(this.getHandlerPath(string));
    }

    public boolean containsHandler(String string) {
        return this.handler.containsHandler(string);
    }

    private String getHandlerPath(String string) {
        if (this.handler == null) {
            this.setDispatchHandler(new DispatchHandler());
        }
        if (!string.startsWith("/")) {
            string = this.getPath().equals("/") ? this.getPath() + string : this.getPath() + "/" + string;
        }
        return string;
    }
}

