/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.io.HTMLWriter$FormatState;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class HTMLWriter
extends XMLWriter {
    private static String lineSeparator = System.getProperty("line.separator");
    protected static final HashSet<String> DEFAULT_PREFORMATTED_TAGS = new HashSet<String>();
    protected static final OutputFormat DEFAULT_HTML_FORMAT;
    private Stack<HTMLWriter$FormatState> formatStack = new Stack();
    private String lastText = "";
    private int tagsOuput = 0;
    private int newLineAfterNTags = -1;
    private HashSet<String> preformattedTags = DEFAULT_PREFORMATTED_TAGS;
    private HashSet<String> omitElementCloseSet;

    public HTMLWriter(Writer writer) {
        super(writer, DEFAULT_HTML_FORMAT);
    }

    public HTMLWriter(Writer writer, OutputFormat outputFormat) {
        super(writer, outputFormat);
    }

    public HTMLWriter() {
        super(DEFAULT_HTML_FORMAT);
    }

    public HTMLWriter(OutputFormat outputFormat) {
        super(outputFormat);
    }

    public HTMLWriter(OutputStream outputStream) {
        super(outputStream, DEFAULT_HTML_FORMAT);
    }

    public HTMLWriter(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputStream, outputFormat);
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void endCDATA() {
    }

    @Override
    protected void writeCDATA(String string) {
        if (this.getOutputFormat().isXHTML()) {
            super.writeCDATA(string);
        } else {
            this.writer.write(string);
        }
        this.lastOutputNodeType = 4;
    }

    @Override
    protected void writeEntity(Entity entity) {
        this.writer.write(entity.getText());
        this.lastOutputNodeType = 5;
    }

    @Override
    protected void writeDeclaration() {
    }

    @Override
    protected void writeString(String string) {
        if (string.equals("\n")) {
            if (!this.formatStack.empty()) {
                super.writeString(lineSeparator);
            }
            return;
        }
        this.lastText = string;
        if (this.formatStack.empty()) {
            super.writeString(string.trim());
            return;
        }
        super.writeString(string);
    }

    @Override
    protected void writeClose(String string) {
        if (!this.omitElementClose(string)) {
            super.writeClose(string);
        }
    }

    @Override
    protected void writeEmptyElementClose(String string) {
        if (this.getOutputFormat().isXHTML()) {
            if (this.omitElementClose(string)) {
                this.writer.write(" />");
                return;
            }
            super.writeEmptyElementClose(string);
            return;
        }
        if (this.omitElementClose(string)) {
            this.writer.write(">");
            return;
        }
        super.writeEmptyElementClose(string);
    }

    protected boolean omitElementClose(String string) {
        return this.internalGetOmitElementCloseSet().contains(string.toUpperCase());
    }

    private HashSet<String> internalGetOmitElementCloseSet() {
        if (this.omitElementCloseSet == null) {
            this.omitElementCloseSet = new HashSet();
            HTMLWriter hTMLWriter = this;
            hTMLWriter.loadOmitElementCloseSet(hTMLWriter.omitElementCloseSet);
        }
        return this.omitElementCloseSet;
    }

    protected void loadOmitElementCloseSet(Set<String> set) {
        set.add("AREA");
        set.add("BASE");
        set.add("BR");
        set.add("COL");
        set.add("HR");
        set.add("IMG");
        set.add("INPUT");
        set.add("LINK");
        set.add("META");
        set.add("P");
        set.add("PARAM");
    }

    public Set<String> getOmitElementCloseSet() {
        return (Set)this.internalGetOmitElementCloseSet().clone();
    }

    public void setOmitElementCloseSet(Set<String> object) {
        this.omitElementCloseSet = new HashSet();
        if (object != null) {
            this.omitElementCloseSet = new HashSet();
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (string == null) continue;
                this.omitElementCloseSet.add(string.toUpperCase());
            }
        }
    }

    public Set<String> getPreformattedTags() {
        return (Set)this.preformattedTags.clone();
    }

    public void setPreformattedTags(Set<String> object) {
        this.preformattedTags = new HashSet();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (string == null) continue;
                this.preformattedTags.add(string.toUpperCase());
            }
        }
    }

    public boolean isPreformattedTag(String string) {
        return this.preformattedTags != null && this.preformattedTags.contains(string.toUpperCase());
    }

    @Override
    protected void writeElement(Element object) {
        if (this.newLineAfterNTags == -1) {
            this.lazyInitNewLinesAfterNTags();
        }
        if (this.newLineAfterNTags > 0 && this.tagsOuput > 0 && this.tagsOuput % this.newLineAfterNTags == 0) {
            this.writer.write(lineSeparator);
        }
        ++this.tagsOuput;
        Object object2 = object.getQualifiedName();
        String string = this.lastText;
        object.nodeCount();
        if (this.isPreformattedTag((String)object2)) {
            object2 = this.getOutputFormat();
            boolean bl = ((OutputFormat)object2).isNewlines();
            boolean bl2 = ((OutputFormat)object2).isTrimText();
            String string2 = ((OutputFormat)object2).getIndent();
            this.formatStack.push(new HTMLWriter$FormatState(this, bl, bl2, string2));
            try {
                super.writePrintln();
                if (string.trim().length() == 0 && string2 != null && string2.length() > 0) {
                    this.writer.write(this.justSpaces(string));
                }
                ((OutputFormat)object2).setNewlines(false);
                ((OutputFormat)object2).setTrimText(false);
                ((OutputFormat)object2).setIndent("");
                super.writeElement((Element)object);
            }
            finally {
                object = this.formatStack.pop();
                ((OutputFormat)object2).setNewlines(((HTMLWriter$FormatState)object).isNewlines());
                ((OutputFormat)object2).setTrimText(((HTMLWriter$FormatState)object).isTrimText());
                ((OutputFormat)object2).setIndent(((HTMLWriter$FormatState)object).getIndent());
            }
        } else {
            super.writeElement((Element)object);
        }
    }

    private String justSpaces(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\n': 
                case '\r': {
                    continue block3;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void lazyInitNewLinesAfterNTags() {
        if (this.getOutputFormat().isNewlines()) {
            this.newLineAfterNTags = 0;
            return;
        }
        this.newLineAfterNTags = this.getOutputFormat().getNewLineAfterNTags();
    }

    public static String prettyPrintHTML(String string) {
        return HTMLWriter.prettyPrintHTML(string, true, true, false, true);
    }

    public static String prettyPrintXHTML(String string) {
        return HTMLWriter.prettyPrintHTML(string, true, true, true, false);
    }

    public static String prettyPrintHTML(String object, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setNewlines(bl);
        outputFormat.setTrimText(bl2);
        outputFormat.setXHTML(bl3);
        outputFormat.setExpandEmptyElements(bl4);
        HTMLWriter hTMLWriter = new HTMLWriter(stringWriter, outputFormat);
        object = DocumentHelper.parseText((String)object);
        hTMLWriter.write((Document)object);
        hTMLWriter.flush();
        return stringWriter.toString();
    }

    static {
        DEFAULT_PREFORMATTED_TAGS.add("PRE");
        DEFAULT_PREFORMATTED_TAGS.add("SCRIPT");
        DEFAULT_PREFORMATTED_TAGS.add("STYLE");
        DEFAULT_PREFORMATTED_TAGS.add("TEXTAREA");
        DEFAULT_HTML_FORMAT = new OutputFormat("  ", true);
        DEFAULT_HTML_FORMAT.setTrimText(true);
        DEFAULT_HTML_FORMAT.setSuppressDeclaration(true);
    }
}

