/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

public class OutputFormat
implements Cloneable {
    protected static final String STANDARD_INDENT = "  ";
    private boolean suppressDeclaration = false;
    private boolean newLineAfterDeclaration = true;
    private String encoding = "UTF-8";
    private boolean omitEncoding = false;
    private String indent = null;
    private boolean expandEmptyElements = false;
    private boolean newlines = false;
    private String lineSeparator = "\n";
    private boolean trimText = false;
    private boolean padText = false;
    private boolean doXHTML = false;
    private int newLineAfterNTags = 0;
    private char attributeQuoteChar = (char)34;

    public OutputFormat() {
    }

    public OutputFormat(String string) {
        this.indent = string;
    }

    public OutputFormat(String string, boolean bl) {
        this.indent = string;
        this.newlines = bl;
    }

    public OutputFormat(String string, boolean bl, String string2) {
        this.indent = string;
        this.newlines = bl;
        this.encoding = string2;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public boolean isNewlines() {
        return this.newlines;
    }

    public void setNewlines(boolean bl) {
        this.newlines = bl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        if (string != null) {
            this.encoding = string;
        }
    }

    public boolean isOmitEncoding() {
        return this.omitEncoding;
    }

    public void setOmitEncoding(boolean bl) {
        this.omitEncoding = bl;
    }

    public void setSuppressDeclaration(boolean bl) {
        this.suppressDeclaration = bl;
    }

    public boolean isSuppressDeclaration() {
        return this.suppressDeclaration;
    }

    public void setNewLineAfterDeclaration(boolean bl) {
        this.newLineAfterDeclaration = bl;
    }

    public boolean isNewLineAfterDeclaration() {
        return this.newLineAfterDeclaration;
    }

    public boolean isExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public void setExpandEmptyElements(boolean bl) {
        this.expandEmptyElements = bl;
    }

    public boolean isTrimText() {
        return this.trimText;
    }

    public void setTrimText(boolean bl) {
        this.trimText = bl;
    }

    public boolean isPadText() {
        return this.padText;
    }

    public void setPadText(boolean bl) {
        this.padText = bl;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String string) {
        if (string != null && string.length() <= 0) {
            string = null;
        }
        this.indent = string;
    }

    public void setIndent(boolean bl) {
        if (bl) {
            this.indent = STANDARD_INDENT;
            return;
        }
        this.indent = null;
    }

    public void setIndentSize(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(" ");
        }
        this.indent = stringBuffer.toString();
    }

    public boolean isXHTML() {
        return this.doXHTML;
    }

    public void setXHTML(boolean bl) {
        this.doXHTML = bl;
    }

    public int getNewLineAfterNTags() {
        return this.newLineAfterNTags;
    }

    public void setNewLineAfterNTags(int n2) {
        this.newLineAfterNTags = n2;
    }

    public char getAttributeQuoteCharacter() {
        return this.attributeQuoteChar;
    }

    public void setAttributeQuoteCharacter(char c2) {
        if (c2 == '\'' || c2 == '\"') {
            this.attributeQuoteChar = c2;
            return;
        }
        throw new IllegalArgumentException("Invalid attribute quote character (" + c2 + ")");
    }

    public int parseOptions(String[] stringArray, int n2) {
        int n3 = stringArray.length;
        while (n2 < n3) {
            if (stringArray[n2].equals("-suppressDeclaration")) {
                this.setSuppressDeclaration(true);
            } else if (stringArray[n2].equals("-omitEncoding")) {
                this.setOmitEncoding(true);
            } else if (stringArray[n2].equals("-indent")) {
                this.setIndent(stringArray[++n2]);
            } else if (stringArray[n2].equals("-indentSize")) {
                this.setIndentSize(Integer.parseInt(stringArray[++n2]));
            } else if (stringArray[n2].startsWith("-expandEmpty")) {
                this.setExpandEmptyElements(true);
            } else if (stringArray[n2].equals("-encoding")) {
                this.setEncoding(stringArray[++n2]);
            } else if (stringArray[n2].equals("-newlines")) {
                this.setNewlines(true);
            } else if (stringArray[n2].equals("-lineSeparator")) {
                this.setLineSeparator(stringArray[++n2]);
            } else if (stringArray[n2].equals("-trimText")) {
                this.setTrimText(true);
            } else if (stringArray[n2].equals("-padText")) {
                this.setPadText(true);
            } else if (stringArray[n2].startsWith("-xhtml")) {
                this.setXHTML(true);
            } else {
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    public static OutputFormat createPrettyPrint() {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndentSize(2);
        outputFormat.setNewlines(true);
        outputFormat.setTrimText(true);
        outputFormat.setPadText(true);
        return outputFormat;
    }

    public static OutputFormat createCompactFormat() {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndent(false);
        outputFormat.setNewlines(false);
        outputFormat.setTrimText(true);
        return outputFormat;
    }
}

