/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dtd.AttributeDecl;
import org.dom4j.dtd.Decl;
import org.dom4j.dtd.ElementDecl;
import org.dom4j.dtd.ExternalEntityDecl;
import org.dom4j.dtd.InternalEntityDecl;
import org.dom4j.io.DispatchHandler;
import org.dom4j.io.ElementStack;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

public class SAXContentHandler
extends DefaultHandler
implements DTDHandler,
DeclHandler,
LexicalHandler {
    private DocumentFactory documentFactory;
    private Document document;
    private ElementStack elementStack;
    private NamespaceStack namespaceStack;
    private ElementHandler elementHandler;
    private Locator locator;
    private String entity;
    private boolean insideDTDSection;
    private boolean insideCDATASection;
    private StringBuffer cdataText;
    private List<Decl> internalDTDDeclarations;
    private List<Decl> externalDTDDeclarations;
    private int declaredNamespaceIndex;
    private EntityResolver entityResolver;
    private InputSource inputSource;
    private Element currentElement;
    private boolean includeInternalDTDDeclarations = false;
    private boolean includeExternalDTDDeclarations = false;
    private int entityLevel;
    private boolean internalDTDsubset = false;
    private boolean mergeAdjacentText = false;
    private boolean textInTextBuffer = false;
    private boolean ignoreComments = false;
    private StringBuffer textBuffer;
    private boolean stripWhitespaceText = false;

    public SAXContentHandler() {
        this(DocumentFactory.getInstance());
    }

    public SAXContentHandler(DocumentFactory documentFactory) {
        this(documentFactory, null);
    }

    public SAXContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler) {
        this(documentFactory, elementHandler, null);
        this.elementStack = this.createElementStack();
    }

    public SAXContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler, ElementStack elementStack) {
        this.documentFactory = documentFactory;
        this.elementHandler = elementHandler;
        this.elementStack = elementStack;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        return this.document;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void processingInstruction(String string, String string2) {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        if (this.currentElement != null) {
            this.currentElement.addProcessingInstruction(string, string2);
            return;
        }
        this.getDocument().addProcessingInstruction(string, string2);
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        this.namespaceStack.push(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) {
        this.namespaceStack.pop(string);
        this.declaredNamespaceIndex = this.namespaceStack.size();
    }

    @Override
    public void startDocument() {
        this.document = null;
        this.currentElement = null;
        this.elementStack.clear();
        if (this.elementHandler != null && this.elementHandler instanceof DispatchHandler) {
            this.elementStack.setDispatchHandler((DispatchHandler)this.elementHandler);
        }
        this.namespaceStack.clear();
        this.declaredNamespaceIndex = 0;
        if (this.mergeAdjacentText && this.textBuffer == null) {
            this.textBuffer = new StringBuffer();
        }
        this.textInTextBuffer = false;
    }

    @Override
    public void endDocument() {
        this.namespaceStack.clear();
        this.elementStack.clear();
        this.currentElement = null;
        this.textBuffer = null;
    }

    @Override
    public void startElement(String object, String object2, String string, Attributes attributes) {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        object = this.namespaceStack.getQName((String)object, (String)object2, string);
        object2 = this.currentElement;
        if (object2 == null) {
            object2 = this.getDocument();
        }
        object = object2.addElement((QName)object);
        this.addDeclaredNamespaces((Element)object);
        this.addAttributes((Element)object, attributes);
        this.elementStack.pushElement((Element)object);
        this.currentElement = object;
        this.entity = null;
        if (this.elementHandler != null) {
            this.elementHandler.onStart(this.elementStack);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        if (this.elementHandler != null && this.currentElement != null) {
            this.elementHandler.onEnd(this.elementStack);
        }
        this.elementStack.popElement();
        this.currentElement = this.elementStack.peekElement();
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (this.currentElement != null) {
            if (this.entity != null) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.currentElement.addEntity(this.entity, new String(cArray, n2, n3));
                this.entity = null;
                return;
            }
            if (this.insideCDATASection) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.cdataText.append(new String(cArray, n2, n3));
                return;
            }
            if (this.mergeAdjacentText) {
                this.textBuffer.append(cArray, n2, n3);
                this.textInTextBuffer = true;
                return;
            }
            this.currentElement.addText(new String(cArray, n2, n3));
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        throw sAXParseException;
    }

    @Override
    public void startDTD(String string, String string2, String string3) {
        this.getDocument().addDocType(string, string2, string3);
        this.insideDTDSection = true;
        this.internalDTDsubset = true;
    }

    @Override
    public void endDTD() {
        this.insideDTDSection = false;
        DocumentType documentType = this.getDocument().getDocType();
        if (documentType != null) {
            if (this.internalDTDDeclarations != null) {
                documentType.setInternalDeclarations(this.internalDTDDeclarations);
            }
            if (this.externalDTDDeclarations != null) {
                documentType.setExternalDeclarations(this.externalDTDDeclarations);
            }
        }
        this.internalDTDDeclarations = null;
        this.externalDTDDeclarations = null;
    }

    @Override
    public void startEntity(String string) {
        ++this.entityLevel;
        this.entity = null;
        if (!this.insideDTDSection && !this.isIgnorableEntity(string)) {
            this.entity = string;
        }
        this.internalDTDsubset = false;
    }

    @Override
    public void endEntity(String string) {
        --this.entityLevel;
        this.entity = null;
        if (this.entityLevel == 0) {
            this.internalDTDsubset = true;
        }
    }

    @Override
    public void startCDATA() {
        this.insideCDATASection = true;
        this.cdataText = new StringBuffer();
    }

    @Override
    public void endCDATA() {
        this.insideCDATASection = false;
        this.currentElement.addCDATA(this.cdataText.toString());
    }

    @Override
    public void comment(char[] object, int n2, int n3) {
        if (!this.ignoreComments) {
            if (this.mergeAdjacentText && this.textInTextBuffer) {
                this.completeCurrentTextNode();
            }
            object = new String((char[])object, n2, n3);
            if (!this.insideDTDSection && ((String)object).length() > 0) {
                if (this.currentElement != null) {
                    this.currentElement.addComment((String)object);
                    return;
                }
                this.getDocument().addComment((String)object);
            }
        }
    }

    @Override
    public void elementDecl(String string, String string2) {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new ElementDecl(string, string2));
                return;
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new ElementDecl(string, string2));
        }
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new AttributeDecl(string, string2, string3, string4, string5));
                return;
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new AttributeDecl(string, string2, string3, string4, string5));
        }
    }

    @Override
    public void internalEntityDecl(String string, String string2) {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration(new InternalEntityDecl(string, string2));
                return;
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration(new InternalEntityDecl(string, string2));
        }
    }

    @Override
    public void externalEntityDecl(String object, String string, String string2) {
        object = new ExternalEntityDecl((String)object, string, string2);
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration((Decl)object);
                return;
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration((Decl)object);
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) {
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
    }

    public ElementStack getElementStack() {
        return this.elementStack;
    }

    public void setElementStack(ElementStack elementStack) {
        this.elementStack = elementStack;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public void setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public boolean isIncludeInternalDTDDeclarations() {
        return this.includeInternalDTDDeclarations;
    }

    public void setIncludeInternalDTDDeclarations(boolean bl) {
        this.includeInternalDTDDeclarations = bl;
    }

    public boolean isIncludeExternalDTDDeclarations() {
        return this.includeExternalDTDDeclarations;
    }

    public void setIncludeExternalDTDDeclarations(boolean bl) {
        this.includeExternalDTDDeclarations = bl;
    }

    public boolean isMergeAdjacentText() {
        return this.mergeAdjacentText;
    }

    public void setMergeAdjacentText(boolean bl) {
        this.mergeAdjacentText = bl;
    }

    public boolean isStripWhitespaceText() {
        return this.stripWhitespaceText;
    }

    public void setStripWhitespaceText(boolean bl) {
        this.stripWhitespaceText = bl;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean bl) {
        this.ignoreComments = bl;
    }

    protected void completeCurrentTextNode() {
        if (this.stripWhitespaceText) {
            boolean bl = true;
            int n2 = this.textBuffer.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Character.isWhitespace(this.textBuffer.charAt(i2))) continue;
                bl = false;
                break;
            }
            if (!bl) {
                this.currentElement.addText(this.textBuffer.toString());
            }
        } else {
            this.currentElement.addText(this.textBuffer.toString());
        }
        this.textBuffer.setLength(0);
        this.textInTextBuffer = false;
    }

    protected Document createDocument() {
        Object object = this.getEncoding();
        object = this.documentFactory.createDocument((String)object);
        object.setEntityResolver(this.entityResolver);
        if (this.inputSource != null) {
            object.setName(this.inputSource.getSystemId());
        }
        return object;
    }

    private String getEncoding() {
        if (this.locator == null) {
            return null;
        }
        if (this.locator instanceof Locator2) {
            return ((Locator2)this.locator).getEncoding();
        }
        return null;
    }

    protected boolean isIgnorableEntity(String string) {
        return "amp".equals(string) || "apos".equals(string) || "gt".equals(string) || "lt".equals(string) || "quot".equals(string);
    }

    protected void addDeclaredNamespaces(Element element) {
        element.getNamespace();
        int n2 = this.namespaceStack.size();
        while (this.declaredNamespaceIndex < n2) {
            Namespace namespace = this.namespaceStack.getNamespace(this.declaredNamespaceIndex);
            element.add(namespace);
            ++this.declaredNamespaceIndex;
        }
    }

    protected void addAttributes(Element element, Attributes attributes) {
        if (element instanceof AbstractElement) {
            AbstractElement abstractElement = (AbstractElement)element;
            abstractElement.setAttributes(attributes, this.namespaceStack, false);
            return;
        }
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = attributes.getQName(i2);
            if (((String)object).startsWith("xmlns")) continue;
            String string = attributes.getURI(i2);
            String string2 = attributes.getLocalName(i2);
            String string3 = attributes.getValue(i2);
            object = this.namespaceStack.getAttributeQName(string, string2, (String)object);
            element.addAttribute((QName)object, string3);
        }
    }

    protected void addDTDDeclaration(Decl decl) {
        if (this.internalDTDDeclarations == null) {
            this.internalDTDDeclarations = new ArrayList<Decl>();
        }
        this.internalDTDDeclarations.add(decl);
    }

    protected void addExternalDTDDeclaration(Decl decl) {
        if (this.externalDTDDeclarations == null) {
            this.externalDTDDeclarations = new ArrayList<Decl>();
        }
        this.externalDTDDeclarations.add(decl);
    }

    protected ElementStack createElementStack() {
        return new ElementStack();
    }
}

