/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.DocumentInputSource;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class SAXWriter
implements XMLReader {
    protected static final String[] LEXICAL_HANDLER_NAMES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler"};
    protected static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private LexicalHandler lexicalHandler;
    private AttributesImpl attributes = new AttributesImpl();
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean declareNamespaceAttributes;

    public SAXWriter() {
        this.properties.put(FEATURE_NAMESPACE_PREFIXES, Boolean.FALSE);
        this.properties.put(FEATURE_NAMESPACE_PREFIXES, Boolean.TRUE);
    }

    public SAXWriter(ContentHandler contentHandler) {
        this();
        this.contentHandler = contentHandler;
    }

    public SAXWriter(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this();
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
    }

    public SAXWriter(ContentHandler contentHandler, LexicalHandler lexicalHandler, EntityResolver entityResolver) {
        this();
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
        this.entityResolver = entityResolver;
    }

    public void write(Node node) {
        short s2 = node.getNodeType();
        switch (s2) {
            case 1: {
                this.write((Element)node);
                return;
            }
            case 2: {
                this.write((Attribute)node);
                return;
            }
            case 3: {
                this.write(node.getText());
                return;
            }
            case 4: {
                this.write((CDATA)node);
                return;
            }
            case 5: {
                this.write((Entity)node);
                return;
            }
            case 7: {
                this.write((ProcessingInstruction)node);
                return;
            }
            case 8: {
                this.write((Comment)node);
                return;
            }
            case 9: {
                this.write((Document)node);
                return;
            }
            case 10: {
                this.write((DocumentType)node);
                return;
            }
            case 13: {
                return;
            }
        }
        throw new SAXException("Invalid node type: " + node);
    }

    public void write(Document document) {
        if (document != null) {
            this.checkForNullHandlers();
            this.documentLocator(document);
            this.startDocument();
            this.entityResolver(document);
            this.dtdHandler(document);
            this.writeContent(document, new NamespaceStack());
            this.endDocument();
        }
    }

    public void write(Element element) {
        this.write(element, new NamespaceStack());
    }

    public void writeOpen(Element element) {
        this.startElement(element, null);
    }

    public void writeClose(Element element) {
        this.endElement(element);
    }

    public void write(String object) {
        if (object != null) {
            object = ((String)object).toCharArray();
            this.contentHandler.characters((char[])object, 0, ((Object)object).length);
        }
    }

    public void write(CDATA object) {
        object = object.getText();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
            this.write((String)object);
            this.lexicalHandler.endCDATA();
            return;
        }
        this.write((String)object);
    }

    public void write(Comment object) {
        if (this.lexicalHandler != null) {
            object = object.getText();
            object = ((String)object).toCharArray();
            this.lexicalHandler.comment((char[])object, 0, ((Object)object).length);
        }
    }

    public void write(Entity object) {
        String string = object.getText();
        if (this.lexicalHandler != null) {
            object = object.getName();
            this.lexicalHandler.startEntity((String)object);
            this.write(string);
            this.lexicalHandler.endEntity((String)object);
            return;
        }
        this.write(string);
    }

    public void write(ProcessingInstruction object) {
        String string = object.getTarget();
        object = object.getText();
        this.contentHandler.processingInstruction(string, (String)object);
    }

    public boolean isDeclareNamespaceAttributes() {
        return this.declareNamespaceAttributes;
    }

    public void setDeclareNamespaceAttributes(boolean bl) {
        this.declareNamespaceAttributes = bl;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.setContentHandler(xMLReader.getContentHandler());
        this.setDTDHandler(xMLReader.getDTDHandler());
        this.setEntityResolver(xMLReader.getEntityResolver());
        this.setErrorHandler(xMLReader.getErrorHandler());
    }

    @Override
    public boolean getFeature(String object) {
        return (object = this.features.get(object)) != null && ((Boolean)object).booleanValue();
    }

    @Override
    public void setFeature(String string, boolean bl) {
        if (FEATURE_NAMESPACE_PREFIXES.equals(string)) {
            this.setDeclareNamespaceAttributes(bl);
        } else if (FEATURE_NAMESPACE_PREFIXES.equals(string) && !bl) {
            string = "Namespace feature is always supported in dom4j";
            throw new SAXNotSupportedException(string);
        }
        this.features.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setProperty(String string, Object object) {
        String[] stringArray = LEXICAL_HANDLER_NAMES;
        int n2 = LEXICAL_HANDLER_NAMES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!string2.equals(string)) continue;
            this.setLexicalHandler((LexicalHandler)object);
            return;
        }
        this.properties.put(string, object);
    }

    @Override
    public Object getProperty(String string) {
        String[] stringArray = LEXICAL_HANDLER_NAMES;
        int n2 = LEXICAL_HANDLER_NAMES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!string2.equals(string)) continue;
            return this.getLexicalHandler();
        }
        return this.properties.get(string);
    }

    @Override
    public void parse(String string) {
        throw new SAXNotSupportedException("This XMLReader can only accept <dom4j> InputSource objects");
    }

    @Override
    public void parse(InputSource object) {
        if (object instanceof DocumentInputSource) {
            object = (DocumentInputSource)object;
            object = ((DocumentInputSource)object).getDocument();
            this.write((Document)object);
            return;
        }
        throw new SAXNotSupportedException("This XMLReader can only accept <dom4j> InputSource objects");
    }

    protected void writeContent(Branch object, NamespaceStack namespaceStack) {
        object = object.nodeIterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            if (node instanceof Element) {
                this.write((Element)node, namespaceStack);
                continue;
            }
            if (node instanceof CharacterData) {
                if (node instanceof Text) {
                    node = (Text)node;
                    this.write(node.getText());
                    continue;
                }
                if (node instanceof CDATA) {
                    this.write((CDATA)node);
                    continue;
                }
                if (node instanceof Comment) {
                    this.write((Comment)node);
                    continue;
                }
                throw new SAXException("Invalid Node in DOM4J content: " + node + " of type: " + node.getClass());
            }
            if (node instanceof Entity) {
                this.write((Entity)node);
                continue;
            }
            if (node instanceof ProcessingInstruction) {
                this.write((ProcessingInstruction)node);
                continue;
            }
            if (node instanceof Namespace) {
                this.write((Namespace)node);
                continue;
            }
            throw new SAXException("Invalid Node in DOM4J content: " + node);
        }
    }

    protected void documentLocator(Document node) {
        LocatorImpl locatorImpl = new LocatorImpl();
        String string = null;
        String string2 = null;
        if ((node = node.getDocType()) != null) {
            string = node.getPublicID();
            string2 = node.getSystemID();
        }
        if (string != null) {
            locatorImpl.setPublicId(string);
        }
        if (string2 != null) {
            locatorImpl.setSystemId(string2);
        }
        locatorImpl.setLineNumber(-1);
        locatorImpl.setColumnNumber(-1);
        this.contentHandler.setDocumentLocator(locatorImpl);
    }

    protected void entityResolver(Document object) {
        if (this.entityResolver != null && (object = object.getDocType()) != null) {
            String string = object.getPublicID();
            object = object.getSystemID();
            if (string != null || object != null) {
                try {
                    this.entityResolver.resolveEntity(string, (String)object);
                    return;
                }
                catch (IOException iOException) {
                    throw new SAXException("Could not resolve publicID: " + string + " systemID: " + (String)object, iOException);
                }
            }
        }
    }

    protected void dtdHandler(Document document) {
    }

    protected void startDocument() {
        this.contentHandler.startDocument();
    }

    protected void endDocument() {
        this.contentHandler.endDocument();
    }

    protected void write(Element element, NamespaceStack namespaceStack) {
        int n2 = namespaceStack.size();
        AttributesImpl attributesImpl = this.startPrefixMapping(element, namespaceStack);
        this.startElement(element, attributesImpl);
        this.writeContent(element, namespaceStack);
        this.endElement(element);
        this.endPrefixMapping(namespaceStack, n2);
    }

    protected AttributesImpl startPrefixMapping(Element iterator, NamespaceStack namespaceStack) {
        AttributesImpl attributesImpl = null;
        Namespace namespace = iterator.getNamespace();
        if (namespace != null && !this.isIgnoreableNamespace(namespace, namespaceStack)) {
            namespaceStack.push(namespace);
            this.contentHandler.startPrefixMapping(namespace.getPrefix(), namespace.getURI());
            attributesImpl = this.addNamespaceAttribute(null, namespace);
        }
        iterator = iterator.declaredNamespaces();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            namespace = iterator.next();
            if (this.isIgnoreableNamespace(namespace, namespaceStack)) continue;
            namespaceStack.push(namespace);
            this.contentHandler.startPrefixMapping(namespace.getPrefix(), namespace.getURI());
            attributesImpl = this.addNamespaceAttribute(attributesImpl, namespace);
        }
        return attributesImpl;
    }

    protected void endPrefixMapping(NamespaceStack namespaceStack, int n2) {
        while (namespaceStack.size() > n2) {
            Namespace namespace = namespaceStack.pop();
            if (namespace == null) continue;
            this.contentHandler.endPrefixMapping(namespace.getPrefix());
        }
    }

    protected void startElement(Element element, AttributesImpl attributesImpl) {
        this.contentHandler.startElement(element.getNamespaceURI(), element.getName(), element.getQualifiedName(), this.createAttributes(element, attributesImpl));
    }

    protected void endElement(Element element) {
        this.contentHandler.endElement(element.getNamespaceURI(), element.getName(), element.getQualifiedName());
    }

    protected Attributes createAttributes(Element object, Attributes object2) {
        this.attributes.clear();
        if (object2 != null) {
            this.attributes.setAttributes((Attributes)object2);
        }
        object = object.attributeIterator();
        while (object.hasNext()) {
            object2 = (Attribute)object.next();
            this.attributes.addAttribute(object2.getNamespaceURI(), object2.getName(), object2.getQualifiedName(), "CDATA", object2.getValue());
        }
        return this.attributes;
    }

    protected AttributesImpl addNamespaceAttribute(AttributesImpl attributesImpl, Namespace object) {
        if (this.declareNamespaceAttributes) {
            if (attributesImpl == null) {
                attributesImpl = new AttributesImpl();
            }
            String string = ((Namespace)object).getPrefix();
            String string2 = "xmlns";
            if (string != null && string.length() > 0) {
                string2 = "xmlns:" + string;
            }
            String string3 = "";
            String string4 = "CDATA";
            object = ((Namespace)object).getURI();
            attributesImpl.addAttribute(string3, string, string2, string4, (String)object);
        }
        return attributesImpl;
    }

    protected boolean isIgnoreableNamespace(Namespace namespace, NamespaceStack namespaceStack) {
        if (namespace.equals(Namespace.NO_NAMESPACE) || namespace.equals(Namespace.XML_NAMESPACE)) {
            return true;
        }
        String string = namespace.getURI();
        if (string == null || string.length() <= 0) {
            return true;
        }
        return namespaceStack.contains(namespace);
    }

    protected void checkForNullHandlers() {
    }
}

