/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.dom4j.Attribute;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;

public class STAXEventReader {
    private DocumentFactory factory;
    private XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    public STAXEventReader() {
        this.factory = DocumentFactory.getInstance();
    }

    public STAXEventReader(DocumentFactory documentFactory) {
        if (documentFactory != null) {
            this.factory = documentFactory;
            return;
        }
        this.factory = DocumentFactory.getInstance();
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        if (documentFactory != null) {
            this.factory = documentFactory;
            return;
        }
        this.factory = DocumentFactory.getInstance();
    }

    public Document readDocument(InputStream inputStream) {
        return this.readDocument(inputStream, null);
    }

    public Document readDocument(Reader reader) {
        return this.readDocument(reader, null);
    }

    public Document readDocument(InputStream object, String object2) {
        object = this.inputFactory.createXMLEventReader((String)object2, (InputStream)object);
        try {
            object2 = this.readDocument((XMLEventReader)object);
            return object2;
        }
        finally {
            object.close();
        }
    }

    public Document readDocument(Reader object, String object2) {
        object = this.inputFactory.createXMLEventReader((String)object2, (Reader)object);
        try {
            object2 = this.readDocument((XMLEventReader)object);
            return object2;
        }
        finally {
            object.close();
        }
    }

    public Node readNode(XMLEventReader xMLEventReader) {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isStartElement()) {
            return this.readElement(xMLEventReader);
        }
        if (xMLEvent.isCharacters()) {
            return this.readCharacters(xMLEventReader);
        }
        if (xMLEvent.isStartDocument()) {
            return this.readDocument(xMLEventReader);
        }
        if (xMLEvent.isProcessingInstruction()) {
            return this.readProcessingInstruction(xMLEventReader);
        }
        if (xMLEvent.isEntityReference()) {
            return this.readEntityReference(xMLEventReader);
        }
        if (xMLEvent.isAttribute()) {
            return this.readAttribute(xMLEventReader);
        }
        if (xMLEvent.isNamespace()) {
            return this.readNamespace(xMLEventReader);
        }
        throw new XMLStreamException("Unsupported event: " + xMLEvent);
    }

    public Document readDocument(XMLEventReader xMLEventReader) {
        Document document = null;
        block4: while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.peek();
            int n2 = xMLEvent.getEventType();
            switch (n2) {
                case 7: {
                    StartDocument startDocument = (StartDocument)xMLEventReader.nextEvent();
                    if (document == null) {
                        if (startDocument.encodingSet()) {
                            object = startDocument.getCharacterEncodingScheme();
                            document = this.factory.createDocument((String)object);
                            continue block4;
                        }
                        document = this.factory.createDocument();
                        continue block4;
                    }
                    object = "Unexpected StartDocument event";
                    throw new XMLStreamException((String)object, startDocument.getLocation());
                }
                case 4: 
                case 6: 
                case 8: {
                    xMLEventReader.nextEvent();
                    continue block4;
                }
            }
            if (document == null) {
                document = this.factory.createDocument();
            }
            object = this.readNode(xMLEventReader);
            document.add((Node)object);
        }
        return document;
    }

    public Element readElement(XMLEventReader xMLEventReader) {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isStartElement()) {
            xMLEvent = xMLEventReader.nextEvent().asStartElement();
            Element element = this.createElement((StartElement)xMLEvent);
            while (true) {
                Object object;
                if (!xMLEventReader.hasNext()) {
                    object = "Unexpected end of stream while reading element content";
                    throw new XMLStreamException((String)object);
                }
                object = xMLEventReader.peek();
                if (object.isEndElement()) {
                    object = xMLEventReader.nextEvent().asEndElement();
                    if (object.getName().equals(xMLEvent.getName())) break;
                    throw new XMLStreamException("Expected " + xMLEvent.getName() + " end-tag, but found" + object.getName());
                }
                object = this.readNode(xMLEventReader);
                element.add((Node)object);
            }
            return element;
        }
        throw new XMLStreamException("Expected Element event, found: " + xMLEvent);
    }

    public Attribute readAttribute(XMLEventReader object) {
        XMLEvent xMLEvent = object.peek();
        if (xMLEvent.isAttribute()) {
            object = (javax.xml.stream.events.Attribute)object.nextEvent();
            return this.createAttribute(null, (javax.xml.stream.events.Attribute)object);
        }
        throw new XMLStreamException("Expected Attribute event, found: " + xMLEvent);
    }

    public Namespace readNamespace(XMLEventReader object) {
        XMLEvent xMLEvent = object.peek();
        if (xMLEvent.isNamespace()) {
            object = (javax.xml.stream.events.Namespace)object.nextEvent();
            return this.createNamespace((javax.xml.stream.events.Namespace)object);
        }
        throw new XMLStreamException("Expected Namespace event, found: " + xMLEvent);
    }

    public CharacterData readCharacters(XMLEventReader object) {
        XMLEvent xMLEvent = object.peek();
        if (xMLEvent.isCharacters()) {
            object = object.nextEvent().asCharacters();
            return this.createCharacterData((Characters)object);
        }
        throw new XMLStreamException("Expected Characters event, found: " + xMLEvent);
    }

    public Comment readComment(XMLEventReader xMLEventReader) {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent instanceof javax.xml.stream.events.Comment) {
            return this.createComment((javax.xml.stream.events.Comment)xMLEventReader.nextEvent());
        }
        throw new XMLStreamException("Expected Comment event, found: " + xMLEvent);
    }

    public Entity readEntityReference(XMLEventReader object) {
        XMLEvent xMLEvent = object.peek();
        if (xMLEvent.isEntityReference()) {
            object = (EntityReference)object.nextEvent();
            return this.createEntity((EntityReference)object);
        }
        throw new XMLStreamException("Expected EntityRef event, found: " + xMLEvent);
    }

    public ProcessingInstruction readProcessingInstruction(XMLEventReader object) {
        XMLEvent xMLEvent = object.peek();
        if (xMLEvent.isProcessingInstruction()) {
            object = (javax.xml.stream.events.ProcessingInstruction)object.nextEvent();
            return this.createProcessingInstruction((javax.xml.stream.events.ProcessingInstruction)object);
        }
        throw new XMLStreamException("Expected PI event, found: " + xMLEvent);
    }

    public Element createElement(StartElement startElement) {
        javax.xml.stream.events.Attribute attribute;
        Object object = startElement.getName();
        object = this.createQName((javax.xml.namespace.QName)object);
        object = this.factory.createElement((QName)object);
        Iterator iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            attribute = (javax.xml.stream.events.Attribute)iterator.next();
            object.addAttribute(this.createQName(attribute.getName()), attribute.getValue());
        }
        iterator = startElement.getNamespaces();
        while (iterator.hasNext()) {
            attribute = (javax.xml.stream.events.Namespace)iterator.next();
            object.addNamespace(attribute.getPrefix(), attribute.getNamespaceURI());
        }
        return object;
    }

    public Attribute createAttribute(Element element, javax.xml.stream.events.Attribute attribute) {
        return this.factory.createAttribute(element, this.createQName(attribute.getName()), attribute.getValue());
    }

    public Namespace createNamespace(javax.xml.stream.events.Namespace namespace) {
        return this.factory.createNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
    }

    public CharacterData createCharacterData(Characters characters) {
        String string = characters.getData();
        if (characters.isCData()) {
            return this.factory.createCDATA(string);
        }
        return this.factory.createText(string);
    }

    public Comment createComment(javax.xml.stream.events.Comment comment) {
        return this.factory.createComment(comment.getText());
    }

    public Entity createEntity(EntityReference entityReference) {
        return this.factory.createEntity(entityReference.getName(), entityReference.getDeclaration().getReplacementText());
    }

    public ProcessingInstruction createProcessingInstruction(javax.xml.stream.events.ProcessingInstruction processingInstruction) {
        return this.factory.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
    }

    public QName createQName(javax.xml.namespace.QName qName) {
        return this.factory.createQName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
    }
}

