/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.util.XMLEventConsumer;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.io.STAXEventWriter$AttributeIterator;
import org.dom4j.io.STAXEventWriter$NamespaceIterator;

public class STAXEventWriter {
    private XMLEventConsumer consumer;
    private XMLEventFactory factory = XMLEventFactory.newInstance();
    private XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();

    public STAXEventWriter() {
    }

    public STAXEventWriter(File file) {
        this.consumer = this.outputFactory.createXMLEventWriter(new FileWriter(file));
    }

    public STAXEventWriter(Writer writer) {
        this.consumer = this.outputFactory.createXMLEventWriter(writer);
    }

    public STAXEventWriter(OutputStream outputStream) {
        this.consumer = this.outputFactory.createXMLEventWriter(outputStream);
    }

    public STAXEventWriter(XMLEventConsumer xMLEventConsumer) {
        this.consumer = xMLEventConsumer;
    }

    public XMLEventConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(XMLEventConsumer xMLEventConsumer) {
        this.consumer = xMLEventConsumer;
    }

    public XMLEventFactory getEventFactory() {
        return this.factory;
    }

    public void setEventFactory(XMLEventFactory xMLEventFactory) {
        this.factory = xMLEventFactory;
    }

    public void writeNode(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.writeElement((Element)node);
                return;
            }
            case 3: {
                this.writeText((Text)node);
                return;
            }
            case 2: {
                this.writeAttribute((Attribute)node);
                return;
            }
            case 13: {
                this.writeNamespace((Namespace)node);
                return;
            }
            case 8: {
                this.writeComment((Comment)node);
                return;
            }
            case 4: {
                this.writeCDATA((CDATA)node);
                return;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node);
                return;
            }
            case 5: {
                this.writeEntity((Entity)node);
                return;
            }
            case 9: {
                this.writeDocument((Document)node);
                return;
            }
            case 10: {
                this.writeDocumentType((DocumentType)node);
                return;
            }
        }
        throw new XMLStreamException("Unsupported DOM4J Node: " + node);
    }

    public void writeChildNodes(Branch branch) {
        int n2 = branch.nodeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = branch.node(i2);
            this.writeNode(node);
        }
    }

    public void writeElement(Element element) {
        this.consumer.add(this.createStartElement(element));
        this.writeChildNodes(element);
        this.consumer.add(this.createEndElement(element));
    }

    public StartElement createStartElement(Element object) {
        javax.xml.namespace.QName qName = this.createQName(object.getQName());
        STAXEventWriter$AttributeIterator sTAXEventWriter$AttributeIterator = new STAXEventWriter$AttributeIterator(this, object.attributeIterator());
        object = new STAXEventWriter$NamespaceIterator(this, object.declaredNamespaces().iterator());
        return this.factory.createStartElement(qName, sTAXEventWriter$AttributeIterator, (Iterator)object);
    }

    public EndElement createEndElement(Element object) {
        javax.xml.namespace.QName qName = this.createQName(object.getQName());
        object = new STAXEventWriter$NamespaceIterator(this, object.declaredNamespaces().iterator());
        return this.factory.createEndElement(qName, (Iterator)object);
    }

    public void writeAttribute(Attribute attribute) {
        this.consumer.add(this.createAttribute(attribute));
    }

    public javax.xml.stream.events.Attribute createAttribute(Attribute object) {
        javax.xml.namespace.QName qName = this.createQName(object.getQName());
        object = object.getValue();
        return this.factory.createAttribute(qName, (String)object);
    }

    public void writeNamespace(Namespace namespace) {
        this.consumer.add(this.createNamespace(namespace));
    }

    public javax.xml.stream.events.Namespace createNamespace(Namespace object) {
        String string = ((Namespace)object).getPrefix();
        object = ((Namespace)object).getURI();
        return this.factory.createNamespace(string, (String)object);
    }

    public void writeText(Text text) {
        this.consumer.add(this.createCharacters(text));
    }

    public Characters createCharacters(Text text) {
        return this.factory.createCharacters(text.getText());
    }

    public void writeCDATA(CDATA cDATA) {
        this.consumer.add(this.createCharacters(cDATA));
    }

    public Characters createCharacters(CDATA cDATA) {
        return this.factory.createCData(cDATA.getText());
    }

    public void writeComment(Comment comment) {
        this.consumer.add(this.createComment(comment));
    }

    public javax.xml.stream.events.Comment createComment(Comment comment) {
        return this.factory.createComment(comment.getText());
    }

    public void writeProcessingInstruction(ProcessingInstruction processingInstruction) {
        this.consumer.add(this.createProcessingInstruction(processingInstruction));
    }

    public javax.xml.stream.events.ProcessingInstruction createProcessingInstruction(ProcessingInstruction object) {
        String string = object.getTarget();
        object = object.getText();
        return this.factory.createProcessingInstruction(string, (String)object);
    }

    public void writeEntity(Entity entity) {
        this.consumer.add(this.createEntityReference(entity));
    }

    private EntityReference createEntityReference(Entity entity) {
        return this.factory.createEntityReference(entity.getName(), null);
    }

    public void writeDocumentType(DocumentType documentType) {
        this.consumer.add(this.createDTD(documentType));
    }

    public DTD createDTD(DocumentType documentType) {
        StringWriter stringWriter = new StringWriter();
        try {
            documentType.write(stringWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing DTD", iOException);
        }
        return this.factory.createDTD(stringWriter.toString());
    }

    public void writeDocument(Document document) {
        this.consumer.add(this.createStartDocument(document));
        this.writeChildNodes(document);
        this.consumer.add(this.createEndDocument(document));
    }

    public StartDocument createStartDocument(Document object) {
        if ((object = object.getXMLEncoding()) != null) {
            return this.factory.createStartDocument((String)object);
        }
        return this.factory.createStartDocument();
    }

    public EndDocument createEndDocument(Document document) {
        return this.factory.createEndDocument();
    }

    public javax.xml.namespace.QName createQName(QName qName) {
        return new javax.xml.namespace.QName(qName.getNamespaceURI(), qName.getName(), qName.getNamespacePrefix());
    }

    static /* synthetic */ XMLEventFactory access$000(STAXEventWriter sTAXEventWriter) {
        return sTAXEventWriter.factory;
    }
}

