/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.OutputFormat;
import org.dom4j.tree.NamespaceStack;
import org.dom4j.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl
implements LexicalHandler {
    private static final String PAD_TEXT = " ";
    protected static final String[] LEXICAL_HANDLER_NAMES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler"};
    protected static final OutputFormat DEFAULT_FORMAT = new OutputFormat();
    private boolean resolveEntityRefs = true;
    protected int lastOutputNodeType;
    private boolean lastElementClosed = false;
    protected boolean preserve = false;
    protected Writer writer;
    private NamespaceStack namespaceStack = new NamespaceStack();
    private OutputFormat format;
    private boolean escapeText = true;
    private int indentLevel = 0;
    private StringBuffer buffer = new StringBuffer();
    private boolean charsAdded = false;
    private char lastChar;
    private boolean autoFlush;
    private LexicalHandler lexicalHandler;
    private boolean showCommentsInDTDs;
    private boolean inDTD;
    private Map<String, String> namespacesMap;
    private int maximumAllowedCharacter;

    public XMLWriter(Writer writer) {
        this(writer, DEFAULT_FORMAT);
    }

    public XMLWriter(Writer writer, OutputFormat outputFormat) {
        this.writer = writer;
        this.format = outputFormat;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter() {
        this.format = DEFAULT_FORMAT;
        this.writer = new BufferedWriter(new OutputStreamWriter(System.out));
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputStream outputStream) {
        this.format = DEFAULT_FORMAT;
        this.writer = this.createWriter(outputStream, this.format.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputStream outputStream, OutputFormat outputFormat) {
        this.format = outputFormat;
        this.writer = this.createWriter(outputStream, outputFormat.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputFormat outputFormat) {
        this.format = outputFormat;
        this.writer = this.createWriter(System.out, outputFormat.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
        this.autoFlush = false;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.writer = this.createWriter(outputStream, this.format.getEncoding());
        this.autoFlush = true;
    }

    public boolean isEscapeText() {
        return this.escapeText;
    }

    public void setEscapeText(boolean bl) {
        this.escapeText = bl;
    }

    public void setIndentLevel(int n2) {
        this.indentLevel = n2;
    }

    public int getMaximumAllowedCharacter() {
        if (this.maximumAllowedCharacter == 0) {
            this.maximumAllowedCharacter = this.defaultMaximumAllowedCharacter();
        }
        return this.maximumAllowedCharacter;
    }

    public void setMaximumAllowedCharacter(int n2) {
        this.maximumAllowedCharacter = n2;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }

    public void println() {
        this.writer.write(this.format.getLineSeparator());
    }

    public void write(Attribute attribute) {
        this.writeAttribute(attribute);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Document document) {
        this.writeDeclaration();
        if (document.getDocType() != null) {
            this.indent();
            this.writeDocType(document.getDocType());
        }
        int n2 = document.nodeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = document.node(i2);
            this.writeNode(node);
        }
        this.writePrintln();
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Element element) {
        this.writeElement(element);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(CDATA cDATA) {
        this.writeCDATA(cDATA.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Comment comment) {
        this.writeComment(comment.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(DocumentType documentType) {
        this.writeDocType(documentType);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Entity entity) {
        this.writeEntity(entity);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Namespace namespace) {
        this.writeNamespace(namespace);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(ProcessingInstruction processingInstruction) {
        this.writeProcessingInstruction(processingInstruction);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(String string) {
        this.writeString(string);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Text text) {
        this.writeString(text.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Node node) {
        this.writeNode(node);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Object iterator) {
        if (iterator instanceof Node) {
            this.write((Node)((Object)iterator));
            return;
        }
        if (iterator instanceof String) {
            this.write((String)((Object)iterator));
            return;
        }
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                this.write(e2);
            }
            return;
        }
        if (iterator != null) {
            throw new IOException("Invalid object: " + iterator);
        }
    }

    public void writeOpen(Element element) {
        this.writer.write("<");
        this.writer.write(element.getQualifiedName());
        this.writeNamespaces(element);
        this.writeAttributes(element);
        this.writer.write(">");
    }

    public void writeClose(Element element) {
        this.writeClose(element.getQualifiedName());
    }

    @Override
    public void parse(InputSource inputSource) {
        this.installLexicalHandler();
        super.parse(inputSource);
    }

    @Override
    public void setProperty(String string, Object object) {
        String[] stringArray = LEXICAL_HANDLER_NAMES;
        int n2 = LEXICAL_HANDLER_NAMES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!string2.equals(string)) continue;
            this.setLexicalHandler((LexicalHandler)object);
            return;
        }
        super.setProperty(string, object);
    }

    @Override
    public Object getProperty(String string) {
        String[] stringArray = LEXICAL_HANDLER_NAMES;
        int n2 = LEXICAL_HANDLER_NAMES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!string2.equals(string)) continue;
            return this.getLexicalHandler();
        }
        return super.getProperty(string);
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        if (lexicalHandler == null) {
            throw new NullPointerException("Null lexical handler");
        }
        this.lexicalHandler = lexicalHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() {
        try {
            this.writeDeclaration();
            super.startDocument();
            return;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return;
        }
    }

    @Override
    public void endDocument() {
        super.endDocument();
        if (this.autoFlush) {
            try {
                this.flush();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        if (this.namespacesMap == null) {
            this.namespacesMap = new HashMap<String, String>();
        }
        this.namespacesMap.put(string, string2);
        super.startPrefixMapping(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) {
        super.endPrefixMapping(string);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        try {
            this.charsAdded = false;
            this.writePrintln();
            this.indent();
            this.writer.write("<");
            this.writer.write(string3);
            this.writeNamespaces();
            this.writeAttributes(attributes);
            this.writer.write(">");
            ++this.indentLevel;
            this.lastOutputNodeType = 1;
            this.lastElementClosed = false;
            super.startElement(string, string2, string3, attributes);
            return;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        try {
            this.charsAdded = false;
            --this.indentLevel;
            if (this.lastElementClosed) {
                this.writePrintln();
                this.indent();
            }
            this.writeClose(string3);
            this.lastOutputNodeType = 1;
            this.lastElementClosed = true;
            super.endElement(string, string2, string3);
            return;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return;
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        if (cArray == null || cArray.length == 0 || n3 <= 0) {
            return;
        }
        try {
            Object object = String.valueOf(cArray, n2, n3);
            if (this.escapeText) {
                object = this.escapeElementEntities((String)object);
            }
            if (this.format.isTrimText()) {
                if (this.lastOutputNodeType == 3 && !this.charsAdded) {
                    this.writer.write(32);
                } else if (this.charsAdded && Character.isWhitespace(this.lastChar)) {
                    this.writer.write(32);
                } else if (this.lastOutputNodeType == 1 && this.format.isPadText() && this.lastElementClosed && Character.isWhitespace(cArray[0])) {
                    this.writer.write(PAD_TEXT);
                }
                String string = "";
                object = new StringTokenizer((String)object);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.writer.write(string);
                    this.writer.write(((StringTokenizer)object).nextToken());
                    string = PAD_TEXT;
                }
            } else {
                this.writer.write((String)object);
            }
            this.charsAdded = true;
            this.lastChar = cArray[n2 + n3 - 1];
            this.lastOutputNodeType = 3;
            super.characters(cArray, n2, n3);
            return;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return;
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
        super.ignorableWhitespace(cArray, n2, n3);
    }

    @Override
    public void processingInstruction(String string, String string2) {
        try {
            this.indent();
            this.writer.write("<?");
            this.writer.write(string);
            this.writer.write(PAD_TEXT);
            this.writer.write(string2);
            this.writer.write("?>");
            this.writePrintln();
            this.lastOutputNodeType = 7;
            super.processingInstruction(string, string2);
            return;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return;
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) {
        super.notationDecl(string, string2, string3);
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        super.unparsedEntityDecl(string, string2, string3, string4);
    }

    @Override
    public void startDTD(String string, String string2, String string3) {
        this.inDTD = true;
        try {
            this.writeDocType(string, string2, string3);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(string, string2, string3);
        }
    }

    @Override
    public void endDTD() {
        this.inDTD = false;
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    public void startCDATA() {
        try {
            this.writer.write("<![CDATA[");
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() {
        try {
            this.writer.write("]]>");
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void startEntity(String string) {
        try {
            this.writeEntityRef(string);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(string);
        }
    }

    @Override
    public void endEntity(String string) {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(string);
        }
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) {
        if (this.showCommentsInDTDs || !this.inDTD) {
            try {
                this.charsAdded = false;
                this.writeComment(new String(cArray, n2, n3));
            }
            catch (IOException iOException) {
                this.handleException(iOException);
            }
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(cArray, n2, n3);
        }
    }

    protected void writeElement(Element element) {
        int n2 = element.nodeCount();
        String string = element.getQualifiedName();
        this.writePrintln();
        this.indent();
        this.writer.write("<");
        this.writer.write(string);
        int n3 = this.namespaceStack.size();
        Namespace namespace = element.getNamespace();
        if (this.isNamespaceDeclaration(namespace)) {
            this.namespaceStack.push(namespace);
            this.writeNamespace(namespace);
        }
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = element.node(i2);
            if (node instanceof Namespace) {
                if (!this.isNamespaceDeclaration((Namespace)(node = (Namespace)node))) continue;
                this.namespaceStack.push((Namespace)node);
                this.writeNamespace((Namespace)node);
                continue;
            }
            if (node instanceof Element) {
                bl = false;
                continue;
            }
            if (!(node instanceof Comment)) continue;
            bl = false;
        }
        this.writeAttributes(element);
        this.lastOutputNodeType = 1;
        if (n2 <= 0) {
            this.writeEmptyElementClose(string);
        } else {
            this.writer.write(">");
            if (bl) {
                this.writeElementContent(element);
            } else {
                ++this.indentLevel;
                this.writeElementContent(element);
                --this.indentLevel;
                this.writePrintln();
                this.indent();
            }
            this.writer.write("</");
            this.writer.write(string);
            this.writer.write(">");
        }
        while (this.namespaceStack.size() > n3) {
            this.namespaceStack.pop();
        }
        this.lastOutputNodeType = 1;
    }

    protected final boolean isElementSpacePreserved(Element node) {
        node = node.attribute("space");
        boolean bl = this.preserve;
        if (node != null) {
            bl = "xml".equals(node.getNamespacePrefix()) && "preserve".equals(node.getText());
        }
        return bl;
    }

    protected void writeElementContent(Element object) {
        boolean bl = this.format.isTrimText();
        boolean bl2 = this.preserve;
        if (bl) {
            this.preserve = this.isElementSpacePreserved((Element)object);
            boolean bl3 = bl = !this.preserve;
        }
        if (bl) {
            Node node = null;
            StringBuilder stringBuilder = null;
            boolean bl4 = true;
            for (Node node2 : object.content()) {
                if (node2 instanceof Text) {
                    if (node == null) {
                        node = (Text)node2;
                        continue;
                    }
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(node.getText());
                    }
                    stringBuilder.append(node2.getText());
                    continue;
                }
                if (!bl4 && this.format.isPadText() && (bl4 = stringBuilder != null ? StringUtils.startsWithWhitespace(stringBuilder) : (node != null ? StringUtils.startsWithWhitespace(node.getText()) : false))) {
                    this.writer.write(PAD_TEXT);
                }
                if (node != null) {
                    if (stringBuilder != null) {
                        this.writeString(stringBuilder.toString());
                        stringBuilder = null;
                    } else {
                        this.writeString(node.getText());
                    }
                    if (this.format.isPadText() && (bl4 = stringBuilder != null ? StringUtils.endsWithWhitespace(stringBuilder) : StringUtils.endsWithWhitespace(node.getText()))) {
                        this.writer.write(PAD_TEXT);
                    }
                    node = null;
                }
                bl4 = false;
                this.writeNode(node2);
            }
            if (node != null) {
                boolean bl5;
                if (!bl4 && this.format.isPadText() && (bl5 = stringBuilder != null ? StringUtils.startsWithWhitespace(stringBuilder) : StringUtils.startsWithWhitespace(node.getText()))) {
                    this.writer.write(PAD_TEXT);
                }
                if (stringBuilder != null) {
                    this.writeString(stringBuilder.toString());
                } else {
                    this.writeString(node.getText());
                }
            }
        } else {
            Node node = null;
            for (Node node3 : object.content()) {
                if (node3 instanceof Text) {
                    this.writeNode(node3);
                    node = node3;
                    continue;
                }
                if (node != null && this.format.isPadText() && StringUtils.endsWithWhitespace(node.getText())) {
                    this.writer.write(PAD_TEXT);
                }
                this.writeNode(node3);
                node = null;
            }
        }
        this.preserve = bl2;
    }

    protected void writeCDATA(String string) {
        this.writer.write("<![CDATA[");
        if (string != null) {
            this.writer.write(string);
        }
        this.writer.write("]]>");
        this.lastOutputNodeType = 4;
    }

    protected void writeDocType(DocumentType documentType) {
        if (documentType != null) {
            documentType.write(this.writer);
            this.writePrintln();
        }
    }

    protected void writeNamespace(Namespace namespace) {
        if (namespace != null) {
            this.writeNamespace(namespace.getPrefix(), namespace.getURI());
        }
    }

    protected void writeNamespaces() {
        if (this.namespacesMap != null) {
            for (Map.Entry<String, String> entry : this.namespacesMap.entrySet()) {
                String string = entry.getKey();
                String object = entry.getValue();
                this.writeNamespace(string, object);
            }
            this.namespacesMap = null;
        }
    }

    protected void writeNamespace(String string, String string2) {
        if (string != null && string.length() > 0) {
            this.writer.write(" xmlns:");
            this.writer.write(string);
            this.writer.write("=\"");
        } else {
            this.writer.write(" xmlns=\"");
        }
        this.writer.write(string2);
        this.writer.write("\"");
    }

    protected void writeNamespaces(Element object) {
        assert (object != null);
        for (Namespace namespace : object.declaredNamespaces()) {
            this.writeNamespace(namespace);
            this.namespaceStack.push(namespace);
        }
    }

    protected void writeProcessingInstruction(ProcessingInstruction processingInstruction) {
        this.writer.write("<?");
        this.writer.write(processingInstruction.getName());
        this.writer.write(PAD_TEXT);
        this.writer.write(processingInstruction.getText());
        this.writer.write("?>");
        this.writePrintln();
        this.lastOutputNodeType = 7;
    }

    protected void writeString(String object) {
        block5: {
            block6: {
                if (object == null || ((String)object).length() <= 0) break block5;
                if (this.escapeText) {
                    object = this.escapeElementEntities((String)object);
                }
                if (!this.format.isTrimText()) break block6;
                boolean bl = true;
                object = new StringTokenizer((String)object);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string;
                    block8: {
                        block7: {
                            string = ((StringTokenizer)object).nextToken();
                            if (!bl) break block7;
                            bl = false;
                            if (this.lastOutputNodeType != 3) break block8;
                        }
                        this.writer.write(PAD_TEXT);
                    }
                    this.writer.write(string);
                    this.lastOutputNodeType = 3;
                }
                return;
            }
            this.lastOutputNodeType = 3;
            this.writer.write((String)object);
        }
    }

    protected void writeNodeText(Node object) {
        if ((object = object.getText()) != null && ((String)object).length() > 0) {
            if (this.escapeText) {
                object = this.escapeElementEntities((String)object);
            }
            this.lastOutputNodeType = 3;
            this.writer.write((String)object);
        }
    }

    protected void writeNode(Node node) {
        short s2 = node.getNodeType();
        switch (s2) {
            case 1: {
                this.writeElement((Element)node);
                return;
            }
            case 2: {
                this.writeAttribute((Attribute)node);
                return;
            }
            case 3: {
                this.writeNodeText(node);
                return;
            }
            case 4: {
                this.writeCDATA(node.getText());
                return;
            }
            case 5: {
                this.writeEntity((Entity)node);
                return;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node);
                return;
            }
            case 8: {
                this.writeComment(node.getText());
                return;
            }
            case 9: {
                this.write((Document)node);
                return;
            }
            case 10: {
                this.writeDocType((DocumentType)node);
                return;
            }
            case 13: {
                return;
            }
        }
        throw new IOException("Invalid node type: " + node);
    }

    protected void installLexicalHandler() {
        XMLReader xMLReader = this.getParent();
        if (xMLReader == null) {
            throw new NullPointerException("No parent for filter");
        }
        String[] stringArray = LEXICAL_HANDLER_NAMES;
        int n2 = LEXICAL_HANDLER_NAMES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            try {
                xMLReader.setProperty(string, this);
                return;
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                continue;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
        }
    }

    protected void writeDocType(String string, String string2, String string3) {
        boolean bl = false;
        this.writer.write("<!DOCTYPE ");
        this.writer.write(string);
        if (string2 != null && !string2.equals("")) {
            this.writer.write(" PUBLIC \"");
            this.writer.write(string2);
            this.writer.write("\"");
            bl = true;
        }
        if (string3 != null && !string3.equals("")) {
            if (!bl) {
                this.writer.write(" SYSTEM");
            }
            this.writer.write(" \"");
            this.writer.write(string3);
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writePrintln();
    }

    protected void writeEntity(Entity entity) {
        if (!this.resolveEntityRefs()) {
            this.writeEntityRef(entity.getName());
            return;
        }
        this.writer.write(entity.getText());
    }

    protected void writeEntityRef(String string) {
        this.writer.write("&");
        this.writer.write(string);
        this.writer.write(";");
        this.lastOutputNodeType = 5;
    }

    protected void writeComment(String string) {
        if (this.format.isNewlines()) {
            this.println();
            this.indent();
        }
        this.writer.write("<!--");
        this.writer.write(string);
        this.writer.write("-->");
        this.lastOutputNodeType = 8;
    }

    protected void writeAttributes(Element element) {
        int n2 = element.attributeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            Object object = element.attribute(i2);
            Namespace namespace = object.getNamespace();
            if (namespace != null && namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE) {
                string = namespace.getPrefix();
                string = this.namespaceStack.getURI(string);
                if (!namespace.getURI().equals(string)) {
                    this.writeNamespace(namespace);
                    this.namespaceStack.push(namespace);
                }
            }
            if ((string = object.getName()).startsWith("xmlns:")) {
                if (this.namespaceStack.getNamespaceForPrefix(string = string.substring(6)) != null) continue;
                object = object.getValue();
                this.namespaceStack.push(string, (String)object);
                this.writeNamespace(string, (String)object);
                continue;
            }
            if (string.equals("xmlns")) {
                if (this.namespaceStack.getDefaultNamespace() != null) continue;
                string = object.getValue();
                this.namespaceStack.push(null, string);
                this.writeNamespace(null, string);
                continue;
            }
            char c2 = this.format.getAttributeQuoteCharacter();
            this.writer.write(PAD_TEXT);
            this.writer.write(object.getQualifiedName());
            this.writer.write("=");
            this.writer.write(c2);
            this.writeEscapeAttributeEntities(object.getValue());
            this.writer.write(c2);
        }
    }

    protected void writeAttribute(Attribute attribute) {
        this.writer.write(PAD_TEXT);
        this.writer.write(attribute.getQualifiedName());
        this.writer.write("=");
        char c2 = this.format.getAttributeQuoteCharacter();
        this.writer.write(c2);
        this.writeEscapeAttributeEntities(attribute.getValue());
        this.writer.write(c2);
        this.lastOutputNodeType = 2;
    }

    protected void writeAttributes(Attributes attributes) {
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeAttribute(attributes, i2);
        }
    }

    protected void writeAttribute(Attributes attributes, int n2) {
        char c2 = this.format.getAttributeQuoteCharacter();
        this.writer.write(PAD_TEXT);
        this.writer.write(attributes.getQName(n2));
        this.writer.write("=");
        this.writer.write(c2);
        this.writeEscapeAttributeEntities(attributes.getValue(n2));
        this.writer.write(c2);
    }

    protected void indent() {
        String string = this.format.getIndent();
        if (string != null && string.length() > 0) {
            for (int i2 = 0; i2 < this.indentLevel; ++i2) {
                this.writer.write(string);
            }
        }
    }

    protected void writePrintln() {
        if (this.format.isNewlines()) {
            this.writer.write(this.format.getLineSeparator());
        }
    }

    protected Writer createWriter(OutputStream outputStream, String string) {
        return new BufferedWriter(new OutputStreamWriter(outputStream, string));
    }

    protected void writeDeclaration() {
        String string = this.format.getEncoding();
        if (!this.format.isSuppressDeclaration()) {
            if (string.equals("UTF8")) {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"UTF-8\"");
                }
                this.writer.write("?>");
            } else {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"" + string + "\"");
                }
                this.writer.write("?>");
            }
            if (this.format.isNewLineAfterDeclaration()) {
                this.println();
            }
        }
    }

    protected void writeClose(String string) {
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(">");
    }

    protected void writeEmptyElementClose(String string) {
        if (!this.format.isExpandEmptyElements()) {
            this.writer.write("/>");
            return;
        }
        this.writer.write("></");
        this.writer.write(string);
        this.writer.write(">");
    }

    protected boolean isExpandEmptyElements() {
        return this.format.isExpandEmptyElements();
    }

    protected String escapeElementEntities(String string) {
        String string2;
        int n2;
        char[] cArray = null;
        int n3 = 0;
        int n4 = string.length();
        for (n2 = 0; n2 < n4; ++n2) {
            string2 = null;
            int n5 = string.codePointAt(n2);
            switch (n5) {
                case 60: {
                    string2 = "&lt;";
                    break;
                }
                case 62: {
                    string2 = "&gt;";
                    break;
                }
                case 38: {
                    string2 = "&amp;";
                    break;
                }
                case 9: 
                case 10: 
                case 13: {
                    if (!this.preserve) break;
                    string2 = String.valueOf((char)n5);
                    break;
                }
                default: {
                    if (n5 >= 32 && !this.shouldEncodeChar(n5)) break;
                    string2 = "&#" + n5 + ";";
                }
            }
            if (string2 != null) {
                if (cArray == null) {
                    cArray = string.toCharArray();
                }
                this.buffer.append(cArray, n3, n2 - n3);
                this.buffer.append(string2);
                n3 = n2 + 1;
                if (Character.isSupplementaryCodePoint(n5)) {
                    ++n3;
                }
            }
            if (!Character.isSupplementaryCodePoint(n5)) continue;
            ++n2;
        }
        if (n3 == 0) {
            return string;
        }
        if (n3 < n4) {
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            this.buffer.append(cArray, n3, n2 - n3);
        }
        string2 = this.buffer.toString();
        this.buffer.setLength(0);
        return string2;
    }

    protected void writeEscapeAttributeEntities(String string) {
        if (string != null) {
            string = this.escapeAttributeEntities(string);
            this.writer.write(string);
        }
    }

    protected String escapeAttributeEntities(String string) {
        String string2;
        int n2;
        char c2 = this.format.getAttributeQuoteCharacter();
        char[] cArray = null;
        int n3 = 0;
        int n4 = string.length();
        for (n2 = 0; n2 < n4; ++n2) {
            string2 = null;
            int n5 = string.codePointAt(n2);
            switch (n5) {
                case 60: {
                    string2 = "&lt;";
                    break;
                }
                case 62: {
                    string2 = "&gt;";
                    break;
                }
                case 39: {
                    if (c2 != '\'') break;
                    string2 = "&apos;";
                    break;
                }
                case 34: {
                    if (c2 != '\"') break;
                    string2 = "&quot;";
                    break;
                }
                case 38: {
                    string2 = "&amp;";
                    break;
                }
                case 9: 
                case 10: 
                case 13: {
                    break;
                }
                default: {
                    if (n5 >= 32 && !this.shouldEncodeChar(n5)) break;
                    string2 = "&#" + n5 + ";";
                }
            }
            if (string2 != null) {
                if (cArray == null) {
                    cArray = string.toCharArray();
                }
                this.buffer.append(cArray, n3, n2 - n3);
                this.buffer.append(string2);
                n3 = n2 + 1;
                if (Character.isSupplementaryCodePoint(n5)) {
                    ++n3;
                }
            }
            if (!Character.isSupplementaryCodePoint(n5)) continue;
            ++n2;
        }
        if (n3 == 0) {
            return string;
        }
        if (n3 < n4) {
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            this.buffer.append(cArray, n3, n2 - n3);
        }
        string2 = this.buffer.toString();
        this.buffer.setLength(0);
        return string2;
    }

    protected boolean shouldEncodeChar(int n2) {
        int n3 = this.getMaximumAllowedCharacter();
        return n3 > 0 && n2 > n3;
    }

    protected int defaultMaximumAllowedCharacter() {
        String string = this.format.getEncoding();
        if (string != null && string.equals("US-ASCII")) {
            return 127;
        }
        return -1;
    }

    protected boolean isNamespaceDeclaration(Namespace namespace) {
        String string;
        return namespace != null && namespace != Namespace.XML_NAMESPACE && (string = namespace.getURI()) != null && !this.namespaceStack.contains(namespace);
    }

    protected void handleException(IOException iOException) {
        throw new SAXException(iOException);
    }

    protected OutputFormat getOutputFormat() {
        return this.format;
    }

    public boolean resolveEntityRefs() {
        return this.resolveEntityRefs;
    }

    public void setResolveEntityRefs(boolean bl) {
        this.resolveEntityRefs = bl;
    }
}

