/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.DispatchHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class XPP3Reader {
    private DocumentFactory factory;
    private XmlPullParser xppParser;
    private XmlPullParserFactory xppFactory;
    private DispatchHandler dispatchHandler;

    public XPP3Reader() {
    }

    public XPP3Reader(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public Document read(File file) {
        String string = file.getAbsolutePath();
        return this.read(new BufferedReader(new FileReader(file)), string);
    }

    public Document read(URL uRL) {
        String string = uRL.toExternalForm();
        XPP3Reader xPP3Reader = this;
        return xPP3Reader.read(xPP3Reader.createReader(uRL.openStream()), string);
    }

    public Document read(String string) {
        if (string.indexOf(58) >= 0) {
            return this.read(new URL(string));
        }
        return this.read(new File(string));
    }

    public Document read(InputStream inputStream) {
        XPP3Reader xPP3Reader = this;
        return xPP3Reader.read(xPP3Reader.createReader(inputStream));
    }

    public Document read(Reader reader) {
        this.getXPPParser().setInput(reader);
        return this.parseDocument();
    }

    public Document read(char[] cArray) {
        this.getXPPParser().setInput(new CharArrayReader(cArray));
        return this.parseDocument();
    }

    public Document read(InputStream inputStream, String string) {
        XPP3Reader xPP3Reader = this;
        return xPP3Reader.read(xPP3Reader.createReader(inputStream), string);
    }

    public Document read(Reader object, String string) {
        object = this.read((Reader)object);
        object.setName(string);
        return object;
    }

    public XmlPullParser getXPPParser() {
        if (this.xppParser == null) {
            this.xppParser = this.getXPPFactory().newPullParser();
        }
        return this.xppParser;
    }

    public XmlPullParserFactory getXPPFactory() {
        if (this.xppFactory == null) {
            this.xppFactory = XmlPullParserFactory.newInstance();
        }
        this.xppFactory.setNamespaceAware(true);
        return this.xppFactory;
    }

    public void setXPPFactory(XmlPullParserFactory xmlPullParserFactory) {
        this.xppFactory = xmlPullParserFactory;
    }

    public DocumentFactory getDocumentFactory() {
        if (this.factory == null) {
            this.factory = DocumentFactory.getInstance();
        }
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public void addHandler(String string, ElementHandler elementHandler) {
        this.getDispatchHandler().addHandler(string, elementHandler);
    }

    public void removeHandler(String string) {
        this.getDispatchHandler().removeHandler(string);
    }

    public void setDefaultHandler(ElementHandler elementHandler) {
        this.getDispatchHandler().setDefaultHandler(elementHandler);
    }

    protected Document parseDocument() {
        DocumentFactory documentFactory = this.getDocumentFactory();
        Document document = documentFactory.createDocument();
        Node node = null;
        XmlPullParser xmlPullParser = this.getXPPParser();
        xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        while (true) {
            int n2 = xmlPullParser.nextToken();
            switch (n2) {
                case 8: {
                    String string = xmlPullParser.getText();
                    int n3 = string.indexOf(" ");
                    if (n3 >= 0) {
                        String string2 = string.substring(0, n3);
                        string = string.substring(n3 + 1);
                        document.addProcessingInstruction(string2, string);
                        break;
                    }
                    document.addProcessingInstruction(string, "");
                    break;
                }
                case 9: {
                    if (node != null) {
                        node.addComment(xmlPullParser.getText());
                        break;
                    }
                    document.addComment(xmlPullParser.getText());
                    break;
                }
                case 5: {
                    if (node != null) {
                        node.addCDATA(xmlPullParser.getText());
                        break;
                    }
                    String string = "Cannot have text content outside of the root document";
                    throw new DocumentException(string);
                }
                case 6: {
                    break;
                }
                case 1: {
                    return document;
                }
                case 2: {
                    QName qName = xmlPullParser.getPrefix() == null ? documentFactory.createQName(xmlPullParser.getName(), xmlPullParser.getNamespace()) : documentFactory.createQName(xmlPullParser.getName(), xmlPullParser.getPrefix(), xmlPullParser.getNamespace());
                    Element element = documentFactory.createElement(qName);
                    XmlPullParser xmlPullParser2 = xmlPullParser;
                    int n4 = xmlPullParser2.getNamespaceCount(xmlPullParser2.getDepth() - 1);
                    XmlPullParser xmlPullParser3 = xmlPullParser;
                    int n5 = xmlPullParser3.getNamespaceCount(xmlPullParser3.getDepth());
                    while (n4 < n5) {
                        if (xmlPullParser.getNamespacePrefix(n4) != null) {
                            element.addNamespace(xmlPullParser.getNamespacePrefix(n4), xmlPullParser.getNamespaceUri(n4));
                        }
                        ++n4;
                    }
                    for (n4 = 0; n4 < xmlPullParser.getAttributeCount(); ++n4) {
                        QName qName2 = xmlPullParser.getAttributePrefix(n4) == null ? documentFactory.createQName(xmlPullParser.getAttributeName(n4)) : documentFactory.createQName(xmlPullParser.getAttributeName(n4), xmlPullParser.getAttributePrefix(n4), xmlPullParser.getAttributeNamespace(n4));
                        element.addAttribute(qName2, xmlPullParser.getAttributeValue(n4));
                    }
                    if (node != null) {
                        node.add(element);
                    } else {
                        document.add(element);
                    }
                    node = element;
                    break;
                }
                case 3: {
                    if (node == null) break;
                    node = node.getParent();
                    break;
                }
                case 4: {
                    String string = xmlPullParser.getText();
                    if (node != null) {
                        node.addText(string);
                        break;
                    }
                    String string3 = "Cannot have text content outside of the root document";
                    throw new DocumentException(string3);
                }
            }
        }
    }

    protected DispatchHandler getDispatchHandler() {
        if (this.dispatchHandler == null) {
            this.dispatchHandler = new DispatchHandler();
        }
        return this.dispatchHandler;
    }

    protected void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.dispatchHandler = dispatchHandler;
    }

    protected Reader createReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream));
    }
}

