/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Node;
import org.dom4j.io.DispatchHandler;
import org.dom4j.xpp.ProxyXmlStartTag;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlPullParser;
import org.gjt.xpp.XmlPullParserFactory;

public class XPPReader {
    private DocumentFactory factory;
    private XmlPullParser xppParser;
    private XmlPullParserFactory xppFactory;
    private DispatchHandler dispatchHandler;

    public XPPReader() {
    }

    public XPPReader(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public Document read(File file) {
        String string = file.getAbsolutePath();
        return this.read(new BufferedReader(new FileReader(file)), string);
    }

    public Document read(URL uRL) {
        String string = uRL.toExternalForm();
        XPPReader xPPReader = this;
        return xPPReader.read(xPPReader.createReader(uRL.openStream()), string);
    }

    public Document read(String string) {
        if (string.indexOf(58) >= 0) {
            return this.read(new URL(string));
        }
        return this.read(new File(string));
    }

    public Document read(InputStream inputStream) {
        XPPReader xPPReader = this;
        return xPPReader.read(xPPReader.createReader(inputStream));
    }

    public Document read(Reader reader) {
        this.getXPPParser().setInput(reader);
        return this.parseDocument();
    }

    public Document read(char[] cArray) {
        this.getXPPParser().setInput(cArray);
        return this.parseDocument();
    }

    public Document read(InputStream inputStream, String string) {
        XPPReader xPPReader = this;
        return xPPReader.read(xPPReader.createReader(inputStream), string);
    }

    public Document read(Reader object, String string) {
        object = this.read((Reader)object);
        object.setName(string);
        return object;
    }

    public XmlPullParser getXPPParser() {
        if (this.xppParser == null) {
            this.xppParser = this.getXPPFactory().newPullParser();
        }
        return this.xppParser;
    }

    public XmlPullParserFactory getXPPFactory() {
        if (this.xppFactory == null) {
            this.xppFactory = XmlPullParserFactory.newInstance();
        }
        return this.xppFactory;
    }

    public void setXPPFactory(XmlPullParserFactory xmlPullParserFactory) {
        this.xppFactory = xmlPullParserFactory;
    }

    public DocumentFactory getDocumentFactory() {
        if (this.factory == null) {
            this.factory = DocumentFactory.getInstance();
        }
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public void addHandler(String string, ElementHandler elementHandler) {
        this.getDispatchHandler().addHandler(string, elementHandler);
    }

    public void removeHandler(String string) {
        this.getDispatchHandler().removeHandler(string);
    }

    public void setDefaultHandler(ElementHandler elementHandler) {
        this.getDispatchHandler().setDefaultHandler(elementHandler);
    }

    protected Document parseDocument() {
        byte by;
        Object object = this.getDocumentFactory().createDocument();
        Node node = null;
        XmlPullParser xmlPullParser = this.getXPPParser();
        xmlPullParser.setNamespaceAware(true);
        ProxyXmlStartTag proxyXmlStartTag = new ProxyXmlStartTag();
        XmlEndTag xmlEndTag = this.xppFactory.newEndTag();
        block6: while (true) {
            by = xmlPullParser.next();
            switch (by) {
                case 1: {
                    return object;
                }
                case 2: {
                    xmlPullParser.readStartTag(proxyXmlStartTag);
                    Element element = proxyXmlStartTag.getElement();
                    if (node != null) {
                        node.add(element);
                    } else {
                        object.add(element);
                    }
                    node = element;
                    continue block6;
                }
                case 3: {
                    xmlPullParser.readEndTag(xmlEndTag);
                    if (node == null) continue block6;
                    node = node.getParent();
                    continue block6;
                }
                case 4: {
                    String string = xmlPullParser.readContent();
                    if (node != null) {
                        node.addText(string);
                        continue block6;
                    }
                    object = "Cannot have text content outside of the root document";
                    throw new DocumentException((String)object);
                }
            }
            break;
        }
        throw new DocumentException("Error: unknown type: " + by);
    }

    protected DispatchHandler getDispatchHandler() {
        if (this.dispatchHandler == null) {
            this.dispatchHandler = new DispatchHandler();
        }
        return this.dispatchHandler;
    }

    protected void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.dispatchHandler = dispatchHandler;
    }

    protected Reader createReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream));
    }
}

