/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.jaxb;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;

abstract class JAXBSupport {
    private String contextPath;
    private ClassLoader classloader;
    private JAXBContext jaxbContext;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public JAXBSupport(String string) {
        this.contextPath = string;
    }

    public JAXBSupport(String string, ClassLoader classLoader) {
        this.contextPath = string;
        this.classloader = classLoader;
    }

    protected Element marshal(javax.xml.bind.Element element) {
        DOMDocument dOMDocument = new DOMDocument();
        this.getMarshaller().marshal((Object)element, dOMDocument);
        return dOMDocument.getRootElement();
    }

    protected javax.xml.bind.Element unmarshal(Element object) {
        object = new StreamSource(new StringReader(object.asXML()));
        return (javax.xml.bind.Element)this.getUnmarshaller().unmarshal((Source)object);
    }

    private Marshaller getMarshaller() {
        if (this.marshaller == null) {
            this.marshaller = this.getContext().createMarshaller();
        }
        return this.marshaller;
    }

    private Unmarshaller getUnmarshaller() {
        if (this.unmarshaller == null) {
            this.unmarshaller = this.getContext().createUnmarshaller();
        }
        return this.unmarshaller;
    }

    private JAXBContext getContext() {
        if (this.jaxbContext == null) {
            this.jaxbContext = this.classloader == null ? JAXBContext.newInstance(this.contextPath) : JAXBContext.newInstance(this.contextPath, this.classloader);
        }
        return this.jaxbContext;
    }
}

