/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.rule.Rule;
import org.dom4j.rule.RuleSet;

public class Mode {
    private RuleSet[] ruleSets = new RuleSet[14];
    private Map<String, RuleSet> elementNameRuleSets;
    private Map<String, RuleSet> attributeNameRuleSets;

    public void fireRule(Node node) {
        Object object;
        if (node != null && (object = this.getMatchingRule(node)) != null && (object = ((Rule)object).getAction()) != null) {
            object.run(node);
        }
    }

    public void applyTemplates(Element element) {
        Node node;
        int n2;
        int n3 = element.attributeCount();
        for (n2 = 0; n2 < n3; ++n2) {
            node = element.attribute(n2);
            this.fireRule(node);
        }
        n3 = element.nodeCount();
        for (n2 = 0; n2 < n3; ++n2) {
            node = element.node(n2);
            this.fireRule(node);
        }
    }

    public void applyTemplates(Document document) {
        int n2 = document.nodeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = document.node(i2);
            this.fireRule(node);
        }
    }

    public void addRule(Rule rule) {
        short s2 = rule.getMatchType();
        String string = rule.getMatchesNodeName();
        if (string != null) {
            if (s2 == 1) {
                this.elementNameRuleSets = this.addToNameMap(this.elementNameRuleSets, string, rule);
            } else if (s2 == 2) {
                this.attributeNameRuleSets = this.addToNameMap(this.attributeNameRuleSets, string, rule);
            }
        }
        if (s2 >= 14) {
            s2 = 0;
        }
        if (s2 == 0) {
            int n2 = this.ruleSets.length;
            for (int i2 = 1; i2 < n2; ++i2) {
                RuleSet ruleSet = this.ruleSets[i2];
                if (ruleSet == null) continue;
                ruleSet.addRule(rule);
            }
        }
        this.getRuleSet(s2).addRule(rule);
    }

    public void removeRule(Rule rule) {
        short s2 = rule.getMatchType();
        String string = rule.getMatchesNodeName();
        if (string != null) {
            if (s2 == 1) {
                Mode mode = this;
                mode.removeFromNameMap(mode.elementNameRuleSets, string, rule);
            } else if (s2 == 2) {
                Mode mode = this;
                mode.removeFromNameMap(mode.attributeNameRuleSets, string, rule);
            }
        }
        if (s2 >= 14) {
            s2 = 0;
        }
        this.getRuleSet(s2).removeRule(rule);
        if (s2 != 0) {
            this.getRuleSet(0).removeRule(rule);
        }
    }

    public Rule getMatchingRule(Node node) {
        Object object;
        RuleSet ruleSet;
        short s2 = node.getNodeType();
        if (s2 == 1 ? this.elementNameRuleSets != null && (ruleSet = this.elementNameRuleSets.get(object = node.getName())) != null && (object = ruleSet.getMatchingRule(node)) != null : s2 == 2 && this.attributeNameRuleSets != null && (ruleSet = this.attributeNameRuleSets.get(object = node.getName())) != null && (object = ruleSet.getMatchingRule(node)) != null) {
            return object;
        }
        if (s2 < 0 || s2 >= this.ruleSets.length) {
            s2 = 0;
        }
        object = null;
        ruleSet = this.ruleSets[s2];
        if (ruleSet != null) {
            object = ruleSet.getMatchingRule(node);
        }
        if (object == null && s2 != 0 && (ruleSet = this.ruleSets[0]) != null) {
            object = ruleSet.getMatchingRule(node);
        }
        return object;
    }

    protected RuleSet getRuleSet(int n2) {
        RuleSet ruleSet = this.ruleSets[n2];
        if (ruleSet == null) {
            RuleSet ruleSet2;
            this.ruleSets[n2] = ruleSet = new RuleSet();
            if (n2 != 0 && (ruleSet2 = this.ruleSets[0]) != null) {
                ruleSet.addAll(ruleSet2);
            }
        }
        return ruleSet;
    }

    protected Map<String, RuleSet> addToNameMap(Map<String, RuleSet> map, String string, Rule rule) {
        RuleSet ruleSet;
        if (map == null) {
            map = new HashMap<String, RuleSet>();
        }
        if ((ruleSet = map.get(string)) == null) {
            ruleSet = new RuleSet();
            map.put(string, ruleSet);
        }
        ruleSet.addRule(rule);
        return map;
    }

    protected void removeFromNameMap(Map<String, RuleSet> object, String string, Rule rule) {
        if (object != null && (object = object.get(string)) != null) {
            ((RuleSet)object).removeRule(rule);
        }
    }
}

