/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import org.dom4j.Node;
import org.dom4j.rule.Action;
import org.dom4j.rule.Pattern;

public class Rule
implements Comparable<Rule> {
    private String mode;
    private int importPrecedence;
    private double priority;
    private int appearenceCount;
    private Pattern pattern;
    private Action action;

    public Rule() {
        this.priority = 0.5;
    }

    public Rule(Pattern pattern) {
        this.pattern = pattern;
        this.priority = pattern.getPriority();
    }

    public Rule(Pattern pattern, Action action) {
        this(pattern);
        this.action = action;
    }

    public Rule(Rule rule, Pattern pattern) {
        this.mode = rule.mode;
        this.importPrecedence = rule.importPrecedence;
        this.priority = rule.priority;
        this.appearenceCount = rule.appearenceCount;
        this.action = rule.action;
        this.pattern = pattern;
    }

    public boolean equals(Object object) {
        if (object instanceof Rule) {
            return this.compareTo((Rule)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.importPrecedence + this.appearenceCount;
    }

    @Override
    public int compareTo(Rule rule) {
        int n2 = Rule.compareInt(this.importPrecedence, rule.importPrecedence);
        if (n2 == 0 && (n2 = Double.compare(this.priority, rule.priority)) == 0) {
            n2 = Rule.compareInt(this.appearenceCount, rule.appearenceCount);
        }
        return n2;
    }

    public String toString() {
        return super.toString() + "[ pattern: " + this.getPattern() + " action: " + this.getAction() + " ]";
    }

    public final boolean matches(Node node) {
        return this.pattern.matches(node);
    }

    public Rule[] getUnionRules() {
        Pattern[] patternArray = this.pattern.getUnionPatterns();
        if (patternArray == null) {
            return null;
        }
        int n2 = patternArray.length;
        Rule[] ruleArray = new Rule[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ruleArray[i2] = new Rule(this, patternArray[i2]);
        }
        return ruleArray;
    }

    public final short getMatchType() {
        return this.pattern.getMatchType();
    }

    public final String getMatchesNodeName() {
        return this.pattern.getMatchesNodeName();
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public int getImportPrecedence() {
        return this.importPrecedence;
    }

    public void setImportPrecedence(int n2) {
        this.importPrecedence = n2;
    }

    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double d2) {
        this.priority = d2;
    }

    public int getAppearenceCount() {
        return this.appearenceCount;
    }

    public void setAppearenceCount(int n2) {
        this.appearenceCount = n2;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    private static int compareInt(int n2, int n3) {
        if (n2 < n3) {
            return -1;
        }
        if (n2 == n3) {
            return 0;
        }
        return 1;
    }
}

