/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.HashMap;
import org.dom4j.Node;
import org.dom4j.rule.Action;
import org.dom4j.rule.Mode;
import org.dom4j.rule.Pattern;
import org.dom4j.rule.Rule;
import org.dom4j.rule.RuleManager$1;
import org.dom4j.rule.pattern.NodeTypePattern;

public class RuleManager {
    private HashMap<String, Mode> modes = new HashMap();
    private int appearenceCount;
    private Action valueOfAction;

    public Mode getMode(String string) {
        Mode mode = this.modes.get(string);
        if (mode == null) {
            mode = this.createMode();
            this.modes.put(string, mode);
        }
        return mode;
    }

    public void addRule(Rule ruleArray) {
        ruleArray.setAppearenceCount(++this.appearenceCount);
        Mode mode = this.getMode(ruleArray.getMode());
        Rule[] ruleArray2 = ruleArray.getUnionRules();
        if (ruleArray2 != null) {
            ruleArray = ruleArray2;
            int n2 = ruleArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Rule rule = ruleArray[i2];
                mode.addRule(rule);
            }
            return;
        }
        mode.addRule((Rule)ruleArray);
    }

    public void removeRule(Rule ruleArray) {
        Mode mode = this.getMode(ruleArray.getMode());
        Rule[] ruleArray2 = ruleArray.getUnionRules();
        if (ruleArray2 != null) {
            ruleArray = ruleArray2;
            int n2 = ruleArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Rule rule = ruleArray[i2];
                mode.removeRule(rule);
            }
            return;
        }
        mode.removeRule((Rule)ruleArray);
    }

    public Rule getMatchingRule(String object, Node node) {
        if ((object = this.modes.get(object)) != null) {
            return ((Mode)object).getMatchingRule(node);
        }
        System.out.println("Warning: No Mode for mode: " + object);
        return null;
    }

    public void clear() {
        this.modes.clear();
        this.appearenceCount = 0;
    }

    public Action getValueOfAction() {
        return this.valueOfAction;
    }

    public void setValueOfAction(Action action) {
        this.valueOfAction = action;
    }

    protected Mode createMode() {
        Mode mode = new Mode();
        this.addDefaultRules(mode);
        return mode;
    }

    protected void addDefaultRules(Mode mode) {
        RuleManager$1 ruleManager$1 = new RuleManager$1(this, mode);
        Action action = this.getValueOfAction();
        this.addDefaultRule(mode, NodeTypePattern.ANY_DOCUMENT, ruleManager$1);
        this.addDefaultRule(mode, NodeTypePattern.ANY_ELEMENT, ruleManager$1);
        if (action != null) {
            this.addDefaultRule(mode, NodeTypePattern.ANY_ATTRIBUTE, action);
            this.addDefaultRule(mode, NodeTypePattern.ANY_TEXT, action);
        }
    }

    protected void addDefaultRule(Mode mode, Pattern object, Action action) {
        object = this.createDefaultRule((Pattern)object, action);
        mode.addRule((Rule)object);
    }

    protected Rule createDefaultRule(Pattern object, Action action) {
        object = new Rule((Pattern)object, action);
        ((Rule)object).setImportPrecedence(-1);
        return object;
    }
}

