/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.ArrayList;
import java.util.Collections;
import org.dom4j.Node;
import org.dom4j.rule.Rule;

public class RuleSet {
    private ArrayList<Rule> rules = new ArrayList();
    private Rule[] ruleArray;

    public String toString() {
        return super.toString() + " [RuleSet: " + this.rules + " ]";
    }

    public Rule getMatchingRule(Node node) {
        Rule[] ruleArray = this.getRuleArray();
        for (int i2 = ruleArray.length - 1; i2 >= 0; --i2) {
            Rule rule = ruleArray[i2];
            if (!rule.matches(node)) continue;
            return rule;
        }
        return null;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
        this.ruleArray = null;
    }

    public void removeRule(Rule rule) {
        this.rules.remove(rule);
        this.ruleArray = null;
    }

    public void addAll(RuleSet ruleSet) {
        this.rules.addAll(ruleSet.rules);
        this.ruleArray = null;
    }

    protected Rule[] getRuleArray() {
        if (this.ruleArray == null) {
            Collections.sort(this.rules);
            int n2 = this.rules.size();
            this.ruleArray = new Rule[n2];
            this.rules.toArray(this.ruleArray);
        }
        return this.ruleArray;
    }
}

