/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.swing;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.dom4j.Branch;
import org.dom4j.CharacterData;
import org.dom4j.Node;
import org.dom4j.swing.BranchTreeNode$1;
import org.dom4j.swing.LeafTreeNode;

public class BranchTreeNode
extends LeafTreeNode {
    protected List<TreeNode> children;

    public BranchTreeNode() {
    }

    public BranchTreeNode(Branch branch) {
        super(branch);
    }

    public BranchTreeNode(TreeNode treeNode, Branch branch) {
        super(treeNode, branch);
    }

    public Enumeration<TreeNode> children() {
        return new BranchTreeNode$1(this);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int n2) {
        return this.getChildList().get(n2);
    }

    @Override
    public int getChildCount() {
        return this.getChildList().size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.getChildList().indexOf(treeNode);
    }

    @Override
    public boolean isLeaf() {
        return this.getXmlBranch().nodeCount() <= 0;
    }

    @Override
    public String toString() {
        return this.xmlNode.getName();
    }

    protected List<TreeNode> getChildList() {
        if (this.children == null) {
            this.children = this.createChildList();
        }
        return this.children;
    }

    protected List<TreeNode> createChildList() {
        Branch branch = this.getXmlBranch();
        int n2 = branch.nodeCount();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            Node node = branch.node(i2);
            if (node instanceof CharacterData && ((string = node.getText()) == null || (string = string.trim()).length() <= 0)) continue;
            arrayList.add(this.createChildTreeNode(node));
        }
        return arrayList;
    }

    protected TreeNode createChildTreeNode(Node node) {
        if (node instanceof Branch) {
            return new BranchTreeNode((TreeNode)this, (Branch)node);
        }
        return new LeafTreeNode(this, node);
    }

    protected Branch getXmlBranch() {
        return (Branch)this.xmlNode;
    }
}

