/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.swing;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.swing.XMLTableDefinition;

public class XMLTableModel
extends AbstractTableModel {
    private XMLTableDefinition definition;
    private Object source;
    private List<Node> rows;

    public XMLTableModel(Element element, Object object) {
        this(XMLTableDefinition.load(element), object);
    }

    public XMLTableModel(Document document, Object object) {
        this(XMLTableDefinition.load(document), object);
    }

    public XMLTableModel(XMLTableDefinition xMLTableDefinition, Object object) {
        this.definition = xMLTableDefinition;
        this.source = object;
    }

    public Object getRowValue(int n2) {
        return this.getRows().get(n2);
    }

    public List<Node> getRows() {
        if (this.rows == null) {
            this.rows = this.definition.getRowXPath().selectNodes(this.source);
        }
        return this.rows;
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        return this.definition.getColumnClass(n2);
    }

    @Override
    public int getColumnCount() {
        return this.definition.getColumnCount();
    }

    @Override
    public String getColumnName(int n2) {
        XPath xPath = this.definition.getColumnNameXPath(n2);
        if (xPath != null) {
            System.out.println("Evaluating column xpath: " + xPath + " value: " + xPath.valueOf(this.source));
            return xPath.valueOf(this.source);
        }
        return this.definition.getColumnName(n2);
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        try {
            Object object = this.getRowValue(n2);
            return this.definition.getValueAt(object, n3);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    @Override
    public int getRowCount() {
        return this.getRows().size();
    }

    public XMLTableDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(XMLTableDefinition xMLTableDefinition) {
        this.definition = xMLTableDefinition;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object object) {
        this.source = object;
        this.rows = null;
    }

    protected void handleException(Exception exception) {
        System.out.println("Caught: " + exception);
    }
}

