/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.Writer;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.Visitor;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.DefaultAttribute;

public abstract class AbstractAttribute
extends AbstractNode
implements Attribute {
    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public void setNamespace(Namespace object) {
        object = "This Attribute is read only and cannot be changed";
        throw new UnsupportedOperationException((String)object);
    }

    @Override
    public String getText() {
        return this.getValue();
    }

    @Override
    public void setText(String string) {
        this.setValue(string);
    }

    @Override
    public void setValue(String string) {
        string = "This Attribute is read only and cannot be changed";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public Object getData() {
        return this.getValue();
    }

    @Override
    public void setData(Object object) {
        this.setValue(object == null ? null : object.toString());
    }

    public String toString() {
        return super.toString() + " [Attribute: name " + this.getQualifiedName() + " value \"" + this.getValue() + "\"]";
    }

    @Override
    public String asXML() {
        return this.getQualifiedName() + "=\"" + this.getValue() + "\"";
    }

    @Override
    public void write(Writer writer) {
        writer.write(this.getQualifiedName());
        writer.write("=\"");
        writer.write(this.getValue());
        writer.write("\"");
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Namespace getNamespace() {
        return this.getQName().getNamespace();
    }

    @Override
    public String getName() {
        return this.getQName().getName();
    }

    @Override
    public String getNamespacePrefix() {
        return this.getQName().getNamespacePrefix();
    }

    @Override
    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    @Override
    public String getQualifiedName() {
        return this.getQName().getQualifiedName();
    }

    @Override
    public String getPath(Element object) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = this.getParent();
        if (object2 != null && object2 != object) {
            stringBuilder.append(object2.getPath((Element)object));
            stringBuilder.append("/");
        }
        stringBuilder.append("@");
        object = this.getNamespaceURI();
        object2 = this.getNamespacePrefix();
        if (object == null || ((String)object).length() == 0 || object2 == null || ((String)object2).length() == 0) {
            stringBuilder.append(((AbstractNode)this).getName());
        } else {
            stringBuilder.append(this.getQualifiedName());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getUniquePath(Element object) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = this.getParent();
        if (object2 != null && object2 != object) {
            stringBuilder.append(object2.getUniquePath((Element)object));
            stringBuilder.append("/");
        }
        stringBuilder.append("@");
        object = this.getNamespaceURI();
        object2 = this.getNamespacePrefix();
        if (object == null || ((String)object).length() == 0 || object2 == null || ((String)object2).length() == 0) {
            stringBuilder.append(((AbstractNode)this).getName());
        } else {
            stringBuilder.append(this.getQualifiedName());
        }
        return stringBuilder.toString();
    }

    @Override
    protected Node createXPathResult(Element element) {
        return new DefaultAttribute(element, this.getQName(), this.getValue());
    }
}

