/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;

public abstract class AbstractBranch
extends AbstractNode
implements Branch {
    protected static final int DEFAULT_CONTENT_LIST_SIZE = 5;

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean hasContent() {
        return this.nodeCount() > 0;
    }

    @Override
    public List<Node> content() {
        List<Node> list = this.contentList();
        return new ContentListFacade<Node>(this, list);
    }

    @Override
    public String getText() {
        int n2;
        List<Node> list = this.contentList();
        if (list != null && (n2 = list.size()) > 0) {
            Object object = list.get(0);
            object = this.getContentAsText(object);
            if (n2 == 1) {
                return object;
            }
            object = new StringBuilder((String)object);
            for (int i2 = 1; i2 < n2; ++i2) {
                Node node = list.get(i2);
                ((StringBuilder)object).append(this.getContentAsText(node));
            }
            return ((StringBuilder)object).toString();
        }
        return "";
    }

    protected String getContentAsText(Object object) {
        if (object instanceof Node) {
            object = (Node)object;
            switch (object.getNodeType()) {
                case 3: 
                case 4: 
                case 5: {
                    return object.getText();
                }
            }
        } else if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    protected String getContentAsStringValue(Object object) {
        if (object instanceof Node) {
            object = (Node)object;
            switch (object.getNodeType()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return object.getStringValue();
                }
            }
        } else if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    public String getTextTrim() {
        Object object = ((AbstractNode)this).getText();
        StringBuilder stringBuilder = new StringBuilder();
        object = new StringTokenizer((String)object);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            stringBuilder.append(string);
            if (!((StringTokenizer)object).hasMoreTokens()) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    @Override
    public void setProcessingInstructions(List<ProcessingInstruction> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)object.next();
            this.addNode(processingInstruction);
        }
    }

    @Override
    public Element addElement(String object) {
        object = this.getDocumentFactory().createElement((String)object);
        this.add((Element)object);
        return object;
    }

    @Override
    public Element addElement(String object, String string) {
        object = this.getDocumentFactory().createElement((String)object, string);
        this.add((Element)object);
        return object;
    }

    @Override
    public Element addElement(QName object) {
        object = this.getDocumentFactory().createElement((QName)object);
        this.add((Element)object);
        return object;
    }

    public Element addElement(String object, String object2, String string) {
        object2 = Namespace.get((String)object2, string);
        object = this.getDocumentFactory().createQName((String)object, (Namespace)object2);
        return this.addElement((QName)object);
    }

    @Override
    public void add(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.add((Element)node);
                return;
            }
            case 8: {
                this.add((Comment)node);
                return;
            }
            case 7: {
                this.add((ProcessingInstruction)node);
                return;
            }
        }
        this.invalidNodeTypeAddException(node);
    }

    @Override
    public boolean remove(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return this.remove((Element)node);
            }
            case 8: {
                return this.remove((Comment)node);
            }
            case 7: {
                return this.remove((ProcessingInstruction)node);
            }
        }
        this.invalidNodeTypeAddException(node);
        return false;
    }

    @Override
    public void add(Comment comment) {
        this.addNode(comment);
    }

    @Override
    public void add(Element element) {
        this.addNode(element);
    }

    @Override
    public void add(ProcessingInstruction processingInstruction) {
        this.addNode(processingInstruction);
    }

    @Override
    public boolean remove(Comment comment) {
        return this.removeNode(comment);
    }

    @Override
    public boolean remove(Element element) {
        return this.removeNode(element);
    }

    @Override
    public boolean remove(ProcessingInstruction processingInstruction) {
        return this.removeNode(processingInstruction);
    }

    @Override
    public Element elementByID(String string) {
        int n2 = this.nodeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = this.node(i2);
            if (!(node instanceof Element)) continue;
            String string2 = this.elementID((Element)(node = (Element)node));
            if (string2 != null && string2.equals(string)) {
                return node;
            }
            if ((node = node.elementByID(string)) == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public void appendContent(Branch branch) {
        int n2 = branch.nodeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = branch.node(i2);
            this.add((Node)node.clone());
        }
    }

    @Override
    public Node node(int n2) {
        return this.contentList().get(n2);
    }

    @Override
    public int nodeCount() {
        return this.contentList().size();
    }

    @Override
    public int indexOf(Node node) {
        return this.contentList().indexOf(node);
    }

    @Override
    public Iterator<Node> nodeIterator() {
        return this.contentList().iterator();
    }

    protected String elementID(Element element) {
        return element.attributeValue("ID");
    }

    protected abstract List<Node> contentList();

    protected List<Node> createContentList() {
        return new ArrayList<Node>(5);
    }

    protected List<Node> createContentList(int n2) {
        return new ArrayList<Node>(n2);
    }

    protected <T extends Node> BackedList<T> createResultList() {
        AbstractBranch abstractBranch = this;
        return new BackedList(abstractBranch, abstractBranch.contentList());
    }

    protected <T extends Node> List<T> createSingleResultList(T t2) {
        AbstractBranch abstractBranch = this;
        BackedList<T> backedList = new BackedList<T>(abstractBranch, abstractBranch.contentList(), 1);
        backedList.addLocal(t2);
        return backedList;
    }

    protected <T extends Node> List<T> createEmptyList() {
        AbstractBranch abstractBranch = this;
        return new BackedList(abstractBranch, abstractBranch.contentList(), 0);
    }

    protected abstract void addNode(Node var1);

    protected abstract void addNode(int var1, Node var2);

    protected abstract boolean removeNode(Node var1);

    protected abstract void childAdded(Node var1);

    protected abstract void childRemoved(Node var1);

    protected void contentRemoved() {
        Object object = this.contentList();
        object = object.iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            this.childRemoved(node);
        }
    }

    protected void invalidNodeTypeAddException(Node node) {
        throw new IllegalAddException("Invalid node type. Cannot add node: " + node + " to this branch: " + this);
    }
}

