/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Visitor;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.AbstractBranch;

public abstract class AbstractDocument
extends AbstractBranch
implements Document {
    protected String encoding;

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public String getPath(Element element) {
        return "/";
    }

    @Override
    public String getUniquePath(Element element) {
        return "/";
    }

    @Override
    public Document getDocument() {
        return this;
    }

    @Override
    public String getXMLEncoding() {
        return null;
    }

    @Override
    public String getStringValue() {
        Element element = this.getRootElement();
        if (element != null) {
            return element.getStringValue();
        }
        return "";
    }

    @Override
    public String asXML() {
        Object object = new OutputFormat();
        ((OutputFormat)object).setEncoding(this.encoding);
        try {
            StringWriter stringWriter = new StringWriter();
            object = new XMLWriter(stringWriter, (OutputFormat)object);
            ((XMLWriter)object).write(this);
            ((XMLWriter)object).flush();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException while generating textual representation: " + iOException.getMessage());
        }
    }

    @Override
    public void write(Writer object) {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setEncoding(this.encoding);
        object = new XMLWriter((Writer)object, outputFormat);
        ((XMLWriter)object).write(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        Iterator iterator = this.getDocType();
        if (iterator != null) {
            visitor.visit((DocumentType)((Object)iterator));
        }
        if ((iterator = this.content()) != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                node.accept(visitor);
            }
        }
    }

    public String toString() {
        return super.toString() + " [Document: name " + this.getName() + "]";
    }

    @Override
    public void normalize() {
        Element element = this.getRootElement();
        if (element != null) {
            element.normalize();
        }
    }

    @Override
    public Document addComment(String object) {
        object = this.getDocumentFactory().createComment((String)object);
        this.add((Comment)object);
        return this;
    }

    @Override
    public Document addProcessingInstruction(String object, String string) {
        object = this.getDocumentFactory().createProcessingInstruction((String)object, string);
        this.add((ProcessingInstruction)object);
        return this;
    }

    @Override
    public Document addProcessingInstruction(String object, Map<String, String> map) {
        object = this.getDocumentFactory().createProcessingInstruction((String)object, map);
        this.add((ProcessingInstruction)object);
        return this;
    }

    @Override
    public Element addElement(String object) {
        object = this.getDocumentFactory().createElement((String)object);
        ((AbstractBranch)this).add((Element)object);
        return object;
    }

    @Override
    public Element addElement(String object, String string) {
        object = this.getDocumentFactory().createElement((String)object, string);
        ((AbstractBranch)this).add((Element)object);
        return object;
    }

    @Override
    public Element addElement(QName object) {
        object = this.getDocumentFactory().createElement((QName)object);
        ((AbstractBranch)this).add((Element)object);
        return object;
    }

    @Override
    public void setRootElement(Element element) {
        this.clearContent();
        if (element != null) {
            super.add(element);
            this.rootElementAdded(element);
        }
    }

    @Override
    public void add(Element element) {
        this.checkAddElementAllowed(element);
        super.add(element);
        this.rootElementAdded(element);
    }

    @Override
    public boolean remove(Element element) {
        boolean bl = super.remove(element);
        Element element2 = this.getRootElement();
        if (element2 != null && bl) {
            this.setRootElement(null);
        }
        element.setDocument(null);
        return bl;
    }

    @Override
    public Node asXPathResult(Element element) {
        return this;
    }

    @Override
    protected void childAdded(Node node) {
        if (node != null) {
            node.setDocument(this);
        }
    }

    @Override
    protected void childRemoved(Node node) {
        if (node != null) {
            node.setDocument(null);
        }
    }

    protected void checkAddElementAllowed(Element element) {
        Element element2 = this.getRootElement();
        if (element2 != null) {
            throw new IllegalAddException(this, (Node)element, "Cannot add another element to this Document as it already has a root element of: " + element2.getQualifiedName());
        }
    }

    protected abstract void rootElementAdded(Element var1);

    @Override
    public void setXMLEncoding(String string) {
        this.encoding = string;
    }
}

