/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.Writer;
import java.util.List;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Visitor;
import org.dom4j.dtd.Decl;
import org.dom4j.tree.AbstractNode;

public abstract class AbstractDocumentType
extends AbstractNode
implements DocumentType {
    @Override
    public short getNodeType() {
        return 10;
    }

    @Override
    public String getName() {
        return this.getElementName();
    }

    @Override
    public void setName(String string) {
        this.setElementName(string);
    }

    @Override
    public String getPath(Element element) {
        return "";
    }

    @Override
    public String getUniquePath(Element element) {
        return "";
    }

    @Override
    public String getText() {
        List<Decl> list = this.getInternalDeclarations();
        if (list != null && list.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            if ((list = list.iterator()).hasNext()) {
                Decl decl = (Decl)list.next();
                stringBuilder.append(decl.toString());
                while (list.hasNext()) {
                    decl = (Decl)list.next();
                    stringBuilder.append("\n");
                    stringBuilder.append(decl.toString());
                }
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public String toString() {
        return super.toString() + " [DocumentType: " + this.asXML() + "]";
    }

    @Override
    public String asXML() {
        StringBuilder stringBuilder = new StringBuilder("<!DOCTYPE ");
        stringBuilder.append(this.getElementName());
        boolean bl = false;
        String string = this.getPublicID();
        if (string != null && string.length() > 0) {
            stringBuilder.append(" PUBLIC \"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
            bl = true;
        }
        if ((string = this.getSystemID()) != null && string.length() > 0) {
            if (!bl) {
                stringBuilder.append(" SYSTEM");
            }
            stringBuilder.append(" \"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    @Override
    public void write(Writer writer) {
        Object object;
        writer.write("<!DOCTYPE ");
        writer.write(this.getElementName());
        boolean bl = false;
        Object object2 = this.getPublicID();
        if (object2 != null && ((String)object2).length() > 0) {
            writer.write(" PUBLIC \"");
            writer.write((String)object2);
            writer.write("\"");
            bl = true;
        }
        if ((object2 = this.getSystemID()) != null && ((String)object2).length() > 0) {
            if (!bl) {
                writer.write(" SYSTEM");
            }
            writer.write(" \"");
            writer.write((String)object2);
            writer.write("\"");
        }
        if ((object = this.getInternalDeclarations()) != null && object.size() > 0) {
            writer.write(" [");
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (Decl)object.next();
                writer.write("\n  ");
                writer.write(object2.toString());
            }
            writer.write("\n]");
        }
        writer.write(">");
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

