/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.AbstractBranch;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;
import org.dom4j.tree.NamespaceStack;
import org.dom4j.tree.SingleIterator;
import org.xml.sax.Attributes;

public abstract class AbstractElement
extends AbstractBranch
implements Element {
    private static final DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();
    protected static final boolean VERBOSE_TOSTRING = false;
    protected static final boolean USE_STRINGVALUE_SEPARATOR = false;

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public boolean isRootElement() {
        Branch branch = this.getDocument();
        return branch != null && (branch = branch.getRootElement()) == this;
    }

    @Override
    public void setName(String string) {
        AbstractElement abstractElement = this;
        abstractElement.setQName(abstractElement.getDocumentFactory().createQName(string));
    }

    public void setNamespace(Namespace namespace) {
        AbstractElement abstractElement = this;
        abstractElement.setQName(abstractElement.getDocumentFactory().createQName(((AbstractNode)this).getName(), namespace));
    }

    public String getXPathNameStep() {
        String string = this.getNamespaceURI();
        if (string == null || string.length() == 0) {
            return ((AbstractNode)this).getName();
        }
        string = this.getNamespacePrefix();
        if (string == null || string.length() == 0) {
            return "*[name()='" + ((AbstractNode)this).getName() + "']";
        }
        return this.getQualifiedName();
    }

    @Override
    public String getPath(Element element) {
        if (this == element) {
            return ".";
        }
        Element element2 = this.getParent();
        if (element2 == null) {
            return "/" + this.getXPathNameStep();
        }
        if (element2 == element) {
            return this.getXPathNameStep();
        }
        return element2.getPath(element) + "/" + this.getXPathNameStep();
    }

    @Override
    public String getUniquePath(Element object) {
        int n2;
        Element element = this.getParent();
        if (element == null) {
            return "/" + this.getXPathNameStep();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (element != object) {
            stringBuilder.append(element.getUniquePath((Element)object));
            stringBuilder.append("/");
        }
        stringBuilder.append(this.getXPathNameStep());
        object = element.elements(this.getQName());
        if (object.size() > 1 && (n2 = object.indexOf(this)) >= 0) {
            stringBuilder.append("[");
            stringBuilder.append(Integer.toString(++n2));
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    @Override
    public String asXML() {
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xMLWriter = new XMLWriter(stringWriter, new OutputFormat());
            xMLWriter.write(this);
            xMLWriter.flush();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException while generating textual representation: " + iOException.getMessage());
        }
    }

    @Override
    public void write(Writer object) {
        object = new XMLWriter((Writer)object, new OutputFormat());
        ((XMLWriter)object).write(this);
    }

    @Override
    public void accept(Visitor visitor) {
        Node node;
        int n2;
        visitor.visit(this);
        int n3 = this.attributeCount();
        for (n2 = 0; n2 < n3; ++n2) {
            node = this.attribute(n2);
            visitor.visit((Attribute)node);
        }
        n3 = ((AbstractBranch)this).nodeCount();
        for (n2 = 0; n2 < n3; ++n2) {
            node = ((AbstractBranch)this).node(n2);
            node.accept(visitor);
        }
    }

    public String toString() {
        String string = this.getNamespaceURI();
        if (string != null && string.length() > 0) {
            return super.toString() + " [Element: <" + this.getQualifiedName() + " uri: " + string + " attributes: " + this.attributeList() + "/>]";
        }
        return super.toString() + " [Element: <" + this.getQualifiedName() + " attributes: " + this.attributeList() + "/>]";
    }

    @Override
    public Namespace getNamespace() {
        return this.getQName().getNamespace();
    }

    @Override
    public String getName() {
        return this.getQName().getName();
    }

    @Override
    public String getNamespacePrefix() {
        return this.getQName().getNamespacePrefix();
    }

    @Override
    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    @Override
    public String getQualifiedName() {
        return this.getQName().getQualifiedName();
    }

    @Override
    public Object getData() {
        return ((AbstractNode)this).getText();
    }

    @Override
    public void setData(Object object) {
    }

    @Override
    public Node node(int n2) {
        if (n2 >= 0) {
            List<Node> list = this.contentList();
            if (n2 >= list.size()) {
                return null;
            }
            Node node = list.get(n2);
            if (node != null) {
                return node;
            }
        }
        return null;
    }

    @Override
    public int indexOf(Node node) {
        return this.contentList().indexOf(node);
    }

    @Override
    public int nodeCount() {
        return this.contentList().size();
    }

    @Override
    public Iterator<Node> nodeIterator() {
        return this.contentList().iterator();
    }

    @Override
    public Element element(String string) {
        for (Node node : this.contentList()) {
            if (!(node instanceof Element) || !string.equals((node = (Element)node).getName())) continue;
            return node;
        }
        return null;
    }

    @Override
    public Element element(QName qName) {
        for (Node node : this.contentList()) {
            if (!(node instanceof Element) || !qName.equals((node = (Element)node).getQName())) continue;
            return node;
        }
        return null;
    }

    public Element element(String string, Namespace namespace) {
        AbstractElement abstractElement = this;
        return abstractElement.element(abstractElement.getDocumentFactory().createQName(string, namespace));
    }

    @Override
    public List<Element> elements() {
        BackedList<Element> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof Element)) continue;
            backedList.addLocal((Element)node);
        }
        return backedList;
    }

    @Override
    public List<Element> elements(String string) {
        BackedList<Element> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof Element) || !string.equals((node = (Element)node).getName())) continue;
            backedList.addLocal((Element)node);
        }
        return backedList;
    }

    @Override
    public List<Element> elements(QName qName) {
        BackedList<Element> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof Element) || !qName.equals((node = (Element)node).getQName())) continue;
            backedList.addLocal((Element)node);
        }
        return backedList;
    }

    public List<Element> elements(String string, Namespace namespace) {
        AbstractElement abstractElement = this;
        return abstractElement.elements(abstractElement.getDocumentFactory().createQName(string, namespace));
    }

    @Override
    public Iterator<Element> elementIterator() {
        List<Element> list = this.elements();
        return list.iterator();
    }

    @Override
    public Iterator<Element> elementIterator(String object) {
        object = this.elements((String)object);
        return object.iterator();
    }

    @Override
    public Iterator<Element> elementIterator(QName object) {
        object = this.elements((QName)object);
        return object.iterator();
    }

    public Iterator<Element> elementIterator(String string, Namespace namespace) {
        AbstractElement abstractElement = this;
        return abstractElement.elementIterator(abstractElement.getDocumentFactory().createQName(string, namespace));
    }

    @Override
    public List<Attribute> attributes() {
        AbstractElement abstractElement = this;
        return new ContentListFacade<Attribute>(abstractElement, abstractElement.attributeList());
    }

    @Override
    public Iterator<Attribute> attributeIterator() {
        return this.attributeList().iterator();
    }

    @Override
    public Attribute attribute(int n2) {
        return this.attributeList().get(n2);
    }

    @Override
    public int attributeCount() {
        return this.attributeList().size();
    }

    @Override
    public Attribute attribute(String string) {
        for (Attribute attribute : this.attributeList()) {
            if (!string.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public Attribute attribute(QName qName) {
        for (Attribute attribute : this.attributeList()) {
            if (!qName.equals(attribute.getQName())) continue;
            return attribute;
        }
        return null;
    }

    public Attribute attribute(String string, Namespace namespace) {
        AbstractElement abstractElement = this;
        return abstractElement.attribute(abstractElement.getDocumentFactory().createQName(string, namespace));
    }

    public void setAttributes(Attributes attributes, NamespaceStack namespaceStack, boolean bl) {
        int n2 = attributes.getLength();
        if (n2 > 0) {
            DocumentFactory documentFactory = this.getDocumentFactory();
            if (n2 == 1) {
                String string = attributes.getQName(0);
                if (bl || !string.startsWith("xmlns")) {
                    String string2 = attributes.getURI(0);
                    String string3 = attributes.getLocalName(0);
                    String string4 = attributes.getValue(0);
                    QName qName = namespaceStack.getAttributeQName(string2, string3, string);
                    this.add(documentFactory.createAttribute((Element)this, qName, string4));
                }
                return;
            }
            List<Attribute> list = this.attributeList(n2);
            list.clear();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = attributes.getQName(i2);
                if (!bl && ((String)object).startsWith("xmlns")) continue;
                String string = attributes.getURI(i2);
                String string5 = attributes.getLocalName(i2);
                String string6 = attributes.getValue(i2);
                object = namespaceStack.getAttributeQName(string, string5, (String)object);
                object = documentFactory.createAttribute((Element)this, (QName)object, string6);
                list.add((Attribute)object);
                this.childAdded((Node)object);
            }
        }
    }

    @Override
    public String attributeValue(String object) {
        if ((object = this.attribute((String)object)) == null) {
            return null;
        }
        return object.getValue();
    }

    @Override
    public String attributeValue(QName object) {
        if ((object = this.attribute((QName)object)) == null) {
            return null;
        }
        return object.getValue();
    }

    @Override
    public String attributeValue(String string, String string2) {
        if ((string = this.attributeValue(string)) != null) {
            return string;
        }
        return string2;
    }

    @Override
    public String attributeValue(QName object, String string) {
        if ((object = this.attributeValue((QName)object)) != null) {
            return object;
        }
        return string;
    }

    @Override
    public void setAttributeValue(String string, String string2) {
        this.addAttribute(string, string2);
    }

    @Override
    public void setAttributeValue(QName qName, String string) {
        this.addAttribute(qName, string);
    }

    @Override
    public void add(Attribute attribute) {
        if (attribute.getParent() != null) {
            String string = "The Attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, (Node)attribute, string);
        }
        if (attribute.getValue() == null) {
            Attribute attribute2 = this.attribute(attribute.getQName());
            if (attribute2 != null) {
                this.remove(attribute2);
            }
            return;
        }
        this.attributeList().add(attribute);
        this.childAdded(attribute);
    }

    @Override
    public boolean remove(Attribute attribute) {
        List<Attribute> list = this.attributeList();
        boolean bl = list.remove(attribute);
        if (bl) {
            this.childRemoved(attribute);
        } else if ((attribute = this.attribute(attribute.getQName())) != null) {
            list.remove(attribute);
            bl = true;
        }
        return bl;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions() {
        BackedList<ProcessingInstruction> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof ProcessingInstruction)) continue;
            backedList.addLocal((ProcessingInstruction)node);
        }
        return backedList;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions(String string) {
        BackedList<ProcessingInstruction> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof ProcessingInstruction) || !string.equals((node = (ProcessingInstruction)node).getName())) continue;
            backedList.addLocal((ProcessingInstruction)node);
        }
        return backedList;
    }

    @Override
    public ProcessingInstruction processingInstruction(String string) {
        for (Node node : this.contentList()) {
            if (!(node instanceof ProcessingInstruction) || !string.equals((node = (ProcessingInstruction)node).getName())) continue;
            return node;
        }
        return null;
    }

    @Override
    public boolean removeProcessingInstruction(String string) {
        Iterator<Node> iterator = this.contentList().iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (!(node instanceof ProcessingInstruction) || !string.equals((node = (ProcessingInstruction)node).getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public Node getXPathResult(int n2) {
        Node node = ((AbstractBranch)this).node(n2);
        if (node != null && !node.supportsParent()) {
            return node.asXPathResult(this);
        }
        return node;
    }

    @Override
    public Element addAttribute(String string, String string2) {
        Attribute attribute = this.attribute(string);
        if (string2 != null) {
            if (attribute == null) {
                AbstractElement abstractElement = this;
                abstractElement.add(abstractElement.getDocumentFactory().createAttribute((Element)this, string, string2));
            } else if (attribute.isReadOnly()) {
                this.remove(attribute);
                AbstractElement abstractElement = this;
                abstractElement.add(abstractElement.getDocumentFactory().createAttribute((Element)this, string, string2));
            } else {
                attribute.setValue(string2);
            }
        } else if (attribute != null) {
            this.remove(attribute);
        }
        return this;
    }

    @Override
    public Element addAttribute(QName qName, String string) {
        Attribute attribute = this.attribute(qName);
        if (string != null) {
            if (attribute == null) {
                AbstractElement abstractElement = this;
                abstractElement.add(abstractElement.getDocumentFactory().createAttribute((Element)this, qName, string));
            } else if (attribute.isReadOnly()) {
                this.remove(attribute);
                AbstractElement abstractElement = this;
                abstractElement.add(abstractElement.getDocumentFactory().createAttribute((Element)this, qName, string));
            } else {
                attribute.setValue(string);
            }
        } else if (attribute != null) {
            this.remove(attribute);
        }
        return this;
    }

    @Override
    public Element addCDATA(String object) {
        object = this.getDocumentFactory().createCDATA((String)object);
        this.addNewNode((Node)object);
        return this;
    }

    @Override
    public Element addComment(String object) {
        object = this.getDocumentFactory().createComment((String)object);
        this.addNewNode((Node)object);
        return this;
    }

    @Override
    public Element addElement(String object) {
        Namespace namespace;
        DocumentFactory documentFactory = this.getDocumentFactory();
        int n2 = ((String)object).indexOf(":");
        String string = object;
        if (n2 > 0) {
            String string2 = ((String)object).substring(0, n2);
            string = ((String)object).substring(n2 + 1);
            namespace = this.getNamespaceForPrefix(string2);
            if (namespace == null) {
                throw new IllegalAddException("No such namespace prefix: " + string2 + " is in scope on: " + this + " so cannot add element: " + (String)object);
            }
        } else {
            namespace = this.getNamespaceForPrefix("");
        }
        if (namespace != null) {
            object = documentFactory.createQName(string, namespace);
            object = documentFactory.createElement((QName)object);
        } else {
            object = documentFactory.createElement((String)object);
        }
        this.addNewNode((Node)object);
        return object;
    }

    @Override
    public Element addEntity(String object, String string) {
        object = this.getDocumentFactory().createEntity((String)object, string);
        this.addNewNode((Node)object);
        return this;
    }

    @Override
    public Element addNamespace(String object, String string) {
        object = this.getDocumentFactory().createNamespace((String)object, string);
        this.addNewNode((Node)object);
        return this;
    }

    @Override
    public Element addProcessingInstruction(String object, String string) {
        object = this.getDocumentFactory().createProcessingInstruction((String)object, string);
        this.addNewNode((Node)object);
        return this;
    }

    @Override
    public Element addProcessingInstruction(String object, Map<String, String> map) {
        object = this.getDocumentFactory().createProcessingInstruction((String)object, map);
        this.addNewNode((Node)object);
        return this;
    }

    @Override
    public Element addText(String object) {
        object = this.getDocumentFactory().createText((String)object);
        this.addNewNode((Node)object);
        return this;
    }

    @Override
    public void add(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                ((AbstractBranch)this).add((Element)node);
                return;
            }
            case 2: {
                this.add((Attribute)node);
                return;
            }
            case 3: {
                this.add((Text)node);
                return;
            }
            case 4: {
                this.add((CDATA)node);
                return;
            }
            case 5: {
                this.add((Entity)node);
                return;
            }
            case 7: {
                ((AbstractBranch)this).add((ProcessingInstruction)node);
                return;
            }
            case 8: {
                ((AbstractBranch)this).add((Comment)node);
                return;
            }
            case 13: {
                this.add((Namespace)node);
                return;
            }
        }
        this.invalidNodeTypeAddException(node);
    }

    @Override
    public boolean remove(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return ((AbstractBranch)this).remove((Element)node);
            }
            case 2: {
                return this.remove((Attribute)node);
            }
            case 3: {
                return this.remove((Text)node);
            }
            case 4: {
                return this.remove((CDATA)node);
            }
            case 5: {
                return this.remove((Entity)node);
            }
            case 7: {
                return ((AbstractBranch)this).remove((ProcessingInstruction)node);
            }
            case 8: {
                return ((AbstractBranch)this).remove((Comment)node);
            }
            case 13: {
                return this.remove((Namespace)node);
            }
        }
        return false;
    }

    @Override
    public void add(CDATA cDATA) {
        this.addNode(cDATA);
    }

    @Override
    public void add(Comment comment) {
        this.addNode(comment);
    }

    @Override
    public void add(Element element) {
        this.addNode(element);
    }

    @Override
    public void add(Entity entity) {
        this.addNode(entity);
    }

    @Override
    public void add(Namespace namespace) {
        this.addNode(namespace);
    }

    @Override
    public void add(ProcessingInstruction processingInstruction) {
        this.addNode(processingInstruction);
    }

    @Override
    public void add(Text text) {
        this.addNode(text);
    }

    @Override
    public boolean remove(CDATA cDATA) {
        return this.removeNode(cDATA);
    }

    @Override
    public boolean remove(Comment comment) {
        return this.removeNode(comment);
    }

    @Override
    public boolean remove(Element element) {
        return this.removeNode(element);
    }

    @Override
    public boolean remove(Entity entity) {
        return this.removeNode(entity);
    }

    @Override
    public boolean remove(Namespace namespace) {
        return this.removeNode(namespace);
    }

    @Override
    public boolean remove(ProcessingInstruction processingInstruction) {
        return this.removeNode(processingInstruction);
    }

    @Override
    public boolean remove(Text text) {
        return this.removeNode(text);
    }

    @Override
    public boolean hasMixedContent() {
        List<Node> list = this.contentList();
        if (list == null || list.isEmpty() || list.size() < 2) {
            return false;
        }
        Class<?> object = null;
        for (Node node : list) {
            Class<?> object2 = node.getClass();
            if (object2 == object) continue;
            if (object != null) {
                return true;
            }
            object = object2;
        }
        return false;
    }

    @Override
    public boolean isTextOnly() {
        List<Node> list = this.contentList();
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (Node node : list) {
            if (node instanceof CharacterData) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setText(String string) {
        List<Node> list = this.contentList();
        if (list != null) {
            list = list.iterator();
            while (list.hasNext()) {
                Node node = (Node)list.next();
                switch (node.getNodeType()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        list.remove();
                    }
                }
            }
        }
        this.addText(string);
    }

    @Override
    public String getStringValue() {
        List<Node> list = this.contentList();
        int n2 = list.size();
        if (n2 > 0) {
            if (n2 == 1) {
                return this.getContentAsStringValue(list.get(0));
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Node node : list) {
                String object = this.getContentAsStringValue(node);
                if (object.length() <= 0) continue;
                stringBuilder.append(object);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public void normalize() {
        List<Node> list = this.contentList();
        Node node = null;
        int n2 = 0;
        while (n2 < list.size()) {
            Node node2 = list.get(n2);
            if (node2 instanceof Text) {
                node2 = (Text)node2;
                if (node != null) {
                    node.appendText(node2.getText());
                    this.remove((Text)node2);
                    continue;
                }
                String string = node2.getText();
                if (string == null || string.length() <= 0) {
                    this.remove((Text)node2);
                    continue;
                }
                node = node2;
                ++n2;
                continue;
            }
            if (node2 instanceof Element) {
                node2 = (Element)node2;
                node2.normalize();
            }
            node = null;
            ++n2;
        }
    }

    @Override
    public String elementText(String object) {
        if ((object = this.element((String)object)) != null) {
            return object.getText();
        }
        return null;
    }

    @Override
    public String elementText(QName object) {
        if ((object = this.element((QName)object)) != null) {
            return object.getText();
        }
        return null;
    }

    @Override
    public String elementTextTrim(String object) {
        if ((object = this.element((String)object)) != null) {
            return object.getTextTrim();
        }
        return null;
    }

    @Override
    public String elementTextTrim(QName object) {
        if ((object = this.element((QName)object)) != null) {
            return object.getTextTrim();
        }
        return null;
    }

    @Override
    public void appendAttributes(Element element) {
        int n2 = element.attributeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Attribute attribute = element.attribute(i2);
            if (attribute.supportsParent()) {
                this.addAttribute(attribute.getQName(), attribute.getValue());
                continue;
            }
            this.add(attribute);
        }
    }

    @Override
    public Element createCopy() {
        AbstractElement abstractElement = this;
        Element element = abstractElement.createElement(abstractElement.getQName());
        element.appendAttributes(this);
        element.appendContent(this);
        return element;
    }

    @Override
    public Element createCopy(String object) {
        object = this.createElement((String)object);
        object.appendAttributes(this);
        object.appendContent(this);
        return object;
    }

    @Override
    public Element createCopy(QName object) {
        object = this.createElement((QName)object);
        object.appendAttributes(this);
        object.appendContent(this);
        return object;
    }

    @Override
    public QName getQName(String object) {
        String string = "";
        String string2 = object;
        int n2 = ((String)object).indexOf(":");
        if (n2 > 0) {
            string = ((String)object).substring(0, n2);
            string2 = ((String)object).substring(n2 + 1);
        }
        if ((object = this.getNamespaceForPrefix(string)) != null) {
            return this.getDocumentFactory().createQName(string2, (Namespace)object);
        }
        return this.getDocumentFactory().createQName(string2);
    }

    @Override
    public Namespace getNamespaceForPrefix(String string) {
        Node node2;
        if (string == null) {
            string = "";
        }
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (string.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        for (Node node2 : this.contentList()) {
            if (!(node2 instanceof Namespace) || !string.equals(((Namespace)(node2 = (Namespace)node2)).getPrefix())) continue;
            return node2;
        }
        Element element = this.getParent();
        if (element != null && (node2 = element.getNamespaceForPrefix(string)) != null) {
            return node2;
        }
        if (string.length() == 0) {
            return Namespace.NO_NAMESPACE;
        }
        return null;
    }

    @Override
    public Namespace getNamespaceForURI(String string) {
        if (string == null || string.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        if (string.equals(this.getNamespaceURI())) {
            return this.getNamespace();
        }
        for (Node node : this.contentList()) {
            if (!(node instanceof Namespace) || !string.equals(((Namespace)(node = (Namespace)node)).getURI())) continue;
            return node;
        }
        return null;
    }

    @Override
    public List<Namespace> getNamespacesForURI(String string) {
        BackedList<Namespace> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof Namespace) || !((Namespace)node).getURI().equals(string)) continue;
            backedList.addLocal((Namespace)node);
        }
        return backedList;
    }

    @Override
    public List<Namespace> declaredNamespaces() {
        BackedList<Namespace> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof Namespace)) continue;
            backedList.addLocal((Namespace)node);
        }
        return backedList;
    }

    @Override
    public List<Namespace> additionalNamespaces() {
        BackedList<Namespace> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof Namespace) || ((Namespace)(node = (Namespace)node)).equals(this.getNamespace())) continue;
            backedList.addLocal((Namespace)node);
        }
        return backedList;
    }

    public List<Namespace> additionalNamespaces(String string) {
        BackedList<Namespace> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof Namespace) || string.equals(((Namespace)(node = (Namespace)node)).getURI())) continue;
            backedList.addLocal((Namespace)node);
        }
        return backedList;
    }

    public void ensureAttributesCapacity(int n2) {
        ArrayList arrayList;
        if (n2 > 1 && (arrayList = this.attributeList()) instanceof ArrayList) {
            arrayList = arrayList;
            arrayList.ensureCapacity(n2);
        }
    }

    protected Element createElement(String string) {
        return this.getDocumentFactory().createElement(string);
    }

    protected Element createElement(QName qName) {
        return this.getDocumentFactory().createElement(qName);
    }

    @Override
    public void addNode(Node node) {
        if (node.getParent() != null) {
            String string = "The Node already has an existing parent of \"" + node.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, node, string);
        }
        this.addNewNode(node);
    }

    @Override
    protected void addNode(int n2, Node node) {
        if (node.getParent() != null) {
            String string = "The Node already has an existing parent of \"" + node.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, node, string);
        }
        this.addNewNode(n2, node);
    }

    protected void addNewNode(Node node) {
        this.contentList().add(node);
        this.childAdded(node);
    }

    protected void addNewNode(int n2, Node node) {
        this.contentList().add(n2, node);
        this.childAdded(node);
    }

    @Override
    protected boolean removeNode(Node node) {
        boolean bl = this.contentList().remove(node);
        if (bl) {
            this.childRemoved(node);
        }
        return bl;
    }

    @Override
    public void childAdded(Node node) {
        if (node != null) {
            node.setParent(this);
        }
    }

    @Override
    public void childRemoved(Node node) {
        if (node != null) {
            node.setParent(null);
            node.setDocument(null);
        }
    }

    protected abstract List<Attribute> attributeList();

    protected abstract List<Attribute> attributeList(int var1);

    @Override
    protected DocumentFactory getDocumentFactory() {
        Serializable serializable = this.getQName();
        if (serializable != null && (serializable = serializable.getDocumentFactory()) != null) {
            return serializable;
        }
        return DOCUMENT_FACTORY;
    }

    protected List<Attribute> createAttributeList() {
        return this.createAttributeList(5);
    }

    protected List<Attribute> createAttributeList(int n2) {
        return new ArrayList<Attribute>(n2);
    }

    protected <T> Iterator<T> createSingleIterator(T t2) {
        return new SingleIterator<T>(t2);
    }
}

