/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.NodeFilter;
import org.dom4j.XPath;
import org.dom4j.rule.Pattern;

public abstract class AbstractNode
implements Serializable,
Cloneable,
Node {
    protected static final String[] NODE_TYPE_NAMES = new String[]{"Node", "Element", "Attribute", "Text", "CDATA", "Entity", "Entity", "ProcessingInstruction", "Comment", "Document", "DocumentType", "DocumentFragment", "Notation", "Namespace", "Unknown"};
    private static final DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();

    @Override
    public short getNodeType() {
        return 14;
    }

    @Override
    public String getNodeTypeName() {
        short s2 = this.getNodeType();
        if (s2 < 0 || s2 >= NODE_TYPE_NAMES.length) {
            return "Unknown";
        }
        return NODE_TYPE_NAMES[s2];
    }

    @Override
    public Document getDocument() {
        Element element = this.getParent();
        if (element != null) {
            return element.getDocument();
        }
        return null;
    }

    @Override
    public void setDocument(Document document) {
    }

    @Override
    public Element getParent() {
        return null;
    }

    @Override
    public void setParent(Element element) {
    }

    @Override
    public boolean supportsParent() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean hasContent() {
        return false;
    }

    @Override
    public String getPath() {
        return this.getPath(null);
    }

    @Override
    public String getUniquePath() {
        return this.getUniquePath(null);
    }

    @Override
    public Object clone() {
        if (this.isReadOnly()) {
            return this;
        }
        try {
            Node node = (Node)super.clone();
            node.setParent(null);
            node.setDocument(null);
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("This should never happen. Caught: " + cloneNotSupportedException);
        }
    }

    @Override
    public Node detach() {
        Branch branch = this.getParent();
        if (branch != null) {
            branch.remove(this);
        } else {
            branch = this.getDocument();
            if (branch != null) {
                branch.remove(this);
            }
        }
        this.setParent(null);
        this.setDocument(null);
        return this;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String string) {
        throw new UnsupportedOperationException("This node cannot be modified");
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public String getStringValue() {
        return this.getText();
    }

    @Override
    public void setText(String string) {
        throw new UnsupportedOperationException("This node cannot be modified");
    }

    @Override
    public void write(Writer writer) {
        writer.write(this.asXML());
    }

    @Override
    public Object selectObject(String object) {
        object = this.createXPath((String)object);
        return object.evaluate(this);
    }

    @Override
    public List<Node> selectNodes(String object) {
        object = this.createXPath((String)object);
        return object.selectNodes(this);
    }

    @Override
    public List<Node> selectNodes(String string, String string2) {
        return this.selectNodes(string, string2, false);
    }

    @Override
    public List<Node> selectNodes(String object, String object2, boolean bl) {
        object = this.createXPath((String)object);
        object2 = this.createXPath((String)object2);
        return object.selectNodes(this, (XPath)object2, bl);
    }

    @Override
    public Node selectSingleNode(String object) {
        object = this.createXPath((String)object);
        return object.selectSingleNode(this);
    }

    @Override
    public String valueOf(String object) {
        object = this.createXPath((String)object);
        return object.valueOf(this);
    }

    @Override
    public Number numberValueOf(String object) {
        object = this.createXPath((String)object);
        return object.numberValueOf(this);
    }

    @Override
    public boolean matches(String object) {
        object = this.createXPathFilter((String)object);
        return object.matches(this);
    }

    @Override
    public XPath createXPath(String string) {
        return this.getDocumentFactory().createXPath(string);
    }

    public NodeFilter createXPathFilter(String string) {
        return this.getDocumentFactory().createXPathFilter(string);
    }

    public Pattern createPattern(String string) {
        return this.getDocumentFactory().createPattern(string);
    }

    @Override
    public Node asXPathResult(Element element) {
        if (this.supportsParent()) {
            return this;
        }
        return this.createXPathResult(element);
    }

    protected DocumentFactory getDocumentFactory() {
        return DOCUMENT_FACTORY;
    }

    protected Node createXPathResult(Element element) {
        throw new RuntimeException("asXPathResult() not yet implemented fully for: " + this);
    }
}

