/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Node;
import org.dom4j.tree.AbstractBranch;

public class BackedList<T extends Node>
extends ArrayList<T> {
    private List<Node> branchContent;
    private AbstractBranch branch;

    public BackedList(AbstractBranch abstractBranch, List<Node> list) {
        List<Node> list2 = list;
        this(abstractBranch, list2, list2.size());
    }

    public BackedList(AbstractBranch abstractBranch, List<Node> list, int n2) {
        super(n2);
        this.branch = abstractBranch;
        this.branchContent = list;
    }

    public BackedList(AbstractBranch abstractBranch, List<Node> list, List<T> list2) {
        super(list2);
        this.branch = abstractBranch;
        this.branchContent = list;
    }

    @Override
    public boolean add(T t2) {
        this.branch.addNode((Node)t2);
        return super.add(t2);
    }

    @Override
    public void add(int n2, T t2) {
        int n3 = this.size();
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index value: " + n2 + " is less than zero");
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Index value: " + n2 + " cannot be greater than the size: " + n3);
        }
        n3 = n3 == 0 ? this.branchContent.size() : (n2 < n3 ? this.branchContent.indexOf(this.get(n2)) : this.branchContent.indexOf(this.get(n3 - 1)) + 1);
        this.branch.addNode(n3, (Node)t2);
        super.add(n2, t2);
    }

    @Override
    public T set(int n2, T t2) {
        int n3 = this.branchContent.indexOf(this.get(n2));
        if (n3 < 0) {
            int n4 = n3 = n2 == 0 ? 0 : Integer.MAX_VALUE;
        }
        if (n3 < this.branchContent.size()) {
            this.branch.removeNode((Node)this.get(n2));
            this.branch.addNode(n3, (Node)t2);
        } else {
            this.branch.removeNode((Node)this.get(n2));
            this.branch.addNode((Node)t2);
        }
        this.branch.childAdded((Node)t2);
        return (T)((Node)super.set(n2, t2));
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof Node) {
            this.branch.removeNode((Node)object);
        }
        return super.remove(object);
    }

    @Override
    public T remove(int n2) {
        Node node = (Node)super.remove(n2);
        if (node != null) {
            this.branch.removeNode(node);
        }
        return (T)node;
    }

    @Override
    public boolean addAll(Collection<? extends T> object) {
        BackedList backedList = this;
        backedList.ensureCapacity(backedList.size() + object.size());
        int n2 = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            this.add((T)((Node)object.next()));
            --n2;
        }
        return n2 != 0;
    }

    @Override
    public boolean addAll(int n2, Collection<? extends T> object) {
        BackedList backedList = this;
        backedList.ensureCapacity(backedList.size() + object.size());
        int n3 = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            this.add(n2++, (T)((Node)object.next()));
            --n3;
        }
        return n3 != 0;
    }

    @Override
    public void clear() {
        for (Node node : this) {
            this.branchContent.remove(node);
            this.branch.childRemoved(node);
        }
        super.clear();
    }

    public void addLocal(T t2) {
        super.add(t2);
    }
}

