/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.ContentListFacade;

public class BaseElement
extends AbstractElement {
    private QName qname;
    private Branch parentBranch;
    public List<Node> content;
    public List<Attribute> attributes;

    public BaseElement(String string) {
        this.qname = this.getDocumentFactory().createQName(string);
    }

    public BaseElement(QName qName) {
        this.qname = qName;
    }

    public BaseElement(String string, Namespace namespace) {
        this.qname = this.getDocumentFactory().createQName(string, namespace);
    }

    @Override
    public Element getParent() {
        Element element = null;
        if (this.parentBranch instanceof Element) {
            element = (Element)this.parentBranch;
        }
        return element;
    }

    @Override
    public void setParent(Element element) {
        if (this.parentBranch instanceof Element || element != null) {
            this.parentBranch = element;
        }
    }

    @Override
    public Document getDocument() {
        if (this.parentBranch instanceof Document) {
            return (Document)this.parentBranch;
        }
        if (this.parentBranch instanceof Element) {
            Element element = (Element)this.parentBranch;
            return element.getDocument();
        }
        return null;
    }

    @Override
    public void setDocument(Document document) {
        if (this.parentBranch instanceof Document || document != null) {
            this.parentBranch = document;
        }
    }

    @Override
    public boolean supportsParent() {
        return true;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public void setQName(QName qName) {
        this.qname = qName;
    }

    @Override
    public void clearContent() {
        this.contentList().clear();
    }

    @Override
    public void setContent(List<Node> list) {
        this.content = list;
        if (list instanceof ContentListFacade) {
            this.content = ((ContentListFacade)list).getBackingList();
        }
    }

    @Override
    public void setAttributes(List<Attribute> list) {
        this.attributes = list;
        if (list instanceof ContentListFacade) {
            this.attributes = ((ContentListFacade)list).getBackingList();
        }
    }

    @Override
    protected List<Node> contentList() {
        if (this.content == null) {
            this.content = this.createContentList();
        }
        return this.content;
    }

    @Override
    protected List<Attribute> attributeList() {
        if (this.attributes == null) {
            this.attributes = this.createAttributeList();
        }
        return this.attributes;
    }

    @Override
    protected List<Attribute> attributeList(int n2) {
        if (this.attributes == null) {
            this.attributes = this.createAttributeList(n2);
        }
        return this.attributes;
    }

    protected void setAttributeList(List<Attribute> list) {
        this.attributes = list;
    }
}

