/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.tree.AbstractDocument;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;
import org.xml.sax.EntityResolver;

public class DefaultDocument
extends AbstractDocument {
    private String name;
    private Element rootElement;
    private List<Node> content;
    private DocumentType docType;
    private DocumentFactory documentFactory = DocumentFactory.getInstance();
    private transient EntityResolver entityResolver;

    public DefaultDocument() {
    }

    public DefaultDocument(String string) {
        this.name = string;
    }

    public DefaultDocument(Element element) {
        this.rootElement = element;
    }

    public DefaultDocument(DocumentType documentType) {
        this.docType = documentType;
    }

    public DefaultDocument(Element element, DocumentType documentType) {
        this.rootElement = element;
        this.docType = documentType;
    }

    public DefaultDocument(String string, Element element, DocumentType documentType) {
        this.name = string;
        this.rootElement = element;
        this.docType = documentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Element getRootElement() {
        return this.rootElement;
    }

    @Override
    public DocumentType getDocType() {
        return this.docType;
    }

    @Override
    public void setDocType(DocumentType documentType) {
        this.docType = documentType;
    }

    @Override
    public Document addDocType(String string, String string2, String string3) {
        DefaultDocument defaultDocument = this;
        defaultDocument.setDocType(defaultDocument.getDocumentFactory().createDocType(string, string2, string3));
        return this;
    }

    @Override
    public String getXMLEncoding() {
        return this.encoding;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public Object clone() {
        DefaultDocument defaultDocument = (DefaultDocument)super.clone();
        ((DefaultDocument)super.clone()).rootElement = null;
        defaultDocument.content = null;
        defaultDocument.appendContent(this);
        return defaultDocument;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions() {
        BackedList<ProcessingInstruction> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof ProcessingInstruction)) continue;
            backedList.add((ProcessingInstruction)node);
        }
        return backedList;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions(String string) {
        BackedList<ProcessingInstruction> backedList = this.createResultList();
        for (Node node : this.contentList()) {
            if (!(node instanceof ProcessingInstruction) || !string.equals((node = (ProcessingInstruction)node).getName())) continue;
            backedList.add(node);
        }
        return backedList;
    }

    @Override
    public ProcessingInstruction processingInstruction(String string) {
        for (Node node : this.contentList()) {
            if (!(node instanceof ProcessingInstruction) || !string.equals((node = (ProcessingInstruction)node).getName())) continue;
            return node;
        }
        return null;
    }

    @Override
    public boolean removeProcessingInstruction(String string) {
        Iterator<Node> iterator = this.contentList().iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (!(node instanceof ProcessingInstruction) || !string.equals((node = (ProcessingInstruction)node).getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public void setContent(List<Node> list) {
        this.rootElement = null;
        this.contentRemoved();
        if (list instanceof ContentListFacade) {
            list = ((ContentListFacade)list).getBackingList();
        }
        if (list == null) {
            this.content = null;
            return;
        }
        int n2 = list.size();
        List<Node> list2 = this.createContentList(n2);
        for (Node node : list) {
            Document document = node.getDocument();
            if (document != null && document != this) {
                node = (Node)node.clone();
            }
            if (node instanceof Element) {
                if (this.rootElement == null) {
                    this.rootElement = (Element)node;
                } else {
                    throw new IllegalAddException("A document may only contain one root element: " + list);
                }
            }
            list2.add(node);
            this.childAdded(node);
        }
        this.content = list2;
    }

    @Override
    public void clearContent() {
        this.contentRemoved();
        this.content = null;
        this.rootElement = null;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    @Override
    protected List<Node> contentList() {
        if (this.content == null) {
            this.content = this.createContentList();
            if (this.rootElement != null) {
                this.content.add(this.rootElement);
            }
        }
        return this.content;
    }

    @Override
    protected void addNode(Node node) {
        if (node != null) {
            Object object = node.getDocument();
            if (object != null && object != this) {
                object = "The Node already has an existing document: " + object;
                throw new IllegalAddException(this, node, (String)object);
            }
            this.contentList().add(node);
            this.childAdded(node);
        }
    }

    @Override
    protected void addNode(int n2, Node node) {
        if (node != null) {
            Document document = node.getDocument();
            if (document != null && document != this) {
                String string = "The Node already has an existing document: " + document;
                throw new IllegalAddException(this, node, string);
            }
            this.contentList().add(n2, node);
            this.childAdded(node);
        }
    }

    @Override
    protected boolean removeNode(Node node) {
        if (node == this.rootElement) {
            this.rootElement = null;
        }
        if (this.contentList().remove(node)) {
            this.childRemoved(node);
            return true;
        }
        return false;
    }

    @Override
    protected void rootElementAdded(Element element) {
        this.rootElement = element;
        element.setDocument(this);
    }

    @Override
    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }
}

