/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;

public class DefaultElement
extends AbstractElement {
    private static final transient DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();
    private QName qname;
    private Branch parentBranch;
    private Object content;
    private Object attributes;

    public DefaultElement(String string) {
        this.qname = DOCUMENT_FACTORY.createQName(string);
    }

    public DefaultElement(QName qName) {
        this.qname = qName;
    }

    public DefaultElement(QName qName, int n2) {
        this.qname = qName;
        if (n2 > 1) {
            this.attributes = new ArrayList(n2);
        }
    }

    public DefaultElement(String string, Namespace namespace) {
        this.qname = DOCUMENT_FACTORY.createQName(string, namespace);
    }

    @Override
    public Element getParent() {
        Element element = null;
        if (this.parentBranch instanceof Element) {
            element = (Element)this.parentBranch;
        }
        return element;
    }

    @Override
    public void setParent(Element element) {
        if (this.parentBranch instanceof Element || element != null) {
            this.parentBranch = element;
        }
    }

    @Override
    public Document getDocument() {
        if (this.parentBranch instanceof Document) {
            return (Document)this.parentBranch;
        }
        if (this.parentBranch instanceof Element) {
            Element element = (Element)this.parentBranch;
            return element.getDocument();
        }
        return null;
    }

    @Override
    public void setDocument(Document document) {
        if (this.parentBranch instanceof Document || document != null) {
            this.parentBranch = document;
        }
    }

    @Override
    public boolean supportsParent() {
        return true;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public void setQName(QName qName) {
        this.qname = qName;
    }

    @Override
    public String getText() {
        Object object = this.content;
        if (object instanceof List) {
            return super.getText();
        }
        if (object != null) {
            return this.getContentAsText(object);
        }
        return "";
    }

    @Override
    public String getStringValue() {
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            int n2 = (iterator = (List)((Object)iterator)).size();
            if (n2 > 0) {
                if (n2 == 1) {
                    return this.getContentAsStringValue(iterator.get(0));
                }
                StringBuilder stringBuilder = new StringBuilder();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Object object = (Node)iterator.next();
                    if (((String)(object = this.getContentAsStringValue(object))).length() <= 0) continue;
                    stringBuilder.append((String)object);
                }
                return stringBuilder.toString();
            }
        } else if (iterator != null) {
            return this.getContentAsStringValue(iterator);
        }
        return "";
    }

    @Override
    public Object clone() {
        DefaultElement defaultElement = (DefaultElement)super.clone();
        if (defaultElement != this) {
            defaultElement.content = null;
            defaultElement.attributes = null;
            defaultElement.appendAttributes(this);
            defaultElement.appendContent(this);
        }
        return defaultElement;
    }

    @Override
    public Namespace getNamespaceForPrefix(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (string.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof Namespace) || !string.equals(((Namespace)(node = (Namespace)node)).getPrefix())) continue;
                return node;
            }
        } else if (iterator instanceof Namespace && string.equals(((Namespace)((Object)(iterator = (Namespace)((Object)iterator)))).getPrefix())) {
            return iterator;
        }
        if ((iterator = ((AbstractNode)this).getParent()) != null && (iterator = iterator.getNamespaceForPrefix(string)) != null) {
            return iterator;
        }
        if (string.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        return null;
    }

    @Override
    public Namespace getNamespaceForURI(String string) {
        if (string == null || string.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        if (string.equals(this.getNamespaceURI())) {
            return this.getNamespace();
        }
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof Namespace) || !string.equals(((Namespace)(node = (Namespace)node)).getURI())) continue;
                return node;
            }
        } else if (iterator instanceof Namespace && string.equals(((Namespace)((Object)(iterator = (Namespace)((Object)iterator)))).getURI())) {
            return iterator;
        }
        if ((iterator = ((AbstractNode)this).getParent()) != null) {
            return iterator.getNamespaceForURI(string);
        }
        return null;
    }

    @Override
    public List<Namespace> declaredNamespaces() {
        BackedList<Namespace> backedList = this.createResultList();
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof Namespace)) continue;
                backedList.addLocal((Namespace)node);
            }
        } else if (iterator instanceof Namespace) {
            backedList.addLocal((Namespace)((Object)iterator));
        }
        return backedList;
    }

    @Override
    public List<Namespace> additionalNamespaces() {
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            BackedList<Namespace> backedList = this.createResultList();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof Namespace) || ((Namespace)(node = (Namespace)node)).equals(this.getNamespace())) continue;
                backedList.addLocal((Namespace)node);
            }
            return backedList;
        }
        if (iterator instanceof Namespace) {
            if (((Namespace)((Object)(iterator = (Namespace)((Object)iterator)))).equals(this.getNamespace())) {
                return this.createEmptyList();
            }
            return this.createSingleResultList(iterator);
        }
        return this.createEmptyList();
    }

    @Override
    public List<Namespace> additionalNamespaces(String string) {
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            BackedList<Namespace> backedList = this.createResultList();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof Namespace) || string.equals(((Namespace)(node = (Namespace)node)).getURI())) continue;
                backedList.addLocal((Namespace)node);
            }
            return backedList;
        }
        if (iterator instanceof Namespace && !string.equals(((Namespace)((Object)(iterator = (Namespace)((Object)iterator)))).getURI())) {
            return this.createSingleResultList(iterator);
        }
        return this.createEmptyList();
    }

    @Override
    public List<ProcessingInstruction> processingInstructions() {
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            BackedList<ProcessingInstruction> backedList = this.createResultList();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof ProcessingInstruction)) continue;
                backedList.addLocal((ProcessingInstruction)node);
            }
            return backedList;
        }
        if (iterator instanceof ProcessingInstruction) {
            return this.createSingleResultList((ProcessingInstruction)((Object)iterator));
        }
        return this.createEmptyList();
    }

    @Override
    public List<ProcessingInstruction> processingInstructions(String string) {
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            BackedList<ProcessingInstruction> backedList = this.createResultList();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof ProcessingInstruction) || !string.equals((node = (ProcessingInstruction)node).getName())) continue;
                backedList.addLocal((ProcessingInstruction)node);
            }
            return backedList;
        }
        if (iterator instanceof ProcessingInstruction && string.equals((iterator = (ProcessingInstruction)((Object)iterator)).getName())) {
            return this.createSingleResultList(iterator);
        }
        return this.createEmptyList();
    }

    @Override
    public ProcessingInstruction processingInstruction(String string) {
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof ProcessingInstruction) || !string.equals((node = (ProcessingInstruction)node).getName())) continue;
                return node;
            }
        } else if (iterator instanceof ProcessingInstruction && string.equals((iterator = (ProcessingInstruction)((Object)iterator)).getName())) {
            return iterator;
        }
        return null;
    }

    @Override
    public boolean removeProcessingInstruction(String string) {
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof ProcessingInstruction) || !string.equals((node = (ProcessingInstruction)node).getName())) continue;
                iterator.remove();
                return true;
            }
        } else if (iterator instanceof ProcessingInstruction && string.equals((iterator = (ProcessingInstruction)((Object)iterator)).getName())) {
            this.content = null;
            return true;
        }
        return false;
    }

    @Override
    public Element element(String string) {
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof Element) || !string.equals((node = (Element)node).getName())) continue;
                return node;
            }
        } else if (iterator instanceof Element && string.equals((iterator = (Element)((Object)iterator)).getName())) {
            return iterator;
        }
        return null;
    }

    @Override
    public Element element(QName qName) {
        Iterator iterator = this.content;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof Element) || !qName.equals((node = (Element)node).getQName())) continue;
                return node;
            }
        } else if (iterator instanceof Element && qName.equals((iterator = (Element)((Object)iterator)).getQName())) {
            return iterator;
        }
        return null;
    }

    @Override
    public Element element(String string, Namespace namespace) {
        DefaultElement defaultElement = this;
        return ((AbstractElement)defaultElement).element(defaultElement.getDocumentFactory().createQName(string, namespace));
    }

    @Override
    public void setContent(List<Node> object) {
        this.contentRemoved();
        if (object instanceof ContentListFacade) {
            object = ((ContentListFacade)object).getBackingList();
        }
        if (object == null) {
            this.content = null;
            return;
        }
        int n2 = object.size();
        List<Node> list = this.createContentList(n2);
        object = object.iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            Element element = node.getParent();
            if (element != null && element != this) {
                node = (Node)node.clone();
            }
            list.add(node);
            this.childAdded(node);
        }
        this.content = list;
    }

    @Override
    public void clearContent() {
        if (this.content != null) {
            this.contentRemoved();
            this.content = null;
        }
    }

    @Override
    public Node node(int n2) {
        if (n2 >= 0) {
            Node node;
            Object object = this.content;
            if (object instanceof List) {
                if (n2 >= (object = (List)object).size()) {
                    return null;
                }
                node = (Node)object.get(n2);
            } else {
                node = n2 == 0 ? (Node)object : null;
            }
            Node node2 = node;
            return node;
        }
        return null;
    }

    @Override
    public int indexOf(Node node) {
        Object object = this.content;
        if (object instanceof List) {
            object = (List)object;
            return object.indexOf(node);
        }
        if (object != null && object.equals(node)) {
            return 0;
        }
        return -1;
    }

    @Override
    public int nodeCount() {
        Object object = this.content;
        if (object instanceof List) {
            object = (List)object;
            return object.size();
        }
        if (object != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public Iterator<Node> nodeIterator() {
        Object object = this.content;
        if (object instanceof List) {
            object = (List)object;
            return object.iterator();
        }
        if (object != null) {
            return this.createSingleIterator((Node)object);
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public List<Attribute> attributes() {
        DefaultElement defaultElement = this;
        return new ContentListFacade<Attribute>(defaultElement, defaultElement.attributeList());
    }

    @Override
    public void setAttributes(List<Attribute> list) {
        if (list instanceof ContentListFacade) {
            list = ((ContentListFacade)list).getBackingList();
        }
        this.attributes = list;
    }

    @Override
    public Iterator<Attribute> attributeIterator() {
        Object object = this.attributes;
        if (object instanceof List) {
            object = (List)object;
            return object.iterator();
        }
        if (object != null) {
            return this.createSingleIterator((Attribute)object);
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public Attribute attribute(int n2) {
        Object object = this.attributes;
        if (object instanceof List) {
            object = (List)object;
            return (Attribute)object.get(n2);
        }
        if (object != null && n2 == 0) {
            return (Attribute)object;
        }
        return null;
    }

    @Override
    public int attributeCount() {
        Object object = this.attributes;
        if (object instanceof List) {
            object = (List)object;
            return object.size();
        }
        if (object != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public Attribute attribute(String string) {
        Iterator iterator = this.attributes;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (!string.equals(attribute.getName())) continue;
                return attribute;
            }
        } else if (iterator != null && string.equals((iterator = (Attribute)((Object)iterator)).getName())) {
            return iterator;
        }
        return null;
    }

    @Override
    public Attribute attribute(QName qName) {
        Iterator iterator = this.attributes;
        if (iterator instanceof List) {
            iterator = (List)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (!qName.equals(attribute.getQName())) continue;
                return attribute;
            }
        } else if (iterator != null && qName.equals((iterator = (Attribute)((Object)iterator)).getQName())) {
            return iterator;
        }
        return null;
    }

    @Override
    public Attribute attribute(String string, Namespace namespace) {
        DefaultElement defaultElement = this;
        return ((AbstractElement)defaultElement).attribute(defaultElement.getDocumentFactory().createQName(string, namespace));
    }

    @Override
    public void add(Attribute attribute) {
        if (attribute.getParent() != null) {
            String string = "The Attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, (Node)attribute, string);
        }
        if (attribute.getValue() == null) {
            Attribute attribute2 = ((AbstractElement)this).attribute(attribute.getQName());
            if (attribute2 != null) {
                ((AbstractElement)this).remove(attribute2);
            }
            return;
        }
        if (this.attributes == null) {
            this.attributes = attribute;
        } else {
            this.attributeList().add(attribute);
        }
        this.childAdded(attribute);
    }

    @Override
    public boolean remove(Attribute attribute) {
        boolean bl = false;
        Object object = this.attributes;
        if (object instanceof List) {
            Attribute attribute2;
            bl = (object = (List)object).remove(attribute);
            if (!bl && (attribute2 = ((AbstractElement)this).attribute(attribute.getQName())) != null) {
                object.remove(attribute2);
                bl = true;
            }
        } else if (object != null) {
            if (attribute.equals(object)) {
                this.attributes = null;
                bl = true;
            } else {
                object = (Attribute)object;
                if (attribute.getQName().equals(object.getQName())) {
                    this.attributes = null;
                    bl = true;
                }
            }
        }
        if (bl) {
            this.childRemoved(attribute);
        }
        return bl;
    }

    @Override
    protected void addNewNode(Node node) {
        Object object = this.content;
        if (object == null) {
            this.content = node;
        } else if (object instanceof List) {
            List list = (List)object;
            list.add(node);
        } else {
            List<Node> list = this.createContentList();
            list.add((Node)object);
            list.add(node);
            this.content = list;
        }
        this.childAdded(node);
    }

    @Override
    public boolean removeNode(Node node) {
        boolean bl = false;
        Object object = this.content;
        if (object != null) {
            if (object == node) {
                this.content = null;
                bl = true;
            } else if (object instanceof List) {
                List list = (List)object;
                bl = list.remove(node);
            }
        }
        if (bl) {
            this.childRemoved(node);
        }
        return bl;
    }

    @Override
    protected List<Node> contentList() {
        Object object = this.content;
        if (object instanceof List) {
            return (List)object;
        }
        List<Node> list = this.createContentList();
        if (object != null) {
            list.add((Node)object);
        }
        this.content = list;
        return list;
    }

    @Override
    protected List<Attribute> attributeList() {
        List<Attribute> list;
        Object object = this.attributes;
        if (object instanceof List) {
            return (List)object;
        }
        if (object != null) {
            List<Attribute> list2 = this.createAttributeList();
            list2.add((Attribute)object);
            this.attributes = list2;
            return list2;
        }
        this.attributes = list = this.createAttributeList();
        return list;
    }

    @Override
    protected List<Attribute> attributeList(int n2) {
        List<Attribute> list;
        Object object = this.attributes;
        if (object instanceof List) {
            return (List)object;
        }
        if (object != null) {
            List<Attribute> list2 = this.createAttributeList(n2);
            list2.add((Attribute)object);
            this.attributes = list2;
            return list2;
        }
        this.attributes = list = this.createAttributeList(n2);
        return list;
    }

    protected void setAttributeList(List<Attribute> list) {
        this.attributes = list;
    }

    @Override
    protected DocumentFactory getDocumentFactory() {
        DocumentFactory documentFactory = this.qname.getDocumentFactory();
        if (documentFactory != null) {
            return documentFactory;
        }
        return DOCUMENT_FACTORY;
    }
}

