/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class FilterIterator<T>
implements Iterator<T> {
    protected Iterator<T> proxy;
    private T next;
    private boolean first = true;

    public FilterIterator(Iterator<T> iterator) {
        this.proxy = iterator;
    }

    @Override
    public boolean hasNext() {
        if (this.first) {
            this.next = this.findNext();
            this.first = false;
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T t2 = this.next;
        this.next = this.findNext();
        return t2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract boolean matches(T var1);

    protected T findNext() {
        if (this.proxy != null) {
            while (this.proxy.hasNext()) {
                T t2 = this.proxy.next();
                if (t2 == null || !this.matches(t2)) continue;
                return t2;
            }
            this.proxy = null;
        }
        return null;
    }
}

