/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class NamespaceStack {
    private DocumentFactory documentFactory;
    private ArrayList<Namespace> namespaceStack = new ArrayList();
    private ArrayList<Map<String, QName>> namespaceCacheList = new ArrayList();
    private Map<String, QName> currentNamespaceCache;
    private Map<String, QName> rootNamespaceCache = new HashMap<String, QName>();
    private Namespace defaultNamespace;

    public NamespaceStack() {
        this.documentFactory = DocumentFactory.getInstance();
    }

    public NamespaceStack(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public void push(Namespace namespace) {
        this.namespaceStack.add(namespace);
        this.namespaceCacheList.add(null);
        this.currentNamespaceCache = null;
        String string = namespace.getPrefix();
        if (string == null || string.length() == 0) {
            this.defaultNamespace = namespace;
        }
    }

    public Namespace pop() {
        NamespaceStack namespaceStack = this;
        return namespaceStack.remove(namespaceStack.namespaceStack.size() - 1);
    }

    public int size() {
        return this.namespaceStack.size();
    }

    public void clear() {
        this.namespaceStack.clear();
        this.namespaceCacheList.clear();
        this.rootNamespaceCache.clear();
        this.currentNamespaceCache = null;
    }

    public Namespace getNamespace(int n2) {
        return this.namespaceStack.get(n2);
    }

    public Namespace getNamespaceForPrefix(String string) {
        if (string == null) {
            string = "";
        }
        for (int i2 = this.namespaceStack.size() - 1; i2 >= 0; --i2) {
            Namespace namespace = this.namespaceStack.get(i2);
            if (!string.equals(namespace.getPrefix())) continue;
            return namespace;
        }
        return null;
    }

    public String getURI(String object) {
        if ((object = this.getNamespaceForPrefix((String)object)) != null) {
            return ((Namespace)object).getURI();
        }
        return null;
    }

    public boolean contains(Namespace namespace) {
        Object object = namespace.getPrefix();
        object = object == null || ((String)object).length() == 0 ? this.getDefaultNamespace() : this.getNamespaceForPrefix((String)object);
        if (object == null) {
            return false;
        }
        if (object == namespace) {
            return true;
        }
        return namespace.getURI().equals(((Namespace)object).getURI());
    }

    public QName getQName(String object, String string, String string2) {
        if (string == null) {
            string = string2;
        } else if (string2 == null) {
            string2 = string;
        }
        if (object == null) {
            object = "";
        }
        String string3 = "";
        int n2 = string2.indexOf(":");
        if (n2 > 0) {
            string3 = string2.substring(0, n2);
            if (string.trim().length() == 0) {
                string = string2.substring(n2 + 1);
            }
        } else if (string.trim().length() == 0) {
            string = string2;
        }
        object = this.createNamespace(string3, (String)object);
        return this.pushQName(string, string2, (Namespace)object, string3);
    }

    public QName getAttributeQName(String object, String string, String string2) {
        Map<String, QName> map;
        Object object2;
        if (string2 == null) {
            string2 = string;
        }
        if ((object2 = (map = this.getNamespaceCache()).get(string2)) != null) {
            return object2;
        }
        if (string == null) {
            string = string2;
        }
        if (object == null) {
            object = "";
        }
        object2 = "";
        int n2 = string2.indexOf(":");
        if (n2 > 0) {
            object2 = string2.substring(0, n2);
            object = this.createNamespace((String)object2, (String)object);
            if (string.trim().length() == 0) {
                string = string2.substring(n2 + 1);
            }
        } else {
            object = Namespace.NO_NAMESPACE;
            if (string.trim().length() == 0) {
                string = string2;
            }
        }
        object2 = this.pushQName(string, string2, (Namespace)object, (String)object2);
        map.put(string2, (QName)object2);
        return object2;
    }

    public void push(String object, String string) {
        if (string == null) {
            string = "";
        }
        object = this.createNamespace((String)object, string);
        this.push((Namespace)object);
    }

    public Namespace addNamespace(String object, String string) {
        object = this.createNamespace((String)object, string);
        this.push((Namespace)object);
        return object;
    }

    public Namespace pop(String string) {
        if (string == null) {
            string = "";
        }
        Namespace namespace = null;
        for (int i2 = this.namespaceStack.size() - 1; i2 >= 0; --i2) {
            Namespace namespace2 = this.namespaceStack.get(i2);
            if (!string.equals(namespace2.getPrefix())) continue;
            this.remove(i2);
            namespace = namespace2;
            break;
        }
        if (namespace == null) {
            System.out.println("Warning: missing namespace prefix ignored: " + string);
        }
        return namespace;
    }

    public String toString() {
        return super.toString() + " Stack: " + this.namespaceStack.toString();
    }

    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public Namespace getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            this.defaultNamespace = this.findDefaultNamespace();
        }
        return this.defaultNamespace;
    }

    protected QName pushQName(String string, String string2, Namespace namespace, String string3) {
        if (string3 == null || string3.length() == 0) {
            this.defaultNamespace = null;
        }
        return this.createQName(string, string2, namespace);
    }

    protected QName createQName(String string, String string2, Namespace namespace) {
        return this.documentFactory.createQName(string, namespace);
    }

    protected Namespace createNamespace(String string, String string2) {
        return this.documentFactory.createNamespace(string, string2);
    }

    protected Namespace findDefaultNamespace() {
        for (int i2 = this.namespaceStack.size() - 1; i2 >= 0; --i2) {
            String string;
            Namespace namespace = this.namespaceStack.get(i2);
            if (namespace == null || (string = namespace.getPrefix()) != null && namespace.getPrefix().length() != 0) continue;
            return namespace;
        }
        return null;
    }

    protected Namespace remove(int n2) {
        Namespace namespace = this.namespaceStack.remove(n2);
        this.namespaceCacheList.remove(n2);
        this.defaultNamespace = null;
        this.currentNamespaceCache = null;
        return namespace;
    }

    protected Map<String, QName> getNamespaceCache() {
        if (this.currentNamespaceCache == null) {
            int n2 = this.namespaceStack.size() - 1;
            if (n2 < 0) {
                this.currentNamespaceCache = this.rootNamespaceCache;
            } else {
                this.currentNamespaceCache = this.namespaceCacheList.get(n2);
                if (this.currentNamespaceCache == null) {
                    this.currentNamespaceCache = new HashMap<String, QName>();
                    this.namespaceCacheList.set(n2, this.currentNamespaceCache);
                }
            }
        }
        return this.currentNamespaceCache;
    }
}

