/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class QNameCache {
    protected Map<String, QName> noNamespaceCache = Collections.synchronizedMap(new WeakHashMap());
    protected Map<Namespace, Map<String, QName>> namespaceCache = Collections.synchronizedMap(new WeakHashMap());
    private DocumentFactory documentFactory;

    public QNameCache() {
    }

    public QNameCache(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public List<QName> getQNames() {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        Map<Object, Object> map = this.noNamespaceCache;
        synchronized (map) {
            arrayList.addAll(this.noNamespaceCache.values());
        }
        map = this.namespaceCache;
        synchronized (map) {
            for (Map<String, QName> map2 : this.namespaceCache.values()) {
                arrayList.addAll(map2.values());
            }
        }
        return arrayList;
    }

    public QName get(String string) {
        QName qName = null;
        if (string != null) {
            qName = this.noNamespaceCache.get(string);
        } else {
            string = "";
        }
        if (qName == null) {
            qName = this.createQName(string);
            qName.setDocumentFactory(this.documentFactory);
            this.noNamespaceCache.put(string, qName);
        }
        return qName;
    }

    public QName get(String string, Namespace namespace) {
        Map<String, QName> map = this.getNamespaceCache(namespace);
        QName qName = null;
        if (string != null) {
            qName = map.get(string);
        } else {
            string = "";
        }
        if (qName == null) {
            qName = this.createQName(string, namespace);
            qName.setDocumentFactory(this.documentFactory);
            map.put(string, qName);
        }
        return qName;
    }

    public QName get(String string, Namespace namespace, String string2) {
        Map<String, QName> map = this.getNamespaceCache(namespace);
        QName qName = null;
        if (string != null) {
            qName = map.get(string);
        } else {
            string = "";
        }
        if (qName == null) {
            qName = this.createQName(string, namespace, string2);
            qName.setDocumentFactory(this.documentFactory);
            map.put(string, qName);
        }
        return qName;
    }

    public QName get(String string, String string2) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return this.get(string, Namespace.get(string2));
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("Qualified name cannot start with ':'.");
        }
        String string3 = string.substring(n2 + 1);
        string = string.substring(0, n2);
        return this.get(string3, Namespace.get(string, string2));
    }

    public QName intern(QName qName) {
        return this.get(qName.getName(), qName.getNamespace(), qName.getQualifiedName());
    }

    protected Map<String, QName> getNamespaceCache(Namespace namespace) {
        if (namespace == Namespace.NO_NAMESPACE) {
            return this.noNamespaceCache;
        }
        Map<String, QName> map = null;
        if (namespace != null) {
            map = this.namespaceCache.get(namespace);
        }
        if (map == null) {
            map = this.createMap();
            this.namespaceCache.put(namespace, map);
        }
        return map;
    }

    protected Map<String, QName> createMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    protected QName createQName(String string) {
        return new QName(string);
    }

    protected QName createQName(String string, Namespace namespace) {
        return new QName(string, namespace);
    }

    protected QName createQName(String string, Namespace namespace, String string2) {
        return new QName(string, namespace, string2);
    }
}

