/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.DefaultElement;

public class IndexedElement
extends DefaultElement {
    private Map<Object, Object> elementIndex;
    private Map<Object, Attribute> attributeIndex;

    public IndexedElement(String string) {
        super(string);
    }

    public IndexedElement(QName qName) {
        super(qName);
    }

    public IndexedElement(QName qName, int n2) {
        super(qName, n2);
    }

    @Override
    public Attribute attribute(String string) {
        return this.attributeIndex().get(string);
    }

    @Override
    public Attribute attribute(QName qName) {
        return this.attributeIndex().get(qName);
    }

    @Override
    public Element element(String string) {
        IndexedElement indexedElement = this;
        return indexedElement.asElement(indexedElement.elementIndex().get(string));
    }

    @Override
    public Element element(QName qName) {
        IndexedElement indexedElement = this;
        return indexedElement.asElement(indexedElement.elementIndex().get(qName));
    }

    @Override
    public List<Element> elements(String string) {
        IndexedElement indexedElement = this;
        return indexedElement.asElementList(indexedElement.elementIndex().get(string));
    }

    @Override
    public List<Element> elements(QName qName) {
        IndexedElement indexedElement = this;
        return indexedElement.asElementList(indexedElement.elementIndex().get(qName));
    }

    protected Element asElement(Object object) {
        if (object instanceof Element) {
            return (Element)object;
        }
        if (object != null && (object = (List)object).size() > 0) {
            return (Element)object.get(0);
        }
        return null;
    }

    protected List<Element> asElementList(Object iterator) {
        if (iterator instanceof Element) {
            return this.createSingleResultList((Element)((Object)iterator));
        }
        if (iterator != null) {
            iterator = (List)((Object)iterator);
            BackedList<Element> backedList = this.createResultList();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                backedList.addLocal(element);
            }
            return backedList;
        }
        return this.createEmptyList();
    }

    protected Iterator<Element> asElementIterator(Object object) {
        return this.asElementList(object).iterator();
    }

    @Override
    public void addNode(Node node) {
        super.addNode(node);
        if (this.elementIndex != null && node instanceof Element) {
            this.addToElementIndex((Element)node);
            return;
        }
        if (this.attributeIndex != null && node instanceof Attribute) {
            this.addToAttributeIndex((Attribute)node);
        }
    }

    @Override
    public boolean removeNode(Node node) {
        if (super.removeNode(node)) {
            if (this.elementIndex != null && node instanceof Element) {
                this.removeFromElementIndex((Element)node);
            } else if (this.attributeIndex != null && node instanceof Attribute) {
                this.removeFromAttributeIndex((Attribute)node);
            }
            return true;
        }
        return false;
    }

    protected Map<Object, Attribute> attributeIndex() {
        if (this.attributeIndex == null) {
            this.attributeIndex = this.createAttributeIndex();
            Iterator<Attribute> iterator = ((AbstractElement)this).attributeIterator();
            while (iterator.hasNext()) {
                this.addToAttributeIndex(iterator.next());
            }
        }
        return this.attributeIndex;
    }

    protected Map<Object, Object> elementIndex() {
        if (this.elementIndex == null) {
            this.elementIndex = this.createElementIndex();
            Iterator<Element> iterator = this.elementIterator();
            while (iterator.hasNext()) {
                this.addToElementIndex(iterator.next());
            }
        }
        return this.elementIndex;
    }

    protected Map<Object, Attribute> createAttributeIndex() {
        return this.createIndex();
    }

    protected Map<Object, Object> createElementIndex() {
        return this.createIndex();
    }

    protected void addToElementIndex(Element element) {
        QName qName = element.getQName();
        String string = qName.getName();
        this.addToElementIndex(qName, element);
        this.addToElementIndex(string, element);
    }

    protected void addToElementIndex(Object object, Element element) {
        Object object2 = this.elementIndex.get(object);
        if (object2 == null) {
            this.elementIndex.put(object, element);
            return;
        }
        if (object2 instanceof List) {
            List list = (List)object2;
            list.add(element);
            return;
        }
        List list = this.createList();
        list.add((Element)object2);
        list.add(element);
        this.elementIndex.put(object, list);
    }

    protected void removeFromElementIndex(Element element) {
        QName qName = element.getQName();
        String string = qName.getName();
        this.removeFromElementIndex(qName, element);
        this.removeFromElementIndex(string, element);
    }

    protected void removeFromElementIndex(Object object, Element element) {
        Object object2 = this.elementIndex.get(object);
        if (object2 instanceof List) {
            object = (List)object2;
            object.remove(element);
            return;
        }
        this.elementIndex.remove(object);
    }

    protected void addToAttributeIndex(Attribute attribute) {
        QName qName = attribute.getQName();
        String string = qName.getName();
        this.addToAttributeIndex(qName, attribute);
        this.addToAttributeIndex(string, attribute);
    }

    protected void addToAttributeIndex(Object object, Attribute attribute) {
        Attribute attribute2 = this.attributeIndex.get(object);
        if (attribute2 != null) {
            this.attributeIndex.put(object, attribute);
        }
    }

    protected void removeFromAttributeIndex(Attribute attribute) {
        QName qName = attribute.getQName();
        String string = qName.getName();
        this.removeFromAttributeIndex(qName, attribute);
        this.removeFromAttributeIndex(string, attribute);
    }

    protected void removeFromAttributeIndex(Object object, Attribute attribute) {
        Attribute attribute2 = this.attributeIndex.get(object);
        if (attribute2 != null && attribute2.equals(attribute)) {
            this.attributeIndex.remove(object);
        }
    }

    protected <T> Map<Object, T> createIndex() {
        return new HashMap();
    }

    protected <T extends Node> List<T> createList() {
        return new ArrayList();
    }
}

