/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.util;

import java.util.Comparator;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;

public class NodeComparator
implements Comparator<Node> {
    @Override
    public int compare(Node node, Node node2) {
        short s2 = node.getNodeType();
        int n2 = node2.getNodeType();
        if ((n2 = s2 - n2) != 0) {
            return n2;
        }
        switch (s2) {
            case 1: {
                return this.compare((Element)node, (Element)node2);
            }
            case 9: {
                return this.compare((Document)node, (Document)node2);
            }
            case 2: {
                return this.compare((Attribute)node, (Attribute)node2);
            }
            case 3: {
                return this.compare((Text)node, (Text)node2);
            }
            case 4: {
                return this.compare((CDATA)node, (CDATA)node2);
            }
            case 5: {
                return this.compare((Entity)node, (Entity)node2);
            }
            case 7: {
                return this.compare((ProcessingInstruction)node, (ProcessingInstruction)node2);
            }
            case 8: {
                return this.compare((Comment)node, (Comment)node2);
            }
            case 10: {
                return this.compare((DocumentType)node, (DocumentType)node2);
            }
            case 13: {
                return this.compare((Namespace)node, (Namespace)node2);
            }
        }
        throw new RuntimeException("Invalid node types. node1: " + node + " and node2: " + node2);
    }

    @Override
    public int compare(Document document, Document document2) {
        int n2 = this.compare(document.getDocType(), document2.getDocType());
        if (n2 == 0) {
            n2 = this.compareContent(document, document2);
        }
        return n2;
    }

    @Override
    public int compare(Element element, Element element2) {
        int n2 = this.compare(element.getQName(), element2.getQName());
        if (n2 == 0) {
            int n3 = element.attributeCount();
            n2 = element2.attributeCount();
            if ((n2 = n3 - n2) == 0) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    Attribute attribute;
                    Attribute attribute2 = element.attribute(i2);
                    n2 = this.compare(attribute2, attribute = element2.attribute(attribute2.getQName()));
                    if (n2 == 0) continue;
                    return n2;
                }
                n2 = this.compareContent(element, element2);
            }
        }
        return n2;
    }

    @Override
    public int compare(Attribute attribute, Attribute attribute2) {
        int n2 = this.compare(attribute.getQName(), attribute2.getQName());
        if (n2 == 0) {
            n2 = this.compare(attribute.getValue(), attribute2.getValue());
        }
        return n2;
    }

    @Override
    public int compare(QName qName, QName qName2) {
        int n2 = this.compare(qName.getNamespaceURI(), qName2.getNamespaceURI());
        if (n2 == 0) {
            n2 = this.compare(qName.getQualifiedName(), qName2.getQualifiedName());
        }
        return n2;
    }

    @Override
    public int compare(Namespace namespace, Namespace namespace2) {
        int n2 = this.compare(namespace.getURI(), namespace2.getURI());
        if (n2 == 0) {
            n2 = this.compare(namespace.getPrefix(), namespace2.getPrefix());
        }
        return n2;
    }

    @Override
    public int compare(CharacterData characterData, CharacterData characterData2) {
        return this.compare(characterData.getText(), characterData2.getText());
    }

    @Override
    public int compare(DocumentType documentType, DocumentType documentType2) {
        if (documentType == documentType2) {
            return 0;
        }
        if (documentType == null) {
            return -1;
        }
        if (documentType2 == null) {
            return 1;
        }
        int n2 = this.compare(documentType.getPublicID(), documentType2.getPublicID());
        if (n2 == 0 && (n2 = this.compare(documentType.getSystemID(), documentType2.getSystemID())) == 0) {
            n2 = this.compare(documentType.getName(), documentType2.getName());
        }
        return n2;
    }

    @Override
    public int compare(Entity entity, Entity entity2) {
        int n2 = this.compare(entity.getName(), entity2.getName());
        if (n2 == 0) {
            n2 = this.compare(entity.getText(), entity2.getText());
        }
        return n2;
    }

    @Override
    public int compare(ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        int n2 = this.compare(processingInstruction.getTarget(), processingInstruction2.getTarget());
        if (n2 == 0) {
            n2 = this.compare(processingInstruction.getText(), processingInstruction2.getText());
        }
        return n2;
    }

    public int compareContent(Branch branch, Branch branch2) {
        int n2 = branch.nodeCount();
        int n3 = branch2.nodeCount();
        if ((n3 = n2 - n3) == 0) {
            Node node;
            Node node2;
            for (int i2 = 0; i2 < n2 && (n3 = this.compare(node2 = branch.node(i2), node = branch2.node(i2))) == 0; ++i2) {
            }
        }
        return n3;
    }

    @Override
    public int compare(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }
}

