/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpath;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.InvalidXPathException;
import org.dom4j.Node;
import org.dom4j.NodeFilter;
import org.dom4j.XPath;
import org.dom4j.XPathException;
import org.dom4j.xpath.DefaultNamespaceContext;
import org.dom4j.xpath.DefaultXPath$1;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.VariableContext;
import org.jaxen.dom4j.Dom4jXPath;

public class DefaultXPath
implements Serializable,
NodeFilter,
XPath {
    private String text;
    private org.jaxen.XPath xpath;
    private NamespaceContext namespaceContext;

    public DefaultXPath(String string) {
        this.text = string;
        this.xpath = DefaultXPath.parse(string);
    }

    public String toString() {
        return "[XPath: " + this.xpath + "]";
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public FunctionContext getFunctionContext() {
        return this.xpath.getFunctionContext();
    }

    @Override
    public void setFunctionContext(FunctionContext functionContext) {
        this.xpath.setFunctionContext(functionContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public void setNamespaceURIs(Map<String, String> map) {
        this.setNamespaceContext(new SimpleNamespaceContext(map));
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
        this.xpath.setNamespaceContext(namespaceContext);
    }

    @Override
    public VariableContext getVariableContext() {
        return this.xpath.getVariableContext();
    }

    @Override
    public void setVariableContext(VariableContext variableContext) {
        this.xpath.setVariableContext(variableContext);
    }

    @Override
    public Object evaluate(Object object) {
        try {
            this.setNSContext(object);
            object = this.xpath.selectNodes(object);
            if (object != null && object.size() == 1) {
                return object.get(0);
            }
            return object;
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return null;
        }
    }

    @Override
    public Object selectObject(Object object) {
        return this.evaluate(object);
    }

    @Override
    public List<Node> selectNodes(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.selectNodes(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Node> selectNodes(Object list, XPath xPath) {
        list = this.selectNodes(list);
        xPath.sort(list);
        return list;
    }

    @Override
    public List<Node> selectNodes(Object list, XPath xPath, boolean bl) {
        list = this.selectNodes(list);
        xPath.sort(list, bl);
        return list;
    }

    @Override
    public Node selectSingleNode(Object object) {
        block4: {
            try {
                this.setNSContext(object);
                object = this.xpath.selectSingleNode(object);
                if (object instanceof Node) {
                    return (Node)object;
                }
                if (object != null) break block4;
                return null;
            }
            catch (JaxenException jaxenException) {
                this.handleJaxenException(jaxenException);
                return null;
            }
        }
        throw new XPathException("The result of the XPath expression is not a Node. It was: " + object + " of type: " + object.getClass().getName());
    }

    @Override
    public String valueOf(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.stringValueOf(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return "";
        }
    }

    @Override
    public Number numberValueOf(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.numberValueOf(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return null;
        }
    }

    @Override
    public boolean booleanValueOf(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.booleanValueOf(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return false;
        }
    }

    @Override
    public void sort(List<Node> list) {
        this.sort(list, false);
    }

    @Override
    public void sort(List<Node> list, boolean bl) {
        if (list != null && !list.isEmpty()) {
            int n2 = list.size();
            HashMap<Node, Object> hashMap = new HashMap<Node, Object>(n2);
            for (Node node : list) {
                Object object = this.getCompareValue(node);
                hashMap.put(node, object);
            }
            this.sort(list, hashMap);
            if (bl) {
                this.removeDuplicates(list, hashMap);
            }
        }
    }

    @Override
    public boolean matches(Node node) {
        try {
            this.setNSContext(node);
            List list = this.xpath.selectNodes(node);
            if (list != null && list.size() > 0) {
                Object e2 = list.get(0);
                if (e2 instanceof Boolean) {
                    return (Boolean)e2;
                }
                return list.contains(node);
            }
            return false;
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return false;
        }
    }

    protected void sort(List<Node> list, Map<Node, Object> map) {
        Collections.sort(list, new DefaultXPath$1(this, map));
    }

    protected void removeDuplicates(List<Node> object, Map<Node, Object> map) {
        HashSet<Object> hashSet = new HashSet<Object>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Node)object.next();
            if (hashSet.contains(object2 = map.get(object2))) {
                object.remove();
                continue;
            }
            hashSet.add(object2);
        }
    }

    protected Object getCompareValue(Node node) {
        return this.valueOf(node);
    }

    protected static org.jaxen.XPath parse(String string) {
        try {
            return new Dom4jXPath(string);
        }
        catch (JaxenException jaxenException) {
            throw new InvalidXPathException(string, jaxenException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidXPathException(string);
        }
    }

    protected void setNSContext(Object object) {
        if (this.namespaceContext == null) {
            this.xpath.setNamespaceContext(DefaultNamespaceContext.create(object));
        }
    }

    protected void handleJaxenException(JaxenException jaxenException) {
        throw new XPathException(this.text, jaxenException);
    }
}

