/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpath;

import java.util.Collections;
import org.dom4j.InvalidXPathException;
import org.dom4j.Node;
import org.dom4j.XPathException;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom4j.DocumentNavigator;
import org.jaxen.pattern.Pattern;
import org.jaxen.pattern.PatternParser;
import org.jaxen.saxpath.SAXPathException;

public class XPathPattern
implements org.dom4j.rule.Pattern {
    private String text;
    private Pattern pattern;
    private Context context;

    public XPathPattern(Pattern pattern) {
        this.pattern = pattern;
        this.text = pattern.getText();
        this.context = new Context(this.getContextSupport());
    }

    public XPathPattern(String string) {
        this.text = string;
        this.context = new Context(this.getContextSupport());
        try {
            this.pattern = PatternParser.parse(string);
            return;
        }
        catch (SAXPathException sAXPathException) {
            throw new InvalidXPathException(string, sAXPathException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidXPathException(string);
        }
    }

    @Override
    public boolean matches(Node node) {
        try {
            this.context.setNodeSet(Collections.singletonList(node));
            return this.pattern.matches(node, this.context);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return false;
        }
    }

    public String getText() {
        return this.text;
    }

    @Override
    public double getPriority() {
        return this.pattern.getPriority();
    }

    @Override
    public org.dom4j.rule.Pattern[] getUnionPatterns() {
        Pattern[] patternArray = this.pattern.getUnionPatterns();
        if (patternArray != null) {
            int n2 = patternArray.length;
            org.dom4j.rule.Pattern[] patternArray2 = new XPathPattern[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                patternArray2[i2] = new XPathPattern(patternArray[i2]);
            }
            return patternArray2;
        }
        return null;
    }

    @Override
    public short getMatchType() {
        return this.pattern.getMatchType();
    }

    @Override
    public String getMatchesNodeName() {
        return this.pattern.getMatchesNodeName();
    }

    public void setVariableContext(VariableContext variableContext) {
        this.context.getContextSupport().setVariableContext(variableContext);
    }

    public String toString() {
        return "[XPathPattern: text: " + this.text + " Pattern: " + this.pattern + "]";
    }

    protected ContextSupport getContextSupport() {
        return new ContextSupport(new SimpleNamespaceContext(), XPathFunctionContext.getInstance(), new SimpleVariableContext(), DocumentNavigator.getInstance());
    }

    protected void handleJaxenException(JaxenException jaxenException) {
        throw new XPathException(this.text, jaxenException);
    }
}

