/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.format;

import java.io.Writer;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlNode;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlRecorder;
import org.gjt.xpp.XmlStartTag;
import org.gjt.xpp.XmlWritable;

public class Recorder
implements XmlRecorder {
    protected String[] declaredPrefixes;
    protected String[] declaredNs;
    protected Writer out;

    public Writer getOutput() {
        return this.out;
    }

    public void setOutput(Writer writer) {
        this.out = writer;
    }

    public void write(Object object) {
        if (object instanceof XmlNode) {
            this.writeNode((XmlNode)object);
            return;
        }
        if (object instanceof XmlStartTag) {
            this.writeStartTag((XmlStartTag)object);
            return;
        }
        if (object instanceof XmlEndTag) {
            this.writeEndTag((XmlEndTag)object);
            return;
        }
        if (object instanceof XmlWritable) {
            ((XmlWritable)object).writeXml(this.out);
            return;
        }
        if (object != null) {
            this.writeContent(object.toString());
        }
    }

    public void writeXml(XmlWritable xmlWritable) {
        xmlWritable.writeXml(this.out);
    }

    public void writeContent(String string) {
        if (string == null) {
            throw new XmlPullParserException("null string can not be written as XML element content");
        }
        this.writeEscaped(string, false);
    }

    public void writeEndTag(XmlEndTag xmlEndTag) {
        if (xmlEndTag.getRawName() == null) {
            throw new XmlPullParserException("raw name of XML element can not be null");
        }
        this.out.write("</");
        this.out.write(xmlEndTag.getRawName());
        this.out.write(62);
    }

    public void writeStartTag(XmlStartTag xmlStartTag) {
        this.writeStartTagStart(xmlStartTag);
        this.out.write(62);
    }

    public void writeStartTagStart(XmlStartTag xmlStartTag) {
        if (xmlStartTag.getRawName() == null) {
            throw new XmlPullParserException("raw name of XML element can not be null");
        }
        this.out.write(60);
        this.out.write(xmlStartTag.getRawName());
        int n2 = 0;
        while (n2 < xmlStartTag.getAttributeCount()) {
            if (!xmlStartTag.isAttributeNamespaceDeclaration(n2)) {
                this.out.write(32);
                this.out.write(xmlStartTag.getAttributeRawName(n2));
                this.out.write("='");
                this.writeEscaped(xmlStartTag.getAttributeValue(n2), true);
                this.out.write(39);
            }
            ++n2;
        }
    }

    public void writeStartTagAsEndTag(XmlStartTag xmlStartTag) {
        if (xmlStartTag.getRawName() == null) {
            throw new XmlPullParserException("raw name of XML end tag can not be null");
        }
        this.out.write("</");
        this.out.write(xmlStartTag.getRawName());
        this.out.write(62);
    }

    public void writeNode(XmlNode xmlNode) {
        String string;
        int n2;
        String[] stringArray;
        this.writeStartTagStart(xmlNode);
        int n3 = xmlNode.getDeclaredNamespaceLength();
        if (n3 > 0) {
            if (this.declaredNs == null || n3 > this.declaredNs.length) {
                int n4 = n3 + 10;
                stringArray = new String[n4];
                String[] stringArray2 = new String[n4];
                n2 = this.declaredNs != null ? this.declaredNs.length : 0;
                int n5 = 0;
                while (n5 < n2) {
                    stringArray[n5] = this.declaredPrefixes[n5];
                    stringArray2[n5] = this.declaredNs[n5];
                    ++n5;
                }
                this.declaredPrefixes = stringArray;
                this.declaredNs = stringArray2;
            }
            xmlNode.readDeclaredPrefixes(this.declaredPrefixes, 0, n3);
            xmlNode.readDeclaredNamespaceUris(this.declaredNs, 0, n3);
            int n6 = 0;
            while (n6 < n3) {
                this.out.write(" xmlns:");
                this.out.write(this.declaredPrefixes[n6]);
                this.out.write("='");
                Recorder recorder = this;
                recorder.writeEscaped(recorder.declaredNs[n6], true);
                this.out.write(39);
                ++n6;
            }
        }
        if ((string = xmlNode.getDefaultNamespaceUri()) != null && ((stringArray = xmlNode.getParentNode()) != null && !string.equals(stringArray.getDefaultNamespaceUri()) || stringArray == null && !"".equals(string))) {
            this.out.write(" xmlns='");
            this.writeEscaped(string, true);
            this.out.write(39);
        }
        boolean bl = false;
        int n7 = xmlNode.getChildrenCount();
        n2 = 0;
        while (n2 < n7) {
            Object object = xmlNode.getChildAt(n2);
            if (object != null) {
                if (!bl) {
                    bl = true;
                    this.out.write(62);
                }
                this.write(object);
            }
            ++n2;
        }
        if (bl) {
            this.writeStartTagAsEndTag(xmlNode);
            return;
        }
        this.out.write("/>");
    }

    protected void writeEscaped(String string, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        while (n3 < n4) {
            char c2 = string.charAt(n3);
            switch (c2) {
                case '<': {
                    if (n3 > n2) {
                        this.out.write(string, n2, n3 - n2);
                    }
                    n2 = n3 + 1;
                    this.out.write("&lt;");
                    break;
                }
                case '\r': {
                    if (n3 > n2) {
                        this.out.write(string, n2, n3 - n2);
                    }
                    n2 = n3 + 1;
                    this.out.write("&#xD;");
                    break;
                }
                case '&': {
                    if (n3 > n2) {
                        this.out.write(string, n2, n3 - n2);
                    }
                    n2 = n3 + 1;
                    this.out.write("&amp;");
                    break;
                }
                case '\t': {
                    if (!bl) break;
                    if (n3 > n2) {
                        this.out.write(string, n2, n3 - n2);
                    }
                    n2 = n3 + 1;
                    this.out.write("&#x9;");
                    break;
                }
                case '\n': {
                    if (!bl) break;
                    if (n3 > n2) {
                        this.out.write(string, n2, n3 - n2);
                    }
                    n2 = n3 + 1;
                    this.out.write("&#xA;");
                    break;
                }
                case '\'': {
                    if (!bl) break;
                    if (n3 > n2) {
                        this.out.write(string, n2, n3 - n2);
                    }
                    n2 = n3 + 1;
                    this.out.write("&apos;");
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            this.out.write(string);
            return;
        }
        this.out.write(string, n2, n3 - n2);
    }
}

