/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.node;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.gjt.xpp.XmlNode;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.impl.node.EmptyEnumerator;
import org.gjt.xpp.impl.node.OneChildEnumerator;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;
import org.gjt.xpp.impl.tag.StartTag;

public class Node
extends StartTag
implements XmlNode {
    protected static final Enumeration EMPTY_ENUMERATION = new EmptyEnumerator();
    protected Vector children;
    public int childrenCount;
    protected Object oneChild;
    protected XmlNode parent;
    protected String defaultNamespaceUri;
    protected Hashtable prefix2Ns;
    protected int declaredNsEnd;
    protected String[] declaredNs;
    protected String[] declaredPrefixes;

    public void resetNode() {
        super.resetStartTag();
        this.parent = null;
        this.childrenCount = 0;
        this.oneChild = null;
        if (this.children != null) {
            this.children.removeAllElements();
        }
        this.removeDeclaredNamespaces();
    }

    public XmlNode newNode() {
        return new Node();
    }

    public XmlNode newNode(String string, String string2) {
        Node node = new Node();
        String string3 = this.namespace2Prefix(string);
        if (string3 == null) {
            throw new XmlPullParserException("namespace '" + string + "' has no prefix declared in node tree");
        }
        node.modifyTag(string, string2, "".equals(string3) ? string2 : string3 + ':' + string2);
        return node;
    }

    public XmlNode getParentNode() {
        return this.parent;
    }

    public Enumeration children() {
        if (this.childrenCount == 0) {
            return EMPTY_ENUMERATION;
        }
        if (this.childrenCount == 1) {
            return new OneChildEnumerator(this.oneChild);
        }
        return this.children.elements();
    }

    public int getChildrenCount() {
        return this.childrenCount;
    }

    public Object getChildAt(int n2) {
        if (this.childrenCount > 0) {
            if (this.childrenCount == 1) {
                return this.oneChild;
            }
            if (n2 < this.childrenCount) {
                return this.children.elementAt(n2);
            }
            throw new IllegalArgumentException("no child at position " + n2);
        }
        throw new IllegalArgumentException("this node has no children");
    }

    public void setParentNode(XmlNode xmlNode) {
        this.parent = xmlNode;
    }

    public void appendChild(Object object) {
        if (this.childrenCount == 0) {
            this.oneChild = object;
        } else {
            if (this.children == null) {
                this.children = new Vector(4, 4);
            }
            if (this.childrenCount == 1) {
                if (this.children.size() > 0) {
                    this.children.removeAllElements();
                }
                this.children.addElement(this.oneChild);
            }
            this.children.addElement(object);
        }
        if (object instanceof XmlNode) {
            ((XmlNode)object).setParentNode(this);
        }
        ++this.childrenCount;
    }

    public void insertChildAt(int n2, Object object) {
        if (this.childrenCount == 0) {
            if (n2 != 0) {
                throw new XmlPullParserException("to insert first child position must be 0 not " + n2);
            }
            this.oneChild = object;
        } else {
            if (this.children == null) {
                this.children = new Vector(4, 4);
            }
            if (this.childrenCount == 1) {
                if (this.children.size() > 0) {
                    this.children.removeAllElements();
                }
                this.children.addElement(this.oneChild);
            }
            this.children.insertElementAt(object, n2);
        }
        if (object instanceof XmlNode) {
            ((XmlNode)object).setParentNode(this);
        }
        ++this.childrenCount;
    }

    public void removeChildAt(int n2) {
        Object object;
        if (this.childrenCount == 0) {
            throw new XmlPullParserException("node has no children to remove");
        }
        if (this.childrenCount == 1) {
            if (n2 != 0) {
                throw new XmlPullParserException("to remove last child position must be 0 not " + n2);
            }
            object = this.oneChild;
            this.oneChild = null;
        } else if (this.childrenCount == 2) {
            if (n2 == 0) {
                this.oneChild = this.children.elementAt(1);
                object = this.children.elementAt(0);
            } else if (n2 == 1) {
                this.oneChild = this.children.elementAt(0);
                object = this.children.elementAt(1);
            } else {
                throw new XmlPullParserException("only two children position must 0 or 1 but not " + n2);
            }
            this.children.removeAllElements();
        } else {
            object = this.children.elementAt(n2);
            this.children.removeElementAt(n2);
        }
        if (object instanceof XmlNode) {
            ((XmlNode)object).setParentNode(null);
        }
        --this.childrenCount;
    }

    public void replaceChildAt(int n2, Object object) {
        if (this.childrenCount == 1) {
            if (n2 != 0) {
                throw new XmlPullParserException("to set first child position must be 0 not " + n2);
            }
            this.oneChild = object;
        } else if (this.childrenCount > 1) {
            this.children.setElementAt(object, n2);
        } else {
            throw new XmlPullParserException("node must have at least one children to set child at " + n2);
        }
        if (object instanceof XmlNode) {
            ((XmlNode)object).setParentNode(this);
        }
    }

    public void ensureChildrenCapacity(int n2) {
        if (n2 <= 1) {
            return;
        }
        if (this.children == null) {
            this.children = new Vector(n2, 4);
            return;
        }
        this.children.ensureCapacity(n2);
    }

    public void removeChildren() {
        if (this.childrenCount == 1 && this.oneChild instanceof XmlNode) {
            ((XmlNode)this.oneChild).setParentNode(null);
        }
        this.oneChild = null;
        if (this.children != null && this.children.size() > 0) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                if (!(e2 instanceof XmlNode)) continue;
                ((XmlNode)e2).setParentNode(null);
            }
            this.children.removeAllElements();
        }
        this.childrenCount = 0;
    }

    public String getQNameLocal(String string) {
        int n2 = string.lastIndexOf(58);
        return string.substring(n2 + 1);
    }

    public String getQNameUri(String string) {
        int n2 = string.lastIndexOf(58);
        if (n2 > 0) {
            string = string.substring(0, n2);
            try {
                return this.prefix2Namespace(string);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new PullParserRuntimeException(xmlPullParserException);
            }
        }
        return this.defaultNamespaceUri;
    }

    public String prefix2Namespace(String string) {
        if (string == null) {
            return null;
        }
        if ("".equals(string)) {
            return this.defaultNamespaceUri;
        }
        String string2 = null;
        if (this.declaredNsEnd > 0) {
            if (this.prefix2Ns == null) {
                this.prefix2Ns = new Hashtable();
                int n2 = 0;
                while (n2 < this.declaredNsEnd) {
                    this.prefix2Ns.put(this.declaredPrefixes[n2], this.declaredNs[n2]);
                    ++n2;
                }
            }
            string2 = (String)this.prefix2Ns.get(string);
        }
        if (this.parent != null && string2 == null) {
            return this.parent.prefix2Namespace(string);
        }
        return string2;
    }

    public String namespace2Prefix(String string) {
        if (string == null) {
            throw new XmlPullParserException("null is not allowed for namespace name");
        }
        if (string.equals(this.getDefaultNamespaceUri())) {
            return "";
        }
        int n2 = 0;
        while (n2 < this.declaredNsEnd) {
            if (string.equals(this.declaredNs[n2])) {
                return this.declaredPrefixes[n2];
            }
            ++n2;
        }
        if (this.parent != null) {
            return this.parent.namespace2Prefix(string);
        }
        return null;
    }

    public String getDefaultNamespaceUri() {
        return this.defaultNamespaceUri;
    }

    public void setDefaultNamespaceUri(String string) {
        this.defaultNamespaceUri = string;
    }

    public int getDeclaredNamespaceLength() {
        return this.declaredNsEnd;
    }

    public void readDeclaredNamespaceUris(String[] stringArray, int n2, int n3) {
        if (n3 > this.declaredNsEnd) {
            throw new IllegalArgumentException("this node has only " + this.declaredNsEnd + " namespace URIs and not " + n3);
        }
        System.arraycopy(this.declaredNs, 0, stringArray, n2, n3);
    }

    public void readDeclaredPrefixes(String[] stringArray, int n2, int n3) {
        if (n3 > this.declaredNsEnd) {
            throw new IllegalArgumentException("this node has only " + this.declaredNsEnd + " prefixes and nor " + n3);
        }
        System.arraycopy(this.declaredPrefixes, 0, stringArray, n2, n3);
    }

    public void ensureDeclaredNamespacesCapacity(int n2) {
        if (this.declaredNs == null || this.declaredNs.length < n2) {
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            if (this.declaredNsEnd > 0) {
                System.arraycopy(this.declaredNs, 0, stringArray, 0, this.declaredNsEnd);
                System.arraycopy(this.declaredPrefixes, 0, stringArray2, 0, this.declaredNsEnd);
            }
            this.declaredNs = stringArray;
            this.declaredPrefixes = stringArray2;
        }
    }

    public void addNamespaceDeclaration(String string, String string2) {
        Node node = this;
        node.ensureDeclaredNamespacesCapacity(node.declaredNsEnd + 1);
        this.declaredNs[this.declaredNsEnd] = string2;
        this.declaredPrefixes[this.declaredNsEnd] = string;
        ++this.declaredNsEnd;
        if (this.prefix2Ns != null) {
            this.prefix2Ns.put(string, string2);
        }
    }

    public void addDeclaredNamespaces(String[] stringArray, int n2, int n3, String[] stringArray2) {
        if (n3 == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("number of added namespaces can not be negative");
        }
        Node node = this;
        node.ensureDeclaredNamespacesCapacity(node.declaredNsEnd + n3);
        System.arraycopy(stringArray2, n2, this.declaredNs, this.declaredNsEnd, n3);
        System.arraycopy(stringArray, n2, this.declaredPrefixes, this.declaredNsEnd, n3);
        this.declaredNsEnd += n3;
        if (this.prefix2Ns != null) {
            int n4 = n2;
            while (n4 < n2 + n3) {
                this.prefix2Ns.put(stringArray[n4], stringArray2[n4]);
                ++n4;
            }
        }
    }

    public void removeDeclaredNamespaces() {
        this.prefix2Ns = null;
        this.declaredNsEnd = 0;
        this.defaultNamespaceUri = null;
    }

    public void printFields(StringBuffer stringBuffer) {
        super.printFields(stringBuffer);
        stringBuffer.append(" children=[ ");
        if (this.childrenCount == 0) {
        } else if (this.childrenCount == 1) {
            stringBuffer.append("'");
            stringBuffer.append(this.oneChild);
            stringBuffer.append("'");
        } else if (this.children != null) {
            int n2 = 0;
            while (n2 < this.children.size()) {
                stringBuffer.append('\'');
                stringBuffer.append(this.children.elementAt(n2));
                stringBuffer.append("', ");
                ++n2;
            }
        }
        stringBuffer.append(" ]");
        XmlNode xmlNode = this.getParentNode();
        String string = this.getDefaultNamespaceUri();
        if (!(string == null || xmlNode != null && string.equals(xmlNode.getDefaultNamespaceUri()))) {
            stringBuffer.append(" xmlns='");
            stringBuffer.append(string);
            stringBuffer.append('\'');
        }
        if (this.declaredNsEnd > 0) {
            stringBuffer.append(" namespaces = [");
            int n3 = 0;
            while (n3 < this.declaredNsEnd) {
                stringBuffer.append(" xmlns:");
                stringBuffer.append(this.declaredPrefixes[n3]);
                stringBuffer.append("='");
                stringBuffer.append(this.declaredNs[n3]);
                stringBuffer.append("'");
                ++n3;
            }
            stringBuffer.append(" ]");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Node={");
        ((StartTag)this).printFields(stringBuffer);
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }
}

