/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.pullparser;

import java.io.Reader;
import java.util.Hashtable;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlNode;
import org.gjt.xpp.XmlPullParser;
import org.gjt.xpp.XmlPullParserBufferControl;
import org.gjt.xpp.XmlPullParserEventPosition;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlStartTag;
import org.gjt.xpp.impl.pullparser.ElementContent;
import org.gjt.xpp.impl.tag.Attribute;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;
import org.gjt.xpp.impl.tokenizer.Tokenizer;

public class PullParser
implements XmlPullParser,
XmlPullParserBufferControl,
XmlPullParserEventPosition {
    private static final boolean TRACE_SIZING = false;
    protected static final boolean USE_QNAMEBUF = false;
    protected static final boolean CHECK_ATTRIB_UNIQ = true;
    protected boolean emptyElement;
    protected boolean seenRootElement;
    protected String elContent;
    protected Tokenizer tokenizer = new Tokenizer();
    protected int eventStart;
    protected int eventEnd;
    protected byte state;
    protected byte token;
    protected boolean supportNs;
    protected boolean reportNsAttribs;
    protected Hashtable prefix2Ns = new Hashtable();
    protected int attrPosEnd;
    protected int attrPosSize;
    protected Attribute[] attrPos;
    protected int elStackDepth;
    protected int elStackSize;
    protected ElementContent[] elStack;

    public void setInput(Reader reader) {
        this.resetState();
        PullParser pullParser = this;
        pullParser.eventStart = 0;
        pullParser.eventEnd = 0;
        this.tokenizer.setInput(reader);
    }

    public void setInput(char[] cArray) {
        this.resetState();
        PullParser pullParser = this;
        pullParser.eventStart = 0;
        pullParser.eventEnd = 0;
        this.tokenizer.setInput(cArray, 0, cArray.length);
    }

    public void setInput(char[] cArray, int n2, int n3) {
        this.resetState();
        PullParser pullParser = this;
        pullParser.eventEnd = pullParser.eventStart = n2;
        this.tokenizer.setInput(cArray, n2, n3);
    }

    public void reset() {
        this.tokenizer.reset();
        this.resetState();
    }

    public boolean isAllowedMixedContent() {
        return this.tokenizer.isAllowedMixedContent();
    }

    public void setAllowedMixedContent(boolean bl) {
        this.tokenizer.setAllowedMixedContent(bl);
    }

    public boolean isNamespaceAware() {
        return this.supportNs;
    }

    public void setNamespaceAware(boolean bl) {
        if (this.elStackDepth > 0 || this.seenRootElement) {
            throw new XmlPullParserException("namespace support can only be set when not parsing");
        }
        this.supportNs = bl;
    }

    public boolean isNamespaceAttributesReporting() {
        return this.reportNsAttribs;
    }

    public void setNamespaceAttributesReporting(boolean bl) {
        this.reportNsAttribs = bl;
    }

    public String getNamespaceUri() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent elementContent = this.elStack[this.getDepth() - 1];
        return elementContent.uri;
    }

    public String getLocalName() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent elementContent = this.elStack[this.getDepth() - 1];
        return elementContent.localName;
    }

    public String getPrefix() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent elementContent = this.elStack[this.getDepth() - 1];
        return elementContent.prefix;
    }

    public String getRawName() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent elementContent = this.elStack[this.getDepth() - 1];
        return elementContent.qName;
    }

    public String getQNameLocal(String string) {
        int n2 = string.lastIndexOf(58);
        return string.substring(n2 + 1);
    }

    public String getQNameUri(String string) {
        if (this.elStackDepth == 0) {
            throw new XmlPullParserException("parsing must be started to get uri from qname");
        }
        int n2 = string.lastIndexOf(58);
        if (n2 > 0) {
            string = string.substring(0, n2);
            return (String)this.prefix2Ns.get(string);
        }
        return this.elStack[this.elStackDepth - 1].defaultNs;
    }

    public int getDepth() {
        if (this.state != 3) {
            return this.elStackDepth;
        }
        return this.elStackDepth + 1;
    }

    public int getNamespacesLength(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("element depth must be bigger than zero");
        }
        int n3 = this.getDepth();
        if (n2 > n3) {
            throw new IllegalArgumentException("the depth " + n2 + " that was passed for length of namespaces  can not be bigger than current depth of " + n3);
        }
        ElementContent elementContent = this.elStack[n2 - 1];
        return elementContent.prefixesEnd;
    }

    public void readNamespacesPrefixes(int n2, String[] stringArray, int n3, int n4) {
        if (n2 <= 0) {
            throw new XmlPullParserException("element depth must be bigger than zero");
        }
        int n5 = this.getDepth();
        if (n2 > n5) {
            throw new XmlPullParserException("passed prefixes array of length " + n2 + " can not be bigger than current depth of " + n5);
        }
        ElementContent elementContent = this.elStack[n2 - 1];
        if (n4 > elementContent.prefixesEnd) {
            throw new XmlPullParserException("number of prefixes to copy " + n4 + " is bigger than available " + elementContent.prefixesEnd);
        }
        System.arraycopy(elementContent.prefixes, 0, stringArray, n3, n4);
    }

    public void readNamespacesUris(int n2, String[] stringArray, int n3, int n4) {
        if (n2 <= 0) {
            throw new XmlPullParserException("element depth must be bigger than zero");
        }
        int n5 = this.getDepth();
        if (n2 > n5) {
            throw new XmlPullParserException("passed namespace URIs array of length " + n2 + " can not be bigger than current depth of " + n5);
        }
        ElementContent elementContent = this.elStack[n2 - 1];
        if (n4 > elementContent.prefixesEnd) {
            throw new XmlPullParserException("number of namespace URIs to copy " + n4 + " is bigger than available " + elementContent.prefixesEnd);
        }
        System.arraycopy(elementContent.namespaceURIs, 0, stringArray, n3, n4);
    }

    public String getPosDesc() {
        String string;
        switch (this.state) {
            case 2: {
                string = "START_TAG";
                break;
            }
            case 4: {
                string = "CONTENT";
                break;
            }
            case 3: {
                string = "END_TAG";
                break;
            }
            case 1: {
                string = "END_DOCUMENT";
                break;
            }
            default: {
                string = "UNKNONW_EVENT (" + this.state + ")";
            }
        }
        return this.tokenizer.getPosDesc() + " (parser state " + string + ")";
    }

    public int getLineNumber() {
        return this.tokenizer.getLineNumber();
    }

    public int getColumnNumber() {
        return this.tokenizer.getColumnNumber();
    }

    public byte next() {
        PullParser pullParser = this;
        pullParser.eventEnd = pullParser.eventStart = this.tokenizer.pos;
        if (this.emptyElement) {
            --this.elStackDepth;
            if (this.elStackDepth == 0) {
                this.seenRootElement = true;
            }
            this.emptyElement = false;
            this.state = 3;
            return 3;
        }
        Object object = null;
        ElementContent elementContent = null;
        block11: do {
            this.token = this.tokenizer.next();
            switch (this.token) {
                case 2: {
                    this.state = 1;
                    if (this.elStackDepth > 0) {
                        throw new XmlPullParserException("expected element end tag '" + this.elStack[this.elStackDepth - 1].qName + "' not end of document" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.eventEnd = this.tokenizer.pos;
                    return this.state;
                }
                case 10: {
                    this.state = (byte)4;
                    if (this.elStackDepth > 0) {
                        this.elContent = null;
                        this.eventEnd = this.tokenizer.posEnd;
                        return this.state;
                    }
                    if (this.tokenizer.seenContent) {
                        throw new XmlPullParserException("only whitespace content allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    PullParser pullParser2 = this;
                    pullParser2.eventEnd = pullParser2.eventStart = this.tokenizer.pos;
                    break;
                }
                case 110: {
                    int n2;
                    this.eventStart = this.tokenizer.posStart - 2;
                    this.state = (byte)3;
                    if (this.seenRootElement) {
                        throw new XmlPullParserException("no markup allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    --this.elStackDepth;
                    if (this.elStackDepth == 0) {
                        this.seenRootElement = true;
                    }
                    if (this.elStackDepth < 0) {
                        throw new XmlPullParserException("end tag without start stag" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    elementContent = this.elStack[this.elStackDepth];
                    object = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    if (!((String)object).equals(this.elStack[this.elStackDepth].qName)) {
                        throw new XmlPullParserException("end tag name should be " + this.elStack[this.elStackDepth].qName + " not " + (String)object + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    if (this.supportNs && elementContent.prefixes != null) {
                        n2 = elementContent.prefixesEnd - 1;
                        while (n2 >= 0) {
                            if (elementContent.prefixPrevNs[n2] != null) {
                                this.prefix2Ns.put(elementContent.prefixes[n2], elementContent.prefixPrevNs[n2]);
                            } else {
                                this.prefix2Ns.remove(elementContent.prefixes[n2]);
                            }
                            --n2;
                        }
                    }
                    this.eventEnd = this.tokenizer.pos;
                    return this.state;
                }
                case 120: {
                    this.eventStart = this.tokenizer.posStart - 1;
                    this.state = (byte)2;
                    if (this.seenRootElement) {
                        throw new XmlPullParserException("no markup allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.emptyElement = false;
                    if (this.elStackDepth >= this.elStackSize) {
                        PullParser pullParser3 = this;
                        pullParser3.ensureCapacity(pullParser3.elStackDepth);
                    }
                    elementContent = this.elStack[this.elStackDepth];
                    this.elStack[this.elStackDepth].prefixesEnd = 0;
                    this.attrPosEnd = 0;
                    elementContent.defaultNs = null;
                    elementContent.qName = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    if (this.supportNs && this.tokenizer.posNsColon >= 0) {
                        if (this.tokenizer.nsColonCount > 1) {
                            throw new XmlPullParserException("only one colon allowed in prefixed element name" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        elementContent.prefix = elementContent.qName.substring(0, this.tokenizer.posNsColon - this.tokenizer.posStart);
                        elementContent.localName = elementContent.qName.substring(this.tokenizer.posNsColon - this.tokenizer.posStart + 1);
                    } else {
                        elementContent.prefix = null;
                        elementContent.localName = elementContent.qName;
                    }
                    elementContent.uri = null;
                    ++this.elStackDepth;
                    break;
                }
                case 122: {
                    if (this.attrPosEnd >= this.attrPosSize) {
                        PullParser pullParser4 = this;
                        pullParser4.ensureAttribs(pullParser4.attrPosEnd + 1);
                    }
                    object = this.attrPos[this.attrPosEnd];
                    this.attrPos[this.attrPosEnd].qName = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    ((Attribute)object).uri = null;
                    if (this.supportNs && this.tokenizer.posNsColon >= 0) {
                        if (this.tokenizer.nsColonCount > 1) {
                            throw new XmlPullParserException("only one colon allowed in prefixed attribute name" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ((Attribute)object).prefix = ((Attribute)object).qName.substring(0, this.tokenizer.posNsColon - this.tokenizer.posStart);
                        if (this.tokenizer.posEnd == this.tokenizer.posNsColon) {
                            throw new XmlPullParserException("xmlns: is not allowed to declare default namespace, use xmlns instead" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ((Attribute)object).localName = ((Attribute)object).qName.substring(this.tokenizer.posNsColon - this.tokenizer.posStart + 1);
                        break;
                    }
                    ((Attribute)object).prefix = null;
                    ((Attribute)object).localName = ((Attribute)object).qName;
                    break;
                }
                case 127: {
                    int n2;
                    ((Attribute)object).value = this.tokenizer.parsedContent ? new String(this.tokenizer.pc, this.tokenizer.pcStart, this.tokenizer.pcEnd - this.tokenizer.pcStart) : new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    if (this.supportNs) {
                        if ("xmlns".equals(((Attribute)object).prefix)) {
                            if (elementContent.prefixesEnd >= elementContent.prefixesSize) {
                                ElementContent elementContent2 = elementContent;
                                elementContent2.ensureCapacity(elementContent2.prefixesEnd);
                            }
                            if (((Attribute)object).value.length() == 0) {
                                throw new XmlPullParserException("the declared xmlns namespace for '" + ((Attribute)object).localName + "' name  may not be empty" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                            elementContent.prefixes[elementContent.prefixesEnd] = ((Attribute)object).localName;
                            elementContent.namespaceURIs[elementContent.prefixesEnd] = ((Attribute)object).value;
                            elementContent.prefixPrevNs[elementContent.prefixesEnd] = (String)this.prefix2Ns.get(((Attribute)object).localName);
                            n2 = 0;
                            while (n2 < elementContent.prefixesEnd) {
                                if (((Attribute)object).localName.equals(elementContent.prefixes[n2])) {
                                    throw new XmlPullParserException("duplicate xmlns declaration name '" + ((Attribute)object).localName + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                                ++n2;
                            }
                            ++elementContent.prefixesEnd;
                            this.prefix2Ns.put(((Attribute)object).localName, ((Attribute)object).value);
                            if (!this.reportNsAttribs) continue block11;
                            ((Attribute)object).xmlnsAttrib = true;
                            ++this.attrPosEnd;
                            break;
                        }
                        if ("xmlns".equals(((Attribute)object).qName)) {
                            if (elementContent.defaultNs != null) {
                                throw new XmlPullParserException("default namespace was alredy declared by xmlns attribute" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                            elementContent.defaultNs = ((Attribute)object).value;
                            if (!this.reportNsAttribs) continue block11;
                            ((Attribute)object).xmlnsAttrib = true;
                            ++this.attrPosEnd;
                            break;
                        }
                        ((Attribute)object).xmlnsAttrib = false;
                        ++this.attrPosEnd;
                        break;
                    }
                    n2 = 0;
                    while (n2 < this.attrPosEnd) {
                        if (((Attribute)object).qName.equals(this.attrPos[n2].qName)) {
                            throw new XmlPullParserException("duplicate attribute name '" + ((Attribute)object).qName + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ++n2;
                    }
                    ((Attribute)object).xmlnsAttrib = false;
                    ++this.attrPosEnd;
                    break;
                }
                case 111: {
                    this.emptyElement = true;
                    break;
                }
                case 112: {
                    int n2;
                    if (this.supportNs) {
                        if (elementContent.defaultNs == null) {
                            elementContent.defaultNs = this.elStackDepth > 1 ? this.elStack[this.elStackDepth - 2].defaultNs : "";
                        }
                        if (elementContent.prefix != null) {
                            elementContent.uri = (String)this.prefix2Ns.get(elementContent.prefix);
                            if (elementContent.uri == null) {
                                throw new XmlPullParserException("no namespace for prefix '" + elementContent.prefix + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                        } else {
                            elementContent.uri = elementContent.defaultNs;
                            elementContent.localName = elementContent.qName;
                        }
                        n2 = 0;
                        while (n2 < this.attrPosEnd) {
                            object = this.attrPos[n2];
                            if (!((Attribute)object).xmlnsAttrib && ((Attribute)object).uri == null && ((Attribute)object).prefix != null) {
                                ((Attribute)object).uri = (String)this.prefix2Ns.get(((Attribute)object).prefix);
                                if (((Attribute)object).uri == null) {
                                    throw new XmlPullParserException("no namespace for prefix " + ((Attribute)object).prefix + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                            }
                            ++n2;
                        }
                        int n3 = 1;
                        while (n3 < this.attrPosEnd) {
                            object = this.attrPos[n3];
                            n2 = 0;
                            while (n2 < n3) {
                                if (!((Attribute)object).xmlnsAttrib && !this.attrPos[n2].xmlnsAttrib && ((Attribute)object).localName.equals(this.attrPos[n2].localName) && (((Attribute)object).uri != null && ((Attribute)object).uri.equals(this.attrPos[n2].uri) || ((Attribute)object).uri == null && this.attrPos[n2].uri == null)) {
                                    throw new XmlPullParserException("duplicate attribute name '" + ((Attribute)object).qName + "'" + (((Attribute)object).uri != null ? " (with namespace '" + ((Attribute)object).uri + "')" : "") + " and " + (((Attribute)object).uri != null ? " (with namespace '" + ((Attribute)object).uri + "')" : "") + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                                ++n2;
                            }
                            ++n3;
                        }
                    } else {
                        elementContent.prefix = null;
                        elementContent.localName = elementContent.qName;
                        elementContent.uri = "";
                    }
                    this.eventEnd = this.tokenizer.pos;
                    return this.state;
                }
                case 50: {
                    throw new XmlPullParserException("<![DOCTYPE declarations not supported" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                }
                default: {
                    throw new XmlPullParserException("unknown token " + this.token + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                }
            }
        } while (this.token != 112);
        throw new XmlPullParserException("invalid state of tokenizer token=" + this.token);
    }

    public byte getEventType() {
        return this.state;
    }

    public boolean isWhitespaceContent() {
        if (this.state != 4) {
            throw new XmlPullParserException("no content available to read");
        }
        return !this.tokenizer.seenContent;
    }

    public int getContentLength() {
        if (this.state != 4) {
            throw new XmlPullParserException("no content available");
        }
        if (this.tokenizer.parsedContent) {
            return this.tokenizer.pcEnd - this.tokenizer.pcStart;
        }
        return this.tokenizer.posEnd - this.tokenizer.posStart;
    }

    public String readContent() {
        if (this.state != 4) {
            throw new XmlPullParserException("no content available to read");
        }
        if (this.elContent == null) {
            this.elContent = this.tokenizer.parsedContent ? new String(this.tokenizer.pc, this.tokenizer.pcStart, this.tokenizer.pcEnd - this.tokenizer.pcStart) : new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
        }
        return this.elContent;
    }

    public void readEndTag(XmlEndTag xmlEndTag) {
        if (this.state != 3) {
            throw new XmlPullParserException("no end tag available to read" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        ElementContent elementContent = this.elStack[this.elStackDepth];
        xmlEndTag.resetEndTag();
        xmlEndTag.modifyTag(elementContent.uri, elementContent.localName, elementContent.qName);
    }

    public void readStartTag(XmlStartTag xmlStartTag) {
        if (this.state != 2) {
            throw new XmlPullParserException("no start tag available to read" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        xmlStartTag.resetStartTag();
        ElementContent elementContent = this.elStack[this.elStackDepth - 1];
        xmlStartTag.modifyTag(elementContent.uri, elementContent.localName, elementContent.qName);
        xmlStartTag.ensureAttributesCapacity(this.attrPosEnd);
        int n2 = 0;
        while (n2 < this.attrPosEnd) {
            Attribute attribute = this.attrPos[n2];
            xmlStartTag.addAttribute(attribute.uri, attribute.localName, attribute.qName, attribute.value, attribute.xmlnsAttrib);
            ++n2;
        }
    }

    public void readNodeWithoutChildren(XmlNode xmlNode) {
        this.readStartTag(xmlNode);
        if (this.supportNs) {
            ElementContent elementContent = this.elStack[this.elStackDepth - 1];
            xmlNode.setDefaultNamespaceUri(elementContent.defaultNs);
            xmlNode.addDeclaredNamespaces(elementContent.prefixes, 0, elementContent.prefixesEnd, elementContent.namespaceURIs);
        }
    }

    public byte readNode(XmlNode xmlNode) {
        this.readNodeWithoutChildren(xmlNode);
        ElementContent cfr_ignored_0 = this.elStack[this.elStackDepth - 1];
        int n2 = this.elStackDepth;
        block5: while (true) {
            byte by = this.next();
            switch (by) {
                case 2: {
                    XmlNode xmlNode2 = xmlNode.newNode();
                    this.readNodeWithoutChildren(xmlNode2);
                    xmlNode.appendChild(xmlNode2);
                    ElementContent elementContent = this.elStack[this.elStackDepth - 1];
                    this.elStack[this.elStackDepth - 1].node = xmlNode;
                    xmlNode = xmlNode2;
                    continue block5;
                }
                case 4: {
                    xmlNode.appendChild(this.readContent());
                    continue block5;
                }
                case 3: {
                    if (this.elStackDepth >= n2) {
                        xmlNode = this.elStack[this.elStackDepth].node;
                        continue block5;
                    }
                    return by;
                }
            }
        }
    }

    public byte skipNode() {
        if (this.state != 2) {
            throw new XmlPullParserException("start tag must be read before skiping subtree" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        int n2 = 1;
        byte by = 3;
        while (n2 > 0) {
            by = this.next();
            switch (by) {
                case 2: {
                    ++n2;
                    break;
                }
                case 3: {
                    --n2;
                }
            }
        }
        return by;
    }

    public int getHardLimit() {
        return this.tokenizer.getHardLimit();
    }

    public void setHardLimit(int n2) {
        this.tokenizer.setHardLimit(n2);
    }

    public int getSoftLimit() {
        return this.tokenizer.getSoftLimit();
    }

    public void setSoftLimit(int n2) {
        this.tokenizer.setSoftLimit(n2);
    }

    public int getBufferShrinkOffset() {
        return this.tokenizer.getBufferShrinkOffset();
    }

    public void setBufferShrinkable(boolean bl) {
        this.tokenizer.setBufferShrinkable(bl);
    }

    public boolean isBufferShrinkable() {
        return this.tokenizer.isBufferShrinkable();
    }

    public int getEventStart() {
        return this.eventStart;
    }

    public int getEventEnd() {
        return this.eventEnd;
    }

    public char[] getEventBuffer() {
        return this.tokenizer.buf;
    }

    protected void ensureCapacity(int n2) {
        if ((n2 = 2 * n2) == 0) {
            n2 = 8;
        }
        if (this.elStackSize < n2) {
            ElementContent[] elementContentArray = new ElementContent[n2];
            if (this.elStack != null) {
                System.arraycopy(this.elStack, 0, elementContentArray, 0, this.elStackSize);
            }
            int n3 = this.elStackSize;
            while (n3 < n2) {
                elementContentArray[n3] = new ElementContent();
                ++n3;
            }
            this.elStack = elementContentArray;
            this.elStackSize = n2;
        }
    }

    protected void ensureAttribs(int n2) {
        if ((n2 = 2 * n2) == 0) {
            n2 = 8;
        }
        if (this.attrPosEnd < n2) {
            Attribute[] attributeArray = new Attribute[n2];
            if (this.attrPos != null) {
                System.arraycopy(this.attrPos, 0, attributeArray, 0, this.attrPosSize);
            }
            int n3 = this.attrPosSize;
            while (n3 < n2) {
                attributeArray[n3] = new Attribute();
                ++n3;
            }
            this.attrPos = attributeArray;
            this.attrPosSize = n2;
        }
    }

    protected void resetState() {
        this.tokenizer.paramNotifyDoctype = true;
        PullParser pullParser = this;
        pullParser.state = (byte)-1;
        pullParser.token = (byte)-1;
        this.eventStart = -1;
        this.elStackDepth = 0;
        this.prefix2Ns.clear();
        this.prefix2Ns.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.emptyElement = false;
        this.seenRootElement = false;
    }
}

