/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.tokenizer;

import java.io.EOFException;
import java.io.Reader;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;
import org.gjt.xpp.impl.tokenizer.TokenizerBufferOverflowException;
import org.gjt.xpp.impl.tokenizer.TokenizerException;

public class Tokenizer {
    public static final byte END_DOCUMENT = 2;
    public static final byte CONTENT = 10;
    public static final byte CHARACTERS = 20;
    public static final byte CDSECT = 30;
    public static final byte COMMENT = 40;
    public static final byte DOCTYPE = 50;
    public static final byte PI = 60;
    public static final byte ENTITY_REF = 70;
    public static final byte CHAR_REF = 75;
    public static final byte ETAG_NAME = 110;
    public static final byte EMPTY_ELEMENT = 111;
    public static final byte STAG_END = 112;
    public static final byte STAG_NAME = 120;
    public static final byte ATTR_NAME = 122;
    public static final byte ATTR_CHARACTERS = 124;
    public static final byte ATTR_CONTENT = 127;
    public boolean paramNotifyCharacters;
    public boolean paramNotifyComment;
    public boolean paramNotifyCDSect;
    public boolean paramNotifyDoctype;
    public boolean paramNotifyPI;
    public boolean paramNotifyCharRef;
    public boolean paramNotifyEntityRef;
    public boolean paramNotifyAttValue;
    public char[] buf = new char[1024];
    public int pos;
    public int posStart;
    public int posEnd;
    public int posNsColon;
    public int nsColonCount;
    public boolean seenContent;
    public boolean parsedContent;
    public char[] pc = new char[1024];
    public int pcStart;
    public int pcEnd;
    private static final boolean NORMALIZE_LINE_BREAKS = true;
    private static final boolean TRACING = false;
    private static final boolean TRACE_SIZING = false;
    private boolean paramPC = true;
    private boolean paramNoMixContent = false;
    private boolean mixInElement = false;
    private boolean backtracking = false;
    private static final int BUF_SIZE = 1024;
    private int readChunkSize = 1024;
    private int loadFactor = 99;
    private int posSafe = (this.loadFactor << 10) / 100;
    private int softLimit = -1;
    private int hardLimit = -1;
    private int shrinkOffset = 0;
    private boolean shrinkable = true;
    private boolean reading = true;
    private Reader reader;
    private int bufStart;
    private int bufEnd;
    private int bufSize = 1024;
    private int posCol;
    private int posRow;
    private char prevCh;
    private char prevPrevCh;
    private char attrMarker;
    private char charRefValue;
    private boolean charRefHex;
    private boolean reachedEnd;
    private boolean seenStartTag;
    private byte previousState;
    private byte state;
    private static final byte STATE_INIT = 1;
    private static final byte STATE_FINISH = 6;
    private static final byte STATE_FINISHED = 7;
    private static final byte STATE_CONTENT_INIT = 10;
    private static final byte STATE_CONTENT_CONTINUED = 11;
    private static final byte STATE_CONTENT = 12;
    private static final byte STATE_SEEN_LT = 13;
    private static final byte STATE_SEEN_LT_BANG = 14;
    private static final byte STATE_CDSECT = 30;
    private static final byte STATE_CDSECT_BRACKET = 31;
    private static final byte STATE_CDSECT_BRACKET_BRACKET = 32;
    private static final byte STATE_COMMENT = 40;
    private static final byte STATE_COMMENT_DASH = 41;
    private static final byte STATE_COMMENT_DASH_DASH = 42;
    private static final byte STATE_DOCTYPE = 50;
    private static final byte STATE_DOCTYPE_BRACKET = 51;
    private static final byte STATE_DOCTYPE_BRACKET_BRACKET = 52;
    private static final byte STATE_PI = 60;
    private static final byte STATE_PI_END = 61;
    private static final byte STATE_SEEN_AMP = 70;
    private static final byte STATE_ENTITY_REF = 71;
    private static final byte STATE_CHAR_REF = 75;
    private static final byte STATE_CHAR_REF_DIGITS = 76;
    private static final byte STATE_SCAN_ETAG_NAME = 110;
    private static final byte STATE_SCAN_STAG_NAME = 120;
    private static final byte STATE_SCAN_STAG_GT = 121;
    private static final byte STATE_SCAN_ATTR_NAME = 122;
    private static final byte STATE_SCAN_ATTR_EQ = 123;
    private static final byte STATE_SCAN_ATTR_VALUE = 124;
    private static final byte STATE_SCAN_ATTR_VALUE_CONTINUE = 125;
    private static final byte STATE_SCAN_ATTR_VALUE_END = 126;
    private static final byte STATE_ATTR_VALUE_CONTENT = 127;

    public void reset() {
        if (!this.reading) {
            if (this.softLimit != -1) {
                Tokenizer tokenizer = this;
                tokenizer.resize(tokenizer.softLimit);
            } else {
                this.resize(1024);
            }
        }
        this.resetState();
    }

    private void resetState() {
        this.reading = true;
        this.bufSize = this.buf.length;
        Tokenizer tokenizer = this;
        tokenizer.bufEnd = 0;
        tokenizer.bufStart = 0;
        Tokenizer tokenizer2 = this;
        this.pos = 0;
        tokenizer2.posStart = 0;
        tokenizer2.posEnd = 0;
        this.posNsColon = -1;
        this.state = 1;
        this.prevCh = '\u0000';
        Tokenizer tokenizer3 = this;
        tokenizer3.posRow = 1;
        tokenizer3.posCol = 1;
        this.reachedEnd = false;
        Tokenizer tokenizer4 = this;
        tokenizer4.pcStart = 0;
        tokenizer4.pcEnd = 0;
        if (this.pc.length > 2048) {
            this.pc = new char[1024];
        }
        this.previousState = (byte)-1;
        this.backtracking = false;
        this.seenContent = false;
        this.shrinkOffset = 0;
    }

    public void setInput(Reader reader) {
        this.reset();
        this.reading = true;
        this.reader = reader;
        Tokenizer tokenizer = this;
        tokenizer.bufEnd = 0;
        tokenizer.bufStart = 0;
    }

    public void setInput(char[] cArray) {
        this.setInput(cArray, 0, cArray.length);
    }

    public void setInput(char[] cArray, int n2, int n3) {
        this.resetState();
        this.reading = false;
        this.buf = cArray;
        Tokenizer tokenizer = this;
        tokenizer.bufStart = tokenizer.pos = n2;
        Tokenizer tokenizer2 = this;
        tokenizer2.bufSize = tokenizer2.bufEnd = n2 + n3;
    }

    public void setNotifyAll(boolean bl) {
        this.paramNotifyCharacters = bl;
        this.paramNotifyComment = bl;
        this.paramNotifyCDSect = bl;
        this.paramNotifyDoctype = bl;
        this.paramNotifyPI = bl;
        this.paramNotifyEntityRef = bl;
        this.paramNotifyCharRef = bl;
        this.paramNotifyAttValue = bl;
    }

    public void setParseContent(boolean bl) {
        this.paramPC = bl;
    }

    public boolean isAllowedMixedContent() {
        return !this.paramNoMixContent;
    }

    public void setAllowedMixedContent(boolean bl) {
        this.paramNoMixContent = !bl;
    }

    public int getSoftLimit() {
        return this.softLimit;
    }

    public void setSoftLimit(int n2) {
        if (!this.reading) {
            throw new TokenizerException("hard limit can not be set for char array input");
        }
        if (n2 != -1 && this.hardLimit != -1 && 2 * n2 > this.hardLimit) {
            throw new TokenizerException("soft limit can no tbe bigger than half of hard limitcurrent hard limit " + this.hardLimit);
        }
        this.softLimit = n2;
        if (this.softLimit != -1) {
            this.posSafe = this.softLimit;
            return;
        }
        if (this.hardLimit != -1) {
            this.posSafe = this.hardLimit / 2;
            return;
        }
        this.posSafe = this.loadFactor * this.bufSize / 100;
    }

    public int getHardLimit() {
        return this.hardLimit;
    }

    public void setHardLimit(int n2) {
        if (!this.reading) {
            throw new TokenizerException("hard limit can not be set for char array input");
        }
        if (this.state != 1 && n2 < this.hardLimit) {
            throw new TokenizerException("hard limit on buffer size can not be shrunk during parsing");
        }
        if (this.softLimit == -1 && n2 != -1) {
            throw new TokenizerException("soft limit must be set to non -1 before setting hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        if (n2 != -1 && 2 * this.softLimit >= n2) {
            throw new TokenizerException("hard limit must be at least twice the size of soft limitcurrent soft limit " + this.softLimit + " and hard limit " + n2 + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        this.hardLimit = n2;
        if (this.shrinkable && this.softLimit != -1 && this.softLimit < this.bufSize) {
            Tokenizer tokenizer = this;
            tokenizer.resize(tokenizer.softLimit);
        }
    }

    public int getBufferShrinkOffset() {
        return this.shrinkOffset;
    }

    public void setBufferShrinkable(boolean bl) {
        this.shrinkable = bl;
    }

    public boolean isBufferShrinkable() {
        return this.shrinkable;
    }

    private static int findFragment(int n2, char[] cArray, int n3, int n4) {
        if (n3 < n2) {
            n3 = n2;
            if (n2 > n4) {
                n3 = n4;
            }
            return n3;
        }
        if (n4 - n3 > 55) {
            n3 = n4 - 10;
        }
        int n5 = n3 + 1;
        while (--n5 > n2) {
            char c2;
            if (n4 - n5 > 55 || (c2 = cArray[n5]) == '<' && n3 - n5 > 10) break;
        }
        return n5;
    }

    public String getPosDesc() {
        int n2;
        String string = null;
        if (this.posStart <= this.posEnd && (n2 = Tokenizer.findFragment(this.bufStart, this.buf, this.posStart, this.posEnd)) < this.posEnd) {
            string = new String(this.buf, n2, this.posEnd - n2);
            if (n2 > this.bufStart) {
                string = "..." + string;
            }
        }
        return " at line " + this.posRow + " and column " + (this.posCol - 1) + (string != null ? " seen " + Tokenizer.printable(string) + "..." : "");
    }

    public int getLineNumber() {
        return this.posRow;
    }

    public int getColumnNumber() {
        return this.posCol - 1;
    }

    private static boolean compareCharArr(char[] cArray, char[] cArray2, int n2, int n3) {
        if (n3 - n2 != cArray.length) {
            return false;
        }
        int n4 = 0;
        while (n2 < n3) {
            if (cArray[n4] != cArray2[n2]) {
                return false;
            }
            ++n2;
            ++n4;
        }
        return true;
    }

    private static String printableChar(char c2) {
        if (c2 == '\n') {
            return "\\n";
        }
        if (c2 == '\r') {
            return "\\r";
        }
        if (c2 == '\t') {
            return "\\t";
        }
        if (c2 < ' ') {
            return "\\u" + Character.digit(c2, 16);
        }
        return "" + c2;
    }

    private static String printable(char c2) {
        return "'" + Tokenizer.printableChar(c2) + "'";
    }

    private static String printable(String string) {
        int n2 = string.indexOf(10);
        int n3 = string.indexOf(13);
        int n4 = string.indexOf(9);
        if (n2 != -1 || n3 != -1 || n4 != -1) {
            StringBuffer stringBuffer = new StringBuffer("\"");
            n3 = 0;
            while (n3 < string.length()) {
                stringBuffer.append(Tokenizer.printableChar(string.charAt(n3)));
                ++n3;
            }
            stringBuffer.append("\"");
            string = stringBuffer.toString();
        }
        return string;
    }

    private char readName(char c2) {
        this.posNsColon = -1;
        this.nsColonCount = 0;
        if (!Character.isLowerCase(c2) && !Character.isUpperCase(c2) && c2 != ':' && c2 != '_') {
            throw new TokenizerException("expected name start not " + Tokenizer.printable(c2) + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        do {
            if ((c2 = this.more()) != ':') continue;
            this.posNsColon = this.pos - 1;
            ++this.nsColonCount;
        } while (Character.isLowerCase(c2) || Character.isUpperCase(c2) || Character.isDigit(c2) || c2 == '.' || c2 == '-' || c2 == '_' || c2 == ':');
        return c2;
    }

    private boolean isS(char c2) {
        return c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r';
    }

    private char skipS(char c2) {
        while (c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r') {
            c2 = this.more();
        }
        return c2;
    }

    /*
     * Unable to fully structure code
     */
    private char readS(char var1_1) {
        if (this.isS(var1_1)) ** GOTO lbl4
        throw new TokenizerException("expected white space not " + var1_1 + this.getPosDesc(), this.posRow, this.posCol - 1);
lbl-1000:
        // 1 sources

        {
            var1_1 = this.more();
lbl4:
            // 2 sources

            ** while (var1_1 == ' ' || var1_1 == '\n' || var1_1 == '\t' || var1_1 == '\r')
        }
lbl5:
        // 1 sources

        return var1_1;
    }

    private char more() {
        int n2;
        if (this.backtracking) {
            this.backtracking = false;
            ++this.pos;
            ++this.posCol;
            return this.prevCh;
        }
        if (!this.reading) {
            if (this.pos == this.bufEnd - 1) {
                this.reachedEnd = true;
            }
            if (this.pos >= this.bufEnd) {
                throw new EOFException("no more data available");
            }
        } else {
            if (this.hardLimit != -1 && this.pos >= this.hardLimit - 1) {
                throw new TokenizerBufferOverflowException("reached hard limit on buffer size" + this.getPosDesc(), this.posRow, this.posCol - 1);
            }
            if (this.pos >= this.bufEnd - 1) {
                if (this.hardLimit != -1 && this.bufSize > this.hardLimit) {
                    throw new TokenizerBufferOverflowException("buffer size should never exceed hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
                }
                n2 = this.bufSize - this.bufEnd;
                if (n2 <= this.readChunkSize) {
                    n2 = 2 * this.bufSize;
                    if (this.hardLimit == -1) {
                        if (n2 < this.softLimit) {
                            n2 = 2 * this.softLimit;
                        }
                        if (n2 < 4 * this.readChunkSize) {
                            n2 = 12 * this.readChunkSize;
                        }
                    } else if (n2 > this.hardLimit) {
                        if (this.bufEnd >= this.hardLimit) {
                            throw new TokenizerBufferOverflowException("buffer can not grow beyond hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        n2 = this.hardLimit;
                    }
                    if (n2 - this.bufSize > 0) {
                        this.resize(n2);
                    }
                }
                if (this.bufSize - this.bufEnd < (n2 = this.readChunkSize)) {
                    n2 = this.bufSize - this.bufEnd;
                }
                if (this.reader == null) {
                    throw new TokenizerException("to start parsing setInput() must be called!");
                }
                if ((n2 = this.reader.read(this.buf, this.bufEnd, n2)) == -1) {
                    if (this.reachedEnd) {
                        throw new TokenizerException("can't read more - reached end of stream (state=" + this.state + ")" + this.getPosDesc());
                    }
                    this.reachedEnd = true;
                }
                if (n2 == 0) {
                    throw new TokenizerBufferOverflowException("can't read more data in buffer (read() returns 0 chars)" + this.getPosDesc());
                }
                this.bufEnd += n2;
            }
        }
        if ((n2 = this.buf[this.pos++]) == 10 || n2 == 13) {
            if (this.prevCh != '\r' || n2 != 10) {
                this.posCol = 2;
                ++this.posRow;
            }
        } else {
            ++this.posCol;
        }
        this.prevPrevCh = this.prevCh;
        int n3 = n2;
        this.prevCh = (char)n3;
        return (char)n3;
    }

    private void resize(int n2) {
        char[] cArray = new char[n2];
        int n3 = this.bufEnd;
        if (n3 > n2) {
            n3 = n2;
            if (this.state != 1) {
                throw new PullParserRuntimeException("internal buffer may not be shrank during parsing" + this.getPosDesc());
            }
        }
        System.arraycopy(this.buf, 0, cArray, 0, n3);
        this.buf = cArray;
        this.bufSize = n2;
        if (this.softLimit == -1) {
            this.posSafe = this.loadFactor * this.bufSize / 100;
        }
    }

    private void ensurePC() {
        if (this.paramPC && this.pcEnd >= this.pc.length) {
            int n2 = 2 * this.pcEnd + 1;
            char[] cArray = new char[n2];
            System.arraycopy(this.pc, 0, cArray, 0, this.pc.length);
            this.pc = cArray;
        }
    }

    private char less() {
        --this.pos;
        --this.posCol;
        this.backtracking = true;
        return this.prevPrevCh;
    }

    private void shrink(int n2) {
        System.arraycopy(this.buf, n2, this.buf, 0, this.bufEnd - n2);
        this.shrinkOffset += n2;
        this.bufEnd -= n2;
        this.pos -= n2;
        this.posStart -= n2;
        this.posEnd -= n2;
        this.posNsColon -= n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte next() {
        if (this.state == 7) {
            throw new TokenizerException("attempt to read beyond end of input");
        }
        this.parsedContent = false;
        block32: while (true) {
            int n2;
            if (this.reachedEnd) {
                if (this.state != 6) {
                    if (this.state != 12 && this.state != 10 && this.state != 11) {
                        throw new TokenizerException("unexpected end of stream (state=" + this.state + ")" + this.getPosDesc());
                    }
                    if (this.state == 10 || this.state == 11) {
                        if (this.state == 10) {
                            Tokenizer tokenizer = this;
                            tokenizer.pcStart = 0;
                            tokenizer.pcEnd = 0;
                        }
                        Tokenizer tokenizer = this;
                        tokenizer.posEnd = tokenizer.posStart = this.pos - 1;
                    }
                    this.state = (byte)6;
                    if (this.paramPC && (this.pcStart != this.pcEnd || this.posEnd != this.posStart)) {
                        boolean bl = this.parsedContent = this.pcEnd != this.pcStart;
                        if (!this.paramNoMixContent || !this.seenContent) {
                            return 10;
                        }
                        if (this.parsedContent) {
                            throw new TokenizerException("no element content allowed before end of stream" + this.getPosDesc());
                        }
                    }
                }
                this.state = (byte)7;
                return 2;
            }
            char c2 = this.more();
            if (c2 == '\r') {
                if (this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                    n2 = this.posEnd - this.posStart;
                    System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n2);
                    this.pcEnd += n2;
                }
            } else if (this.prevPrevCh == '\r' && c2 == '\n') continue;
            switch (this.state) {
                case 1: {
                    if (c2 == '\ufffe') {
                        throw new TokenizerException("first character in input was UNICODE noncharacter (0xFFFE)- input requires byte swapping");
                    }
                    if (c2 == '\ufeff') {
                        this.state = (byte)10;
                        continue block32;
                    }
                }
                case 10: {
                    Tokenizer tokenizer = this;
                    tokenizer.pcStart = 0;
                    tokenizer.pcEnd = 0;
                }
                case 11: {
                    Tokenizer tokenizer = this;
                    tokenizer.posEnd = tokenizer.posStart = this.pos - 1;
                    this.state = (byte)12;
                }
                case 12: {
                    if (c2 == '<') {
                        this.state = (byte)13;
                        if (!this.paramNotifyCharacters || this.posStart == this.posEnd) continue block32;
                        return 20;
                    }
                    if (c2 == '&') {
                        if (this.paramPC && this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                            n2 = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n2);
                            this.pcEnd += n2;
                        }
                        if (!this.seenContent) {
                            this.seenContent = true;
                            if (this.paramNoMixContent && !this.mixInElement) {
                                throw new TokenizerException("mixed content disallowed outside element" + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                        }
                        this.state = (byte)70;
                        this.previousState = (byte)11;
                        this.posStart = this.pos - 1;
                        continue block32;
                    }
                    if (!this.seenContent && !this.isS(c2)) {
                        this.seenContent = true;
                        if (this.paramNoMixContent && !this.mixInElement) {
                            throw new TokenizerException("mixed content disallowed outside element, character " + Tokenizer.printable(c2) + " (" + c2 + ")" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                    }
                    this.posEnd = this.pos;
                    if (this.paramPC && (this.pcStart != this.pcEnd || c2 == '\r')) {
                        if (c2 == '\r') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 10;
                        } else {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = c2;
                        }
                    }
                    if (!this.paramNotifyCharacters || !this.reachedEnd) continue block32;
                    return 20;
                }
                case 13: {
                    if (c2 == '!') {
                        this.state = (byte)14;
                    } else if (c2 == '?') {
                        this.state = (byte)60;
                    } else {
                        n2 = this.seenContent ? 1 : 0;
                        if (c2 == '/') {
                            this.state = (byte)110;
                            this.mixInElement = false;
                        } else {
                            this.state = (byte)120;
                            if (this.paramNoMixContent && this.seenContent) {
                                throw new TokenizerException("mixed content disallowed inside element and before start tag" + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                            this.mixInElement = true;
                        }
                        if (this.paramPC && (this.pcStart != this.pcEnd || this.posEnd != this.posStart || this.state == 110 && this.seenStartTag) && (!this.paramNoMixContent || n2 != 0 || this.paramNoMixContent && this.state == 110 && this.seenStartTag)) {
                            boolean bl = this.parsedContent = this.pcEnd != this.pcStart;
                            if (!this.parsedContent && this.posEnd == this.posStart) continue block32;
                            return 10;
                        }
                    }
                    if (this.paramPC && this.state != 120 && this.state != 110 && this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                        n2 = this.posEnd - this.posStart;
                        System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n2);
                        this.pcEnd += n2;
                    }
                    this.posStart = this.pos;
                    continue block32;
                }
                case 14: {
                    if (c2 == '-') {
                        c2 = this.more();
                        if (c2 != '-') {
                            throw new TokenizerException("expected - for start of comment <!-- not " + c2 + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        this.state = (byte)40;
                        this.posStart = this.pos;
                        continue block32;
                    }
                    if (c2 == '[') {
                        c2 = this.more();
                        if (c2 != 'C') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        c2 = this.more();
                        if (c2 != 'D') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        c2 = this.more();
                        if (c2 != 'A') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        char c3 = this.more();
                        c2 = c3;
                        if (c3 != 'T') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        c2 = this.more();
                        if (c2 != 'A') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        c2 = this.more();
                        if (c2 != '[') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        this.posStart = this.pos;
                        if (!this.seenContent) {
                            this.seenContent = true;
                            if (this.paramNoMixContent && !this.mixInElement) {
                                throw new TokenizerException("mixed content disallowed outside element" + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                        }
                        this.state = (byte)30;
                        continue block32;
                    }
                    if (c2 != 'D') throw new TokenizerException("unknown markup after <! " + Tokenizer.printableChar(c2) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    c2 = this.more();
                    if (c2 != 'O') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    c2 = this.more();
                    if (c2 != 'C') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    c2 = this.more();
                    if (c2 != 'T') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    c2 = this.more();
                    if (c2 != 'Y') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    c2 = this.more();
                    if (c2 != 'P') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    c2 = this.more();
                    if (c2 != 'E') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.posStart = this.pos;
                    this.state = (byte)50;
                    continue block32;
                }
                case 70: {
                    this.posStart = this.pos - 2;
                    if (c2 == '#') {
                        this.state = (byte)75;
                        continue block32;
                    }
                    this.state = (byte)71;
                }
                case 71: {
                    if (c2 != ';') continue block32;
                    this.state = this.previousState;
                    this.posEnd = this.pos;
                    if (this.paramPC) {
                        n2 = this.posStart + 1;
                        c2 = this.pos - 1;
                        if ((c2 -= n2) == '\u0002' && this.buf[n2] == 'l' && this.buf[n2 + 1] == 't') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 60;
                        } else if (c2 == '\u0003' && this.buf[n2] == 'a' && this.buf[n2 + 1] == 'm' && this.buf[n2 + 2] == 'p') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 38;
                        } else if (c2 == '\u0002' && this.buf[n2] == 'g' && this.buf[n2 + 1] == 't') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 62;
                        } else if (c2 == '\u0004' && this.buf[n2] == 'a' && this.buf[n2 + 1] == 'p' && this.buf[n2 + 2] == 'o' && this.buf[n2 + 3] == 's') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 39;
                        } else if (c2 == '\u0004' && this.buf[n2] == 'q' && this.buf[n2 + 1] == 'u' && this.buf[n2 + 2] == 'o' && this.buf[n2 + 3] == 't') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 34;
                        } else {
                            String string = new String(this.buf, n2, (int)c2);
                            throw new TokenizerException("undefined entity " + string + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                    }
                    if (!this.paramNotifyEntityRef) continue block32;
                    return 70;
                }
                case 75: {
                    this.charRefValue = '\u0000';
                    this.state = (byte)76;
                    if (c2 == 'x') {
                        this.charRefHex = true;
                        continue block32;
                    }
                    this.charRefHex = false;
                }
                case 76: {
                    if (c2 == ';') {
                        if (this.paramPC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = this.charRefValue;
                        }
                        this.state = this.previousState;
                        this.posEnd = this.pos;
                        if (!this.paramNotifyCharRef) continue block32;
                        return 75;
                    }
                    if (c2 >= '0' && c2 <= '9') {
                        if (this.charRefHex) {
                            this.charRefValue = (char)((this.charRefValue << 4) + (c2 - 48));
                            continue block32;
                        }
                        this.charRefValue = (char)(this.charRefValue * 10 + (c2 - 48));
                        continue block32;
                    }
                    if (this.charRefHex && c2 >= 'A' && c2 <= 'F') {
                        this.charRefValue = (char)((this.charRefValue << 4) + (c2 - 65 + 10));
                        continue block32;
                    }
                    if (!this.charRefHex || c2 < 'a' || c2 > 'f') throw new TokenizerException("character reference may not contain " + Tokenizer.printable(c2) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    this.charRefValue = (char)((this.charRefValue << 4) + (c2 - 97 + 10));
                    continue block32;
                }
                case 110: {
                    this.seenStartTag = false;
                    this.seenContent = false;
                    this.posStart = this.pos - 1;
                    c2 = this.readName(c2);
                    this.posEnd = this.pos - 1;
                    char c4 = this.skipS(c2);
                    c2 = c4;
                    if (c4 != '>') {
                        throw new TokenizerException("expected > for end tag not " + Tokenizer.printable(c2) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.state = (byte)10;
                    return 110;
                }
                case 120: {
                    if (this.shrinkable && this.reading && this.pos > 2 && this.pos > this.posSafe) {
                        Tokenizer tokenizer = this;
                        tokenizer.shrink(tokenizer.pos - 2);
                    }
                    this.seenStartTag = true;
                    this.seenContent = false;
                    c2 = this.less();
                    this.posStart = this.pos - 1;
                    this.readName(c2);
                    this.posEnd = this.pos - 1;
                    this.less();
                    this.state = (byte)122;
                    Tokenizer tokenizer = this;
                    tokenizer.pcStart = 0;
                    tokenizer.pcEnd = 0;
                    return 120;
                }
                case 121: {
                    if (c2 != '>') throw new TokenizerException("expected > for end of start tag not " + Tokenizer.printable(c2) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    this.state = (byte)10;
                    this.posStart = this.pos - 1;
                    this.posEnd = this.pos;
                    return 112;
                }
                case 122: {
                    this.pcStart = this.pcEnd;
                    n2 = this.isS(c2);
                    c2 = this.skipS(c2);
                    if (c2 == '/') {
                        this.state = (byte)121;
                        this.posStart = this.pos - 1;
                        this.posEnd = this.pos;
                        this.mixInElement = false;
                        this.seenStartTag = false;
                        return 111;
                    }
                    if (c2 == '>') {
                        this.state = (byte)10;
                        this.posStart = this.pos - 1;
                        this.posEnd = this.pos;
                        return 112;
                    }
                    if (n2 == 0) {
                        throw new TokenizerException("white space expected before attribute name and not " + Tokenizer.printable(c2) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.posStart = this.pos - 1;
                    this.readName(c2);
                    this.posEnd = this.pos - 1;
                    this.less();
                    this.state = (byte)123;
                    return 122;
                }
                case 123: {
                    c2 = this.skipS(c2);
                    if (c2 != '=') {
                        throw new TokenizerException("expected = after attribute name not " + Tokenizer.printable(c2) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.state = (byte)124;
                    continue block32;
                }
                case 124: {
                    c2 = this.skipS(c2);
                    if (c2 != '\'' && c2 != '\"') {
                        throw new TokenizerException("attribute value must start with double quote or apostrophe not " + Tokenizer.printable(c2) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.attrMarker = c2;
                    this.state = (byte)125;
                    Tokenizer tokenizer = this;
                    tokenizer.posEnd = tokenizer.posStart = this.pos;
                    this.pcEnd = this.pcStart;
                    continue block32;
                }
                case 125: {
                    this.state = (byte)126;
                }
                case 126: {
                    if (c2 == this.attrMarker) {
                        this.state = this.paramPC ? (byte)127 : (byte)122;
                        if (!this.paramNotifyAttValue) continue block32;
                        return 124;
                    }
                    if (c2 == '&') {
                        if (this.paramPC && this.pcEnd == this.pcStart && this.posEnd > this.posStart) {
                            n2 = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n2);
                            this.pcEnd += n2;
                        }
                        this.state = (byte)70;
                        this.previousState = (byte)125;
                        if (!this.paramNotifyAttValue) continue block32;
                        return 124;
                    }
                    if (c2 == '<') {
                        throw new TokenizerException("attribute value can not contain " + c2 + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    if (this.paramPC && (this.pcStart != this.pcEnd || c2 == '\t' || c2 == '\n' || c2 == '\r')) {
                        if (this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                            n2 = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n2);
                            this.pcEnd += n2;
                        }
                        if (c2 == '\t' || c2 == '\n' || c2 == '\r') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 32;
                            continue block32;
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC();
                        }
                        this.pc[this.pcEnd++] = c2;
                        continue block32;
                    }
                    this.posEnd = this.pos;
                    continue block32;
                }
                case 127: {
                    this.less();
                    this.parsedContent = this.pcEnd != this.pcStart;
                    this.state = (byte)122;
                    return 127;
                }
                case 30: {
                    if (c2 != ']') continue block32;
                    this.state = (byte)31;
                    continue block32;
                }
                case 31: {
                    if (c2 == ']') {
                        this.state = (byte)32;
                        continue block32;
                    }
                    this.state = (byte)30;
                    continue block32;
                }
                case 32: {
                    if (c2 == '>') {
                        this.state = (byte)11;
                        this.posEnd = this.pos - 3;
                        if (this.paramPC && this.posEnd > this.posStart) {
                            n2 = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n2);
                            this.pcEnd += n2;
                        }
                        if (!this.paramNotifyCDSect) continue block32;
                        return 30;
                    }
                    this.state = (byte)30;
                    continue block32;
                }
                case 40: {
                    if (c2 != '-') continue block32;
                    this.state = (byte)41;
                    continue block32;
                }
                case 41: {
                    if (c2 == '-') {
                        this.state = (byte)42;
                        continue block32;
                    }
                    this.state = (byte)40;
                    continue block32;
                }
                case 42: {
                    if (c2 == '>') {
                        this.state = (byte)11;
                        this.posEnd = this.pos - 3;
                        if (!this.paramNotifyComment) continue block32;
                        return 40;
                    }
                    this.state = (byte)40;
                    continue block32;
                }
                case 50: {
                    if (c2 == '[') {
                        this.state = (byte)51;
                        continue block32;
                    }
                    if (c2 != '>') continue block32;
                    this.state = (byte)11;
                    this.posEnd = this.pos - 1;
                    if (!this.paramNotifyDoctype) continue block32;
                    return 50;
                }
                case 51: {
                    if (c2 != ']') continue block32;
                    this.state = (byte)52;
                    continue block32;
                }
                case 52: {
                    c2 = this.skipS(c2);
                    if (c2 != '>') throw new TokenizerException("expected > for DOCTYPE end not " + c2 + this.getPosDesc(), this.posRow, this.posCol - 1);
                    this.state = (byte)11;
                    this.posEnd = this.pos - 1;
                    if (!this.paramNotifyDoctype) continue block32;
                    return 50;
                }
                case 60: {
                    if (c2 != '?') continue block32;
                    this.state = (byte)61;
                    continue block32;
                }
                case 61: {
                    if (c2 != '>') continue block32;
                    this.state = (byte)11;
                    this.posEnd = this.pos - 2;
                    if (this.paramNotifyPI) return 60;
                    continue block32;
                }
            }
            break;
        }
        throw new TokenizerException("invalid internal state " + this.state + this.getPosDesc(), this.posRow, this.posCol - 1);
    }
}

