/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.jaxp11;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gjt.xpp.jaxp11.DefaultValidationErrorHandler;
import org.gjt.xpp.sax2.Driver;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public class SAXParserImpl
extends SAXParser {
    private XMLReader xmlReader;
    private Parser parser = null;
    private boolean validating = false;
    private boolean namespaceAware = false;

    SAXParserImpl(SAXParserFactory object, Hashtable hashtable) {
        try {
            this.xmlReader = new Driver();
        }
        catch (Exception exception) {
            throw new SAXException("could not create XPP2 driver for SAX2 " + exception, exception);
        }
        this.validating = ((SAXParserFactory)object).isValidating();
        String string = "http://xml.org/sax/features/validation";
        if (this.validating) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature(string, this.validating);
        this.namespaceAware = ((SAXParserFactory)object).isNamespaceAware();
        object = "http://xml.org/sax/features/namespaces";
        this.xmlReader.setFeature((String)object, this.namespaceAware);
        this.setFeatures(hashtable);
    }

    private void setFeatures(Hashtable hashtable) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = (Boolean)hashtable.get(string);
                this.xmlReader.setFeature(string, bl);
            }
        }
    }

    public Parser getParser() {
        if (this.parser == null) {
            this.parser = new XMLReaderAdapter(this.xmlReader);
            this.parser.setDocumentHandler(new HandlerBase());
        }
        return this.parser;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setProperty(String string, Object object) {
        this.xmlReader.setProperty(string, object);
    }

    public Object getProperty(String string) {
        return this.xmlReader.getProperty(string);
    }
}

