/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.sax2;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlPullParser;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlPullParserFactory;
import org.gjt.xpp.XmlStartTag;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Driver
implements Attributes,
Locator,
XMLReader {
    protected static final String DECLARATION_HANDLER_PROPERTY = "http://xml.org/sax/properties/declaration-handler";
    protected static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    protected static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String APACHE_SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    protected static final String APACHE_DYNAMIC_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/dynamic";
    protected ContentHandler contentHandler;
    protected ErrorHandler errorHandler;
    protected String systemId;
    protected XmlPullParser pp;
    protected XmlEndTag etag;
    protected XmlStartTag stag;
    private static final boolean DEBUG = false;
    private char[] buf = new char[1024];
    private String[] namespaces = new String[5];
    private String[] prefixes = new String[5];

    public Driver() {
        this.contentHandler = new DefaultHandler();
        this.errorHandler = new DefaultHandler();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        xmlPullParserFactory.setNamespaceAware(true);
        this.pp = xmlPullParserFactory.newPullParser();
        this.etag = xmlPullParserFactory.newEndTag();
        this.stag = xmlPullParserFactory.newStartTag();
    }

    public int getLength() {
        return this.stag.getAttributeCount();
    }

    public String getURI(int n2) {
        return this.stag.getAttributeNamespaceUri(n2);
    }

    public String getLocalName(int n2) {
        return this.stag.getAttributeLocalName(n2);
    }

    public String getQName(int n2) {
        return this.stag.getAttributeRawName(n2);
    }

    public String getType(int n2) {
        return "CDATA";
    }

    public String getValue(int n2) {
        return this.stag.getAttributeValue(n2);
    }

    public int getIndex(String string, String string2) {
        int n2 = 0;
        while (n2 < this.stag.getAttributeCount()) {
            if (this.stag.getAttributeNamespaceUri(n2).equals(string) && this.stag.getAttributeLocalName(n2).equals(string2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getIndex(String string) {
        int n2 = 0;
        while (n2 < this.stag.getAttributeCount()) {
            if (this.stag.getAttributeRawName(n2).equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public String getType(String string, String string2) {
        return "CDATA";
    }

    public String getType(String string) {
        return "CDATA";
    }

    public String getValue(String string, String string2) {
        return this.stag.getAttributeValueFromName(string, string2);
    }

    public String getValue(String string) {
        return this.stag.getAttributeValueFromRawName(string);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.pp.getLineNumber();
    }

    public int getColumnNumber() {
        return this.pp.getColumnNumber();
    }

    public boolean getFeature(String string) {
        if (NAMESPACES_FEATURE.equals(string)) {
            return this.pp.isNamespaceAware();
        }
        if (NAMESPACE_PREFIXES_FEATURE.equals(string)) {
            return this.pp.isNamespaceAttributesReporting();
        }
        if (VALIDATION_FEATURE.equals(string)) {
            return false;
        }
        if (APACHE_SCHEMA_VALIDATION_FEATURE.equals(string)) {
            return false;
        }
        if (APACHE_DYNAMIC_VALIDATION_FEATURE.equals(string)) {
            return false;
        }
        throw new SAXNotRecognizedException("unrecognized feature " + string);
    }

    public void setFeature(String string, boolean bl) {
        block11: {
            try {
                if (NAMESPACES_FEATURE.equals(string)) {
                    this.pp.setNamespaceAware(bl);
                    break block11;
                }
                if (NAMESPACE_PREFIXES_FEATURE.equals(string)) {
                    this.pp.setNamespaceAttributesReporting(bl);
                    break block11;
                }
                if (VALIDATION_FEATURE.equals(string)) {
                    if (bl) {
                        throw new SAXNotSupportedException("validation is not supported");
                    }
                } else if (!APACHE_SCHEMA_VALIDATION_FEATURE.equals(string)) {
                    if (APACHE_DYNAMIC_VALIDATION_FEATURE.equals(string)) {
                        if (bl) {
                            throw new SAXNotSupportedException("dynamic validation is not supported");
                        }
                    } else {
                        throw new SAXNotRecognizedException("unrecognized feature " + string);
                    }
                }
                return;
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new SAXNotSupportedException("problem with setting feature " + string + ": " + xmlPullParserException);
            }
        }
    }

    public Object getProperty(String string) {
        if (DECLARATION_HANDLER_PROPERTY.equals(string)) {
            return null;
        }
        if (LEXICAL_HANDLER_PROPERTY.equals(string)) {
            return null;
        }
        throw new SAXNotRecognizedException("not recognized get property " + string);
    }

    public void setProperty(String string, Object object) {
        if (DECLARATION_HANDLER_PROPERTY.equals(string)) {
            throw new SAXNotSupportedException("not supported setting property " + string);
        }
        if (LEXICAL_HANDLER_PROPERTY.equals(string)) {
            throw new SAXNotSupportedException("not supported setting property " + string);
        }
        throw new SAXNotRecognizedException("not recognized set property " + string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(InputSource object) {
        Object object2;
        this.systemId = ((InputSource)object).getSystemId();
        this.contentHandler.setDocumentLocator(this);
        Object object3 = ((InputSource)object).getCharacterStream();
        if (object3 == null) {
            object3 = ((InputSource)object).getByteStream();
            object2 = ((InputSource)object).getEncoding();
            if (object3 == null) {
                this.systemId = ((InputSource)object).getSystemId();
                if (this.systemId == null) {
                    object = new SAXParseException("null source systemId", this);
                    this.errorHandler.fatalError((SAXParseException)object);
                    return;
                }
                try {
                    object = new URL(this.systemId);
                    object3 = ((URL)object).openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        object3 = new FileInputStream(this.systemId);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        SAXParseException sAXParseException = new SAXParseException("could not open file with systemId " + this.systemId, this, fileNotFoundException);
                        this.errorHandler.fatalError(sAXParseException);
                        return;
                    }
                }
            }
            if (object2 == null) {
                object3 = new InputStreamReader((InputStream)object3);
            } else {
                try {
                    object3 = new InputStreamReader((InputStream)object3, (String)object2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SAXParseException sAXParseException = new SAXParseException("cant create input stream reader for encoding " + (String)object2, this, unsupportedEncodingException);
                    this.errorHandler.fatalError(sAXParseException);
                    return;
                }
            }
        }
        try {
            this.pp.setInput((Reader)object3);
            this.contentHandler.startDocument();
            this.pp.next();
            if (this.pp.getEventType() != 2) {
                object3 = new SAXParseException("expected start tag not" + this.pp.getPosDesc(), this);
                this.errorHandler.fatalError((SAXParseException)object3);
                return;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            object2 = new SAXParseException("parsing initialization error: " + xmlPullParserException, this, xmlPullParserException);
            this.errorHandler.fatalError((SAXParseException)object2);
            return;
        }
        Driver driver = this;
        driver.parseSubTree(driver.pp);
        this.contentHandler.endDocument();
    }

    public void parse(String string) {
        this.parse(new InputSource(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseSubTree(XmlPullParser xmlPullParser) {
        try {
            if (xmlPullParser.getEventType() != 2) {
                throw new SAXException("start tag must be read before skiping subtree" + xmlPullParser.getPosDesc());
            }
            int n2 = 2;
            while (true) {
                switch (n2) {
                    case 2: {
                        int n3;
                        xmlPullParser.readStartTag(this.stag);
                        XmlPullParser xmlPullParser2 = xmlPullParser;
                        n2 = xmlPullParser2.getNamespacesLength(xmlPullParser2.getDepth());
                        if (n2 > 0) {
                            if (this.namespaces.length < n2) {
                                this.namespaces = new String[n2];
                                this.prefixes = new String[n2];
                            }
                            XmlPullParser xmlPullParser3 = xmlPullParser;
                            xmlPullParser3.readNamespacesPrefixes(xmlPullParser3.getDepth(), this.prefixes, 0, n2);
                            XmlPullParser xmlPullParser4 = xmlPullParser;
                            xmlPullParser4.readNamespacesUris(xmlPullParser4.getDepth(), this.namespaces, 0, n2);
                            n3 = 0;
                            while (n3 < n2) {
                                this.contentHandler.startPrefixMapping(this.prefixes[n3], this.namespaces[n3]);
                                ++n3;
                            }
                        }
                        this.contentHandler.startElement(this.stag.getNamespaceUri(), this.stag.getLocalName(), this.stag.getRawName(), this);
                        break;
                    }
                    case 4: {
                        String string = xmlPullParser.readContent();
                        int n3 = string.length();
                        if (n3 > this.buf.length) {
                            this.buf = new char[n3];
                        }
                        string.getChars(0, n3, this.buf, 0);
                        this.contentHandler.characters(this.buf, 0, n3);
                        break;
                    }
                    case 3: {
                        xmlPullParser.readEndTag(this.etag);
                        XmlPullParser xmlPullParser5 = xmlPullParser;
                        n2 = xmlPullParser5.getNamespacesLength(xmlPullParser5.getDepth());
                        this.contentHandler.endElement(this.etag.getNamespaceUri(), this.etag.getLocalName(), this.etag.getRawName());
                        if (n2 <= 0) break;
                        if (this.namespaces.length < n2) {
                            this.namespaces = new String[n2];
                            this.prefixes = new String[n2];
                        }
                        XmlPullParser xmlPullParser6 = xmlPullParser;
                        xmlPullParser6.readNamespacesPrefixes(xmlPullParser6.getDepth(), this.prefixes, 0, n2);
                        XmlPullParser xmlPullParser7 = xmlPullParser;
                        xmlPullParser7.readNamespacesUris(xmlPullParser7.getDepth(), this.namespaces, 0, n2);
                        --n2;
                        while (n2 >= 0) {
                            this.contentHandler.endPrefixMapping(this.prefixes[n2]);
                            --n2;
                        }
                        break;
                    }
                    case 1: {
                        return;
                    }
                }
                n2 = xmlPullParser.next();
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            SAXParseException sAXParseException = new SAXParseException("parsing error: " + xmlPullParserException, this, xmlPullParserException);
            this.errorHandler.fatalError(sAXParseException);
        }
    }
}

